/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.junit5.context;

import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.test.common.annotation.InjectBundleContext;
import org.osgi.test.common.context.CloseableBundleContext;
import org.osgi.test.common.inject.TargetType;
import org.osgi.test.common.install.BundleInstaller;
import org.osgi.test.junit5.context.BundleInstallerExtension;
import org.osgi.test.junit5.inject.InjectingExtension;

@ExtendWith(value={BundleInstallerExtension.class})
public class BundleContextExtension
extends InjectingExtension<InjectBundleContext> {
    public static final String BUNDLE_CONTEXT_KEY = "bundle.context";
    @Deprecated
    public static final String INSTALL_BUNDLE_KEY = "bundle.installer";

    public BundleContextExtension() {
        super(InjectBundleContext.class, BundleContext.class);
    }

    public static BundleContext getBundleContext(ExtensionContext extensionContext) {
        BundleContext bundleContext = ((CloseableResourceBundleContext)BundleContextExtension.getStore(extensionContext).getOrComputeIfAbsent((Object)BUNDLE_CONTEXT_KEY, key -> new CloseableResourceBundleContext(BundleContextExtension.getParentBundleContext(extensionContext)), CloseableResourceBundleContext.class)).get();
        return bundleContext;
    }

    @Deprecated
    public static BundleInstaller getBundleInstaller(ExtensionContext extensionContext) {
        return BundleInstallerExtension.getBundleInstaller(extensionContext);
    }

    private static BundleContext getParentBundleContext(ExtensionContext extensionContext) {
        BundleContext parentContext = extensionContext.getParent().filter(context -> context.getTestClass().isPresent()).map(BundleContextExtension::getBundleContext).orElseGet(() -> FrameworkUtil.getBundle((Class)extensionContext.getRequiredTestClass()).getBundleContext());
        return parentContext;
    }

    static ExtensionContext.Store getStore(ExtensionContext extensionContext) {
        return extensionContext.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{BundleContextExtension.class, extensionContext.getUniqueId()}));
    }

    @Override
    protected Object resolveValue(TargetType targetType, InjectBundleContext injection, ExtensionContext extensionContext) throws ParameterResolutionException {
        return BundleContextExtension.getBundleContext(extensionContext);
    }

    public static class CloseableResourceBundleContext
    implements ExtensionContext.Store.CloseableResource {
        private final BundleContext bundleContext;

        CloseableResourceBundleContext(BundleContext bundleContext) {
            this.bundleContext = CloseableBundleContext.proxy((BundleContext)bundleContext);
        }

        public void close() throws Exception {
            ((AutoCloseable)this.get()).close();
        }

        public BundleContext get() {
            return this.bundleContext;
        }

        public String toString() {
            return this.get().toString();
        }
    }
}

