/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.junit5.bundle;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.test.junit5.bundle.BundleSource;
import org.osgi.test.junit5.context.BundleContextExtension;

public class BundleArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<BundleSource> {
    private BundleSource bundleSource;

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
        BundleContext bundleContext = BundleContextExtension.getBundleContext(context);
        return BundleArgumentsProvider.filterBundleByAnnotation(bundleContext, this.bundleSource);
    }

    static Stream<Arguments> filterBundleByAnnotation(BundleContext bundleContext, BundleSource annotation) throws InvalidSyntaxException {
        String headerFilter = annotation.headerFilter();
        Filter filter = headerFilter.isEmpty() ? null : bundleContext.createFilter(headerFilter);
        Bundle[] bundles = bundleContext.getBundles();
        return Arrays.stream(bundles).filter(Objects::nonNull).filter(bundle -> {
            if (annotation.symbolicNamePattern().length == 0) {
                return true;
            }
            return Arrays.stream(annotation.symbolicNamePattern()).anyMatch(symbolicNamePattern -> bundle.getSymbolicName().matches((String)symbolicNamePattern));
        }).filter(bundle -> (bundle.getState() & annotation.stateMask()) != 0).filter(bundle -> {
            if (filter == null) {
                return true;
            }
            return filter.match(bundle.getHeaders());
        }).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    public void accept(BundleSource annotation) {
        this.bundleSource = annotation;
    }
}

