/*******************************************************************************
 * Copyright (c) Contributors to the Eclipse Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0 
 *******************************************************************************/

package org.osgi.service.servlet.runtime.dto;

/**
 * Represents a {@code jakarta.servlet.Servlet} currently being used by a servlet
 * context.
 * 
 * @NotThreadSafe
 * @author $Id: 61a5c684d79094916514bd3ef1053763b5857121 $
 */
public class ServletDTO extends BaseServletDTO {
	/**
	 * The request mappings for the servlet.
	 * <p>
	 * The specified patterns are used to determine whether a request is mapped
	 * to the servlet. This array is never {@code null}. It might be empty for
	 * named servlets.
	 */
	public String[]				patterns;

	/**
	 * Specifies whether multipart support is enabled.
	 */
	public boolean				multipartEnabled;

	/**
	 * Specifies the size threshold after which the file will be written to
	 * disk. If multipart is not enabled for this servlet, {@code 0} is
	 * returned.
	 * 
	 * @see #multipartEnabled
	 */
	public int					multipartFileSizeThreshold;

	/**
	 * Specifies the location where the files can be stored on disk. If
	 * multipart is not enabled for this servlet, {@code null} is returned.
	 * 
	 * @see #multipartEnabled
	 */
	public String				multipartLocation;

	/**
	 * Specifies the maximum size of a file being uploaded. If multipart is not
	 * enabled for this servlet, {@code 0} is returned.
	 * 
	 * @see #multipartEnabled
	 */
	public long					multipartMaxFileSize;

	/**
	 * Specifies the maximum request size. If multipart is not enabled for this
	 * servlet, {@code 0} is returned.
	 * 
	 * @see #multipartEnabled
	 */
	public long					multipartMaxRequestSize;
}
