/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.CylindricalProjection;

public class MillerProjection
extends CylindricalProjection {
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        out.x = lplam;
        out.y = Math.log(Math.tan(0.7853981633974483 + lpphi * 0.4)) * 1.25;
        return out;
    }

    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate out) {
        out.x = xyx;
        out.y = 2.5 * (Math.atan(Math.exp(0.8 * xyy)) - 0.7853981633974483);
        return out;
    }

    public boolean hasInverse() {
        return true;
    }

    public String toString() {
        return "Miller Cylindrical";
    }
}

