/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.pas.optional.solver.move;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.examples.pas.domain.Bed;
import org.optaplanner.examples.pas.domain.BedDesignation;
import org.optaplanner.examples.pas.domain.PatientAdmissionSchedule;
import org.optaplanner.examples.pas.solver.move.PatientAdmissionMoveHelper;

public class BedDesignationSwapMove
extends AbstractMove<PatientAdmissionSchedule> {
    private BedDesignation leftBedDesignation;
    private BedDesignation rightBedDesignation;

    public BedDesignationSwapMove(BedDesignation leftBedDesignation, BedDesignation rightBedDesignation) {
        this.leftBedDesignation = leftBedDesignation;
        this.rightBedDesignation = rightBedDesignation;
    }

    public boolean isMoveDoable(ScoreDirector<PatientAdmissionSchedule> scoreDirector) {
        return !Objects.equals(this.leftBedDesignation.getBed(), this.rightBedDesignation.getBed());
    }

    public BedDesignationSwapMove createUndoMove(ScoreDirector<PatientAdmissionSchedule> scoreDirector) {
        return new BedDesignationSwapMove(this.rightBedDesignation, this.leftBedDesignation);
    }

    protected void doMoveOnGenuineVariables(ScoreDirector<PatientAdmissionSchedule> scoreDirector) {
        Bed oldLeftBed = this.leftBedDesignation.getBed();
        Bed oldRightBed = this.rightBedDesignation.getBed();
        PatientAdmissionMoveHelper.moveBed(scoreDirector, this.leftBedDesignation, oldRightBed);
        PatientAdmissionMoveHelper.moveBed(scoreDirector, this.rightBedDesignation, oldLeftBed);
    }

    public BedDesignationSwapMove rebase(ScoreDirector<PatientAdmissionSchedule> destinationScoreDirector) {
        return new BedDesignationSwapMove((BedDesignation)destinationScoreDirector.lookUpWorkingObject((Object)this.leftBedDesignation), (BedDesignation)destinationScoreDirector.lookUpWorkingObject((Object)this.rightBedDesignation));
    }

    public Collection<? extends Object> getPlanningEntities() {
        return Arrays.asList(this.leftBedDesignation, this.rightBedDesignation);
    }

    public Collection<? extends Object> getPlanningValues() {
        return Arrays.asList(this.leftBedDesignation.getBed(), this.rightBedDesignation.getBed());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BedDesignationSwapMove other = (BedDesignationSwapMove)((Object)o);
        return Objects.equals(this.leftBedDesignation, other.leftBedDesignation) && Objects.equals(this.rightBedDesignation, other.rightBedDesignation);
    }

    public int hashCode() {
        return Objects.hash(this.leftBedDesignation, this.rightBedDesignation);
    }

    public String toString() {
        return this.leftBedDesignation + " {" + this.leftBedDesignation.getBed() + "} <-> " + this.rightBedDesignation + " {" + this.rightBedDesignation.getBed() + "}";
    }
}

