/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.conferencescheduling.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.business.SolutionBusiness;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceSolution;
import org.optaplanner.examples.conferencescheduling.persistence.ConferenceSchedulingCfpDevoxxImporter;

public class ConferenceCFPImportAction
implements CommonApp.ExtraAction<ConferenceSolution> {
    @Override
    public String getName() {
        return "Import from CFP";
    }

    @Override
    public BiConsumer<SolutionBusiness<ConferenceSolution, ?>, SolutionPanel<ConferenceSolution>> getConsumer() {
        return (solutionBusiness, solutionPanel) -> {
            String[] cfpArray = new String[]{"cfp-devoxx"};
            JComboBox<String> cfpConferenceBox = new JComboBox<String>(cfpArray);
            JTextField cfpRestUrlTextField = new JTextField("https://dvbe18.confinabox.com/api/conferences/DVBE18");
            Object[] dialogue = new Object[]{"Choose conference:", cfpConferenceBox, "Enter CFP REST Url:", cfpRestUrlTextField};
            int option = JOptionPane.showConfirmDialog(solutionPanel, dialogue, "Import", 2);
            if (option == 0) {
                String conferenceBaseUrl = cfpRestUrlTextField.getText();
                new ConferenceCFPImportWorker((SolutionBusiness<ConferenceSolution, ?>)solutionBusiness, (SolutionPanel<ConferenceSolution>)solutionPanel, conferenceBaseUrl).executeAndShowDialog();
            }
        };
    }

    private class ConferenceCFPImportWorker
    extends SwingWorker<ConferenceSolution, Void> {
        private final SolutionBusiness<ConferenceSolution, ?> solutionBusiness;
        private final SolutionPanel<ConferenceSolution> solutionPanel;
        private String conferenceBaseUrl;
        private final JDialog dialog;

        public ConferenceCFPImportWorker(SolutionBusiness<ConferenceSolution, ?> solutionBusiness, SolutionPanel<ConferenceSolution> solutionPanel, String conferenceBaseUrl) {
            this.solutionBusiness = solutionBusiness;
            this.solutionPanel = solutionPanel;
            this.conferenceBaseUrl = conferenceBaseUrl;
            this.dialog = new JDialog((Frame)solutionPanel.getSolverAndPersistenceFrame(), true);
            JPanel contentPane = new JPanel(new BorderLayout(10, 10));
            contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            contentPane.add((Component)new JLabel("Importing CFP data in progress..."), "North");
            JProgressBar progressBar = new JProgressBar(0);
            progressBar.setIndeterminate(true);
            contentPane.add((Component)progressBar, "Center");
            JButton button = new JButton("Cancel");
            button.addActionListener(e -> this.cancel(false));
            contentPane.add((Component)button, "South");
            this.dialog.setContentPane(contentPane);
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    ConferenceCFPImportWorker.this.cancel(false);
                }
            });
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(solutionPanel.getSolverAndPersistenceFrame());
        }

        public void executeAndShowDialog() {
            this.execute();
            this.dialog.setVisible(true);
        }

        @Override
        protected ConferenceSolution doInBackground() {
            return new ConferenceSchedulingCfpDevoxxImporter(this.conferenceBaseUrl).importSolution();
        }

        @Override
        protected void done() {
            ConferenceSolution cfpProblem;
            this.dialog.dispose();
            if (this.isCancelled()) {
                return;
            }
            try {
                cfpProblem = (ConferenceSolution)this.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Importing was interrupted.", e);
            }
            catch (ExecutionException e) {
                JOptionPane.showMessageDialog(this.solutionPanel, "CFP import failed.\nThe next dialog will explain the cause.\n\nFix it in ConferenceSchedulingCfpDevoxxImporter.java in the optaplanner repository.");
                throw new IllegalStateException("Importing failed.", e.getCause());
            }
            this.solutionBusiness.setSolution(cfpProblem);
            this.solutionBusiness.setSolutionFileName(this.solutionBusiness.getSolution().getConferenceName());
            JOptionPane.showMessageDialog(this.solutionPanel, "CFP data imported successfully.");
            this.solutionPanel.getSolverAndPersistenceFrame().setSolutionLoaded(null);
        }
    }
}

