/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cheaptime.optional.score.drools;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.optaplanner.examples.cheaptime.domain.Machine;
import org.optaplanner.examples.cheaptime.domain.Task;
import org.optaplanner.examples.cheaptime.domain.TaskAssignment;
import org.optaplanner.examples.cheaptime.domain.TaskRequirement;

public class MachinePeriodPart
implements Comparable<MachinePeriodPart> {
    private static final Comparator<MachinePeriodPart> COMPARATOR = Comparator.comparing(machinePeriodPart -> machinePeriodPart.machine.getIndex()).thenComparingInt(MachinePeriodPart::getPeriod).thenComparing(MachinePeriodPart::isActive).thenComparingInt(machinePeriodPart -> machinePeriodPart.resourceAvailableList.length);
    private final Machine machine;
    private final int period;
    private boolean active;
    private int[] resourceAvailableList;
    private int resourceInShortTotal;

    public MachinePeriodPart(Machine machine, int period, int resourceListSize, List<TaskAssignment> taskAssignmentList) {
        this.machine = machine;
        this.period = period;
        this.active = false;
        this.resourceAvailableList = new int[resourceListSize];
        for (int i = 0; i < resourceListSize; ++i) {
            this.resourceAvailableList[i] = machine.getMachineCapacityList().get(i).getCapacity();
        }
        for (TaskAssignment taskAssignment : taskAssignmentList) {
            this.addTaskAssignment(taskAssignment);
        }
        this.resourceInShortTotal = 0;
        for (Object resourceAvailable : (Object)this.resourceAvailableList) {
            if (resourceAvailable >= 0) continue;
            this.resourceInShortTotal += resourceAvailable;
        }
    }

    private void addTaskAssignment(TaskAssignment taskAssignment) {
        this.active = true;
        Task task = taskAssignment.getTask();
        int i = 0;
        while (i < this.resourceAvailableList.length) {
            TaskRequirement taskRequirement = task.getTaskRequirementList().get(i);
            int n = i++;
            this.resourceAvailableList[n] = this.resourceAvailableList[n] - taskRequirement.getResourceUsage();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public int[] getResourceAvailableList() {
        return this.resourceAvailableList;
    }

    public void setResourceAvailableList(int[] resourceAvailableList) {
        this.resourceAvailableList = resourceAvailableList;
    }

    public int getResourceInShortTotal() {
        return this.resourceInShortTotal;
    }

    public Machine getMachine() {
        return this.machine;
    }

    public int getPeriod() {
        return this.period;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MachinePeriodPart other = (MachinePeriodPart)o;
        return Objects.equals(this.machine, other.machine) && this.period == other.period && this.active == other.active && Arrays.equals(this.resourceAvailableList, other.resourceAvailableList);
    }

    public int hashCode() {
        return Objects.hash(this.machine, this.period, this.active, Arrays.hashCode(this.resourceAvailableList));
    }

    @Override
    public int compareTo(MachinePeriodPart other) {
        return COMPARATOR.compare(this, other);
    }

    public String toString() {
        return this.machine + ", period = " + this.period + ", active = " + this.active + ", resourceAvailableList = " + Arrays.toString(this.resourceAvailableList);
    }
}

