/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.curriculumcourse.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Set;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.entity.PlanningPin;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.swingui.components.Labeled;
import org.optaplanner.examples.curriculumcourse.domain.Course;
import org.optaplanner.examples.curriculumcourse.domain.Curriculum;
import org.optaplanner.examples.curriculumcourse.domain.Day;
import org.optaplanner.examples.curriculumcourse.domain.Period;
import org.optaplanner.examples.curriculumcourse.domain.Room;
import org.optaplanner.examples.curriculumcourse.domain.Teacher;
import org.optaplanner.examples.curriculumcourse.domain.solver.LectureDifficultyWeightFactory;
import org.optaplanner.examples.curriculumcourse.domain.solver.PeriodStrengthWeightFactory;
import org.optaplanner.examples.curriculumcourse.domain.solver.RoomStrengthWeightFactory;

@PlanningEntity(difficultyWeightFactoryClass=LectureDifficultyWeightFactory.class)
public class Lecture
extends AbstractPersistable
implements Labeled {
    private Course course;
    private int lectureIndexInCourse;
    private boolean pinned;
    private Period period;
    private Room room;

    public Lecture() {
    }

    public Lecture(long id, Course course, int lectureIndexInCourse, boolean pinned) {
        super(id);
        this.course = course;
        this.lectureIndexInCourse = lectureIndexInCourse;
        this.pinned = pinned;
    }

    public Lecture(long id, Course course, Period period, Room room) {
        super(id);
        this.course = course;
        this.period = period;
        this.room = room;
    }

    public Course getCourse() {
        return this.course;
    }

    public void setCourse(Course course) {
        this.course = course;
    }

    public int getLectureIndexInCourse() {
        return this.lectureIndexInCourse;
    }

    public void setLectureIndexInCourse(int lectureIndexInCourse) {
        this.lectureIndexInCourse = lectureIndexInCourse;
    }

    @PlanningPin
    public boolean isPinned() {
        return this.pinned;
    }

    public void setPinned(boolean pinned) {
        this.pinned = pinned;
    }

    @PlanningVariable(valueRangeProviderRefs={"periodRange"}, strengthWeightFactoryClass=PeriodStrengthWeightFactory.class)
    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    @PlanningVariable(valueRangeProviderRefs={"roomRange"}, strengthWeightFactoryClass=RoomStrengthWeightFactory.class)
    public Room getRoom() {
        return this.room;
    }

    public void setRoom(Room room) {
        this.room = room;
    }

    @JsonIgnore
    public Teacher getTeacher() {
        return this.course.getTeacher();
    }

    @JsonIgnore
    public int getStudentSize() {
        return this.course.getStudentSize();
    }

    @JsonIgnore
    public Set<Curriculum> getCurriculumSet() {
        return this.course.getCurriculumSet();
    }

    @JsonIgnore
    public Day getDay() {
        if (this.period == null) {
            return null;
        }
        return this.period.getDay();
    }

    @JsonIgnore
    public int getTimeslotIndex() {
        if (this.period == null) {
            return Integer.MIN_VALUE;
        }
        return this.period.getTimeslot().getTimeslotIndex();
    }

    @Override
    public String getLabel() {
        return this.course.getCode() + "-" + this.lectureIndexInCourse;
    }

    @Override
    public String toString() {
        return this.course + "-" + this.lectureIndexInCourse;
    }
}

