/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence.jackson;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import org.optaplanner.examples.common.domain.AbstractPersistable;

public final class JacksonUniqueIdGenerator
extends ObjectIdGenerator<String> {
    private final Class<?> scope = Object.class;

    public Class<?> getScope() {
        return this.scope;
    }

    public boolean canUseFor(ObjectIdGenerator<?> gen) {
        return gen.getClass() == ((Object)((Object)this)).getClass();
    }

    public ObjectIdGenerator<String> forScope(Class<?> scope) {
        return this;
    }

    public ObjectIdGenerator<String> newForSerialization(Object context) {
        return this;
    }

    public ObjectIdGenerator.IdKey key(Object key) {
        if (key == null) {
            return null;
        }
        return new ObjectIdGenerator.IdKey(((Object)((Object)this)).getClass(), null, key);
    }

    public String generateId(Object forPojo) {
        return forPojo.getClass().getSimpleName() + "#" + ((AbstractPersistable)forPojo).getId();
    }
}

