/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.flightcrewscheduling.swingui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import org.optaplanner.examples.common.swingui.latitudelongitude.LatitudeLongitudeTranslator;
import org.optaplanner.examples.flightcrewscheduling.domain.Airport;
import org.optaplanner.examples.flightcrewscheduling.domain.Flight;
import org.optaplanner.examples.flightcrewscheduling.domain.FlightCrewSolution;
import org.optaplanner.examples.flightcrewscheduling.swingui.FlightCrewSchedulingPanel;
import org.optaplanner.swing.impl.TangoColorFactory;

public class FlightCrewSchedulingWorldPanel
extends JPanel {
    private static final int TEXT_SIZE = 12;
    private static final int LOCATION_NAME_TEXT_SIZE = 8;
    protected static final DateTimeFormatter DAY_FORMATTER = DateTimeFormatter.ofPattern("E yyyy-MM-dd", Locale.ENGLISH);
    private final FlightCrewSchedulingPanel flightCrewSchedulingPanel;
    private BufferedImage canvas = null;
    private LatitudeLongitudeTranslator translator = null;

    public FlightCrewSchedulingWorldPanel(FlightCrewSchedulingPanel flightCrewSchedulingPanel) {
        this.flightCrewSchedulingPanel = flightCrewSchedulingPanel;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                FlightCrewSolution solution = (FlightCrewSolution)FlightCrewSchedulingWorldPanel.this.flightCrewSchedulingPanel.getSolution();
                if (solution != null) {
                    FlightCrewSchedulingWorldPanel.this.resetPanel(solution);
                }
            }
        });
    }

    public void resetPanel(FlightCrewSolution solution) {
        this.translator = new LatitudeLongitudeTranslator();
        for (Airport airport : solution.getAirportList()) {
            this.translator.addCoordinates(airport.getLatitude(), airport.getLongitude());
        }
        Dimension size = this.getSize();
        double width = size.getWidth();
        double height = size.getHeight();
        this.translator.prepareFor(width, height);
        Graphics2D g = this.createCanvas(width, height);
        g.setFont(g.getFont().deriveFont(8.0f));
        g.setColor(TangoColorFactory.PLUM_2);
        for (Airport airport : solution.getAirportList()) {
            int x = this.translator.translateLongitudeToX(airport.getLongitude());
            int y = this.translator.translateLatitudeToY(airport.getLatitude());
            g.fillRect(x - 1, y - 1, 3, 3);
            g.drawString(StringUtils.abbreviate((String)airport.getCode(), (int)20), x + 3, y - 3);
        }
        g.setColor(TangoColorFactory.CHOCOLATE_1);
        for (Flight flight : solution.getFlightList()) {
            Airport departureAirport = flight.getDepartureAirport();
            Airport arrivalAirport = flight.getArrivalAirport();
            this.translator.drawRoute(g, departureAirport.getLongitude(), departureAirport.getLatitude(), arrivalAirport.getLongitude(), arrivalAirport.getLatitude(), true, false);
        }
        g.setFont(g.getFont().deriveFont(12.0f));
        g.setColor(TangoColorFactory.PLUM_2);
        g.fillRect(6, (int)height - 11, 3, 3);
        g.drawString("Airport", 15, (int)height - 5);
        this.repaint();
    }

    public void updatePanel(FlightCrewSolution solution) {
        this.resetPanel(solution);
    }

    private Graphics2D createCanvas(double width, double height) {
        int canvasWidth = (int)Math.ceil(width) + 1;
        int canvasHeight = (int)Math.ceil(height) + 1;
        this.canvas = new BufferedImage(canvasWidth, canvasHeight, 1);
        Graphics2D g = this.canvas.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, canvasWidth, canvasHeight);
        return g;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.canvas != null) {
            g.drawImage(this.canvas, 0, 0, this);
        }
    }
}

