/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.conferencescheduling.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceSolution;
import org.optaplanner.examples.conferencescheduling.persistence.ConferenceSchedulingCfpDevoxxImporter;
import org.optaplanner.examples.conferencescheduling.persistence.ConferenceSchedulingXlsxFileIO;

public class ConferenceSchedulingPanel
extends SolutionPanel<ConferenceSolution> {
    public static final String LOGO_PATH = "/org/optaplanner/examples/conferencescheduling/swingui/conferenceSchedulingLogo.png";

    public ConferenceSchedulingPanel() {
        JButton importConferenceButton = new JButton("Import from CFP");
        importConferenceButton.addActionListener(event -> {
            String[] cfpArray = new String[]{"devoxx-cfp"};
            JComboBox<String> cfpConferenceBox = new JComboBox<String>(cfpArray);
            JTextField cfpRestUrlTextField = new JTextField("https://dvbe18.confinabox.com/api/conferences/DVBE18");
            Object[] dialogue = new Object[]{"Choose conference:", cfpConferenceBox, "Enter CFP REST Url:", cfpRestUrlTextField};
            int option = JOptionPane.showConfirmDialog(this, dialogue, "Import", 2);
            if (option == 0) {
                String conferenceBaseUrl = cfpRestUrlTextField.getText();
                new ImporterWorker(conferenceBaseUrl).execute();
                JOptionPane.showMessageDialog(this, "Importing CFP data in progress ...");
            }
        });
        JButton publishButton = new JButton("Publish");
        publishButton.addActionListener(actionEvent -> ((ConferenceSolution)this.solutionBusiness.getSolution()).getTalkList().forEach(talk -> {
            talk.setPublishedTimeslot(talk.getTimeslot());
            talk.setPublishedRoom(talk.getRoom());
        }));
        JButton showInLibreOfficeOrExcelButton = new JButton("Show in LibreOffice or Excel");
        showInLibreOfficeOrExcelButton.addActionListener(event -> {
            File tempFile;
            ConferenceSchedulingXlsxFileIO solutionFileIO = new ConferenceSchedulingXlsxFileIO();
            try {
                tempFile = File.createTempFile(this.solutionBusiness.getSolutionFileName(), "." + solutionFileIO.getOutputFileExtension());
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create temp file.", e);
            }
            solutionFileIO.write(this.solutionBusiness.getSolution(), tempFile);
            try {
                Desktop.getDesktop().open(tempFile);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to show temp file (" + tempFile + ") in LibreOffice or Excel.", e);
            }
        });
        JPanel showPanel = new JPanel();
        JPanel importPanel = new JPanel();
        showPanel.setLayout(new FlowLayout(0));
        importPanel.setLayout(new FlowLayout(0));
        showPanel.add(showInLibreOfficeOrExcelButton);
        showPanel.add(new JLabel("Changes to that file are ignored unless you explicitly save it there and open it here."));
        importPanel.add(importConferenceButton);
        importPanel.add(publishButton);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new GridLayout(2, 1));
        buttonsPanel.add(showPanel);
        buttonsPanel.add(importPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)buttonsPanel, "North");
    }

    @Override
    public void resetPanel(ConferenceSolution solution) {
    }

    private class ImporterWorker
    extends SwingWorker<ConferenceSolution, Void> {
        private String conferenceBaseUrl;

        public ImporterWorker(String conferenceBaseUrl) {
            this.conferenceBaseUrl = conferenceBaseUrl;
        }

        @Override
        protected ConferenceSolution doInBackground() throws Exception {
            return new ConferenceSchedulingCfpDevoxxImporter(this.conferenceBaseUrl).importSolution();
        }

        @Override
        protected void done() {
            try {
                ConferenceSolution cfpProblem = (ConferenceSolution)this.get();
                ConferenceSchedulingPanel.this.solutionBusiness.setSolution(cfpProblem);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Importing was interrupted.", e);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("Importing failed.", e.getCause());
            }
            finally {
                JOptionPane.showMessageDialog(ConferenceSchedulingPanel.this, "CFP data imported successfully.");
            }
        }
    }
}

