/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.domain.location;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.persistence.jackson.JacksonUniqueIdGenerator;
import org.optaplanner.examples.vehiclerouting.domain.location.AirLocation;
import org.optaplanner.examples.vehiclerouting.domain.location.RoadLocation;
import org.optaplanner.examples.vehiclerouting.domain.location.segmented.HubSegmentLocation;
import org.optaplanner.examples.vehiclerouting.domain.location.segmented.RoadSegmentLocation;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
@JsonSubTypes(value={@JsonSubTypes.Type(value=AirLocation.class, name="air"), @JsonSubTypes.Type(value=HubSegmentLocation.class, name="hubSegment"), @JsonSubTypes.Type(value=RoadLocation.class, name="road"), @JsonSubTypes.Type(value=RoadSegmentLocation.class, name="roadSegment")})
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonIdentityInfo(generator=JacksonUniqueIdGenerator.class)
public abstract class Location
extends AbstractPersistable {
    protected String name = null;
    protected double latitude;
    protected double longitude;

    public Location() {
    }

    public Location(long id) {
        super(id);
    }

    public Location(long id, double latitude, double longitude) {
        super(id);
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    @JsonIgnore
    public abstract long getDistanceTo(Location var1);

    @JsonIgnore
    public double getAirDistanceDoubleTo(Location location) {
        double latitudeDifference = location.latitude - this.latitude;
        double longitudeDifference = location.longitude - this.longitude;
        return Math.sqrt(latitudeDifference * latitudeDifference + longitudeDifference * longitudeDifference);
    }

    @JsonIgnore
    public double getAngle(Location location) {
        double latitudeDifference = location.latitude - this.latitude;
        double longitudeDifference = location.longitude - this.longitude;
        return Math.atan2(latitudeDifference, longitudeDifference);
    }

    @Override
    public String toString() {
        if (this.name == null) {
            return super.toString();
        }
        return this.name;
    }
}

