/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nurserostering.domain;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Map;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.persistence.jackson.JacksonUniqueIdGenerator;
import org.optaplanner.examples.common.persistence.jackson.KeySerializer;
import org.optaplanner.examples.common.swingui.components.Labeled;
import org.optaplanner.examples.nurserostering.domain.Shift;
import org.optaplanner.examples.nurserostering.domain.ShiftDate;
import org.optaplanner.examples.nurserostering.domain.ShiftDateKeyDeserializer;
import org.optaplanner.examples.nurserostering.domain.ShiftKeyDeserializer;
import org.optaplanner.examples.nurserostering.domain.contract.Contract;
import org.optaplanner.examples.nurserostering.domain.request.DayOffRequest;
import org.optaplanner.examples.nurserostering.domain.request.DayOnRequest;
import org.optaplanner.examples.nurserostering.domain.request.ShiftOffRequest;
import org.optaplanner.examples.nurserostering.domain.request.ShiftOnRequest;

@JsonIdentityInfo(generator=JacksonUniqueIdGenerator.class)
public class Employee
extends AbstractPersistable
implements Labeled,
Comparable<Employee> {
    private String code;
    private String name;
    private Contract contract;
    @JsonSerialize(keyUsing=KeySerializer.class)
    @JsonDeserialize(keyUsing=ShiftDateKeyDeserializer.class)
    private Map<ShiftDate, DayOffRequest> dayOffRequestMap;
    @JsonSerialize(keyUsing=KeySerializer.class)
    @JsonDeserialize(keyUsing=ShiftDateKeyDeserializer.class)
    private Map<ShiftDate, DayOnRequest> dayOnRequestMap;
    @JsonSerialize(keyUsing=KeySerializer.class)
    @JsonDeserialize(keyUsing=ShiftKeyDeserializer.class)
    private Map<Shift, ShiftOffRequest> shiftOffRequestMap;
    @JsonSerialize(keyUsing=KeySerializer.class)
    @JsonDeserialize(keyUsing=ShiftKeyDeserializer.class)
    private Map<Shift, ShiftOnRequest> shiftOnRequestMap;

    public Employee() {
    }

    public Employee(long id, String code, String name, Contract contract) {
        super(id);
        this.code = code;
        this.name = name;
        this.contract = contract;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Contract getContract() {
        return this.contract;
    }

    public void setContract(Contract contract) {
        this.contract = contract;
    }

    @JsonIgnore
    public int getWeekendLength() {
        return this.getContract().getWeekendLength();
    }

    public Map<ShiftDate, DayOffRequest> getDayOffRequestMap() {
        return this.dayOffRequestMap;
    }

    public void setDayOffRequestMap(Map<ShiftDate, DayOffRequest> dayOffRequestMap) {
        this.dayOffRequestMap = dayOffRequestMap;
    }

    public Map<ShiftDate, DayOnRequest> getDayOnRequestMap() {
        return this.dayOnRequestMap;
    }

    public void setDayOnRequestMap(Map<ShiftDate, DayOnRequest> dayOnRequestMap) {
        this.dayOnRequestMap = dayOnRequestMap;
    }

    public Map<Shift, ShiftOffRequest> getShiftOffRequestMap() {
        return this.shiftOffRequestMap;
    }

    public void setShiftOffRequestMap(Map<Shift, ShiftOffRequest> shiftOffRequestMap) {
        this.shiftOffRequestMap = shiftOffRequestMap;
    }

    public Map<Shift, ShiftOnRequest> getShiftOnRequestMap() {
        return this.shiftOnRequestMap;
    }

    public void setShiftOnRequestMap(Map<Shift, ShiftOnRequest> shiftOnRequestMap) {
        this.shiftOnRequestMap = shiftOnRequestMap;
    }

    @Override
    public String getLabel() {
        return "Employee " + this.name;
    }

    @Override
    public String toString() {
        if (this.name == null) {
            return super.toString();
        }
        return this.name;
    }

    @Override
    public int compareTo(Employee employee) {
        return this.name.compareTo(employee.name);
    }
}

