/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.meetingscheduling.score;

import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.examples.meetingscheduling.domain.Attendance;
import org.optaplanner.examples.meetingscheduling.domain.MeetingAssignment;
import org.optaplanner.examples.meetingscheduling.domain.PreferredAttendance;
import org.optaplanner.examples.meetingscheduling.domain.RequiredAttendance;
import org.optaplanner.examples.meetingscheduling.domain.Room;
import org.optaplanner.examples.meetingscheduling.domain.TimeGrain;

public class MeetingSchedulingConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.roomConflict(constraintFactory), this.avoidOvertime(constraintFactory), this.requiredAttendanceConflict(constraintFactory), this.requiredRoomCapacity(constraintFactory), this.startAndEndOnSameDay(constraintFactory), this.requiredAndPreferredAttendanceConflict(constraintFactory), this.preferredAttendanceConflict(constraintFactory), this.doMeetingsAsSoonAsPossible(constraintFactory), this.oneBreakBetweenConsecutiveMeetings(constraintFactory), this.overlappingMeetings(constraintFactory), this.assignLargerRoomsFirst(constraintFactory), this.roomStability(constraintFactory)};
    }

    protected Constraint roomConflict(ConstraintFactory constraintFactory) {
        return constraintFactory.forEachUniquePair(MeetingAssignment.class, Joiners.equal(MeetingAssignment::getRoom), Joiners.overlapping(assignment -> assignment.getStartingTimeGrain().getGrainIndex(), assignment -> assignment.getStartingTimeGrain().getGrainIndex() + assignment.getMeeting().getDurationInGrains())).penalizeConfigurable((leftAssignment, rightAssignment) -> rightAssignment.calculateOverlap((MeetingAssignment)leftAssignment)).asConstraint("Room conflict");
    }

    protected Constraint avoidOvertime(ConstraintFactory constraintFactory) {
        return constraintFactory.forEachIncludingNullVars(MeetingAssignment.class).filter(meetingAssignment -> meetingAssignment.getStartingTimeGrain() != null).ifNotExists(TimeGrain.class, Joiners.equal(MeetingAssignment::getLastTimeGrainIndex, TimeGrain::getGrainIndex)).penalizeConfigurable(MeetingAssignment::getLastTimeGrainIndex).asConstraint("Don't go in overtime");
    }

    protected Constraint requiredAttendanceConflict(ConstraintFactory constraintFactory) {
        return constraintFactory.forEachUniquePair(RequiredAttendance.class, Joiners.equal(Attendance::getPerson)).join(MeetingAssignment.class, Joiners.equal((leftRequiredAttendance, rightRequiredAttendance) -> leftRequiredAttendance.getMeeting(), MeetingAssignment::getMeeting)).join(MeetingAssignment.class, Joiners.equal((leftRequiredAttendance, rightRequiredAttendance, leftAssignment) -> rightRequiredAttendance.getMeeting(), MeetingAssignment::getMeeting), Joiners.overlapping((attendee1, attendee2, assignment) -> assignment.getStartingTimeGrain().getGrainIndex(), (attendee1, attendee2, assignment) -> assignment.getStartingTimeGrain().getGrainIndex() + assignment.getMeeting().getDurationInGrains(), assignment -> assignment.getStartingTimeGrain().getGrainIndex(), assignment -> assignment.getStartingTimeGrain().getGrainIndex() + assignment.getMeeting().getDurationInGrains())).penalizeConfigurable((leftRequiredAttendance, rightRequiredAttendance, leftAssignment, rightAssignment) -> rightAssignment.calculateOverlap((MeetingAssignment)leftAssignment)).asConstraint("Required attendance conflict");
    }

    protected Constraint requiredRoomCapacity(ConstraintFactory constraintFactory) {
        return constraintFactory.forEachIncludingNullVars(MeetingAssignment.class).filter(meetingAssignment -> meetingAssignment.getRequiredCapacity() > meetingAssignment.getRoomCapacity()).penalizeConfigurable(meetingAssignment -> meetingAssignment.getRequiredCapacity() - meetingAssignment.getRoomCapacity()).asConstraint("Required room capacity");
    }

    protected Constraint startAndEndOnSameDay(ConstraintFactory constraintFactory) {
        return constraintFactory.forEachIncludingNullVars(MeetingAssignment.class).filter(meetingAssignment -> meetingAssignment.getStartingTimeGrain() != null).join(TimeGrain.class, Joiners.equal(MeetingAssignment::getLastTimeGrainIndex, TimeGrain::getGrainIndex), Joiners.filtering((meetingAssignment, timeGrain) -> meetingAssignment.getStartingTimeGrain().getDay() != timeGrain.getDay())).penalizeConfigurable().asConstraint("Start and end on same day");
    }

    protected Constraint requiredAndPreferredAttendanceConflict(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(RequiredAttendance.class).join(PreferredAttendance.class, Joiners.equal(Attendance::getPerson, Attendance::getPerson)).join(constraintFactory.forEachIncludingNullVars(MeetingAssignment.class).filter(assignment -> assignment.getStartingTimeGrain() != null), Joiners.equal((requiredAttendance, preferredAttendance) -> requiredAttendance.getMeeting(), MeetingAssignment::getMeeting)).join(constraintFactory.forEachIncludingNullVars(MeetingAssignment.class).filter(assignment -> assignment.getStartingTimeGrain() != null), Joiners.equal((requiredAttendance, preferredAttendance, leftAssignment) -> preferredAttendance.getMeeting(), MeetingAssignment::getMeeting), Joiners.overlapping((attendee1, attendee2, assignment) -> assignment.getStartingTimeGrain().getGrainIndex(), (attendee1, attendee2, assignment) -> assignment.getStartingTimeGrain().getGrainIndex() + assignment.getMeeting().getDurationInGrains(), assignment -> assignment.getStartingTimeGrain().getGrainIndex(), assignment -> assignment.getStartingTimeGrain().getGrainIndex() + assignment.getMeeting().getDurationInGrains())).penalizeConfigurable((requiredAttendance, preferredAttendance, leftAssignment, rightAssignment) -> rightAssignment.calculateOverlap((MeetingAssignment)leftAssignment)).asConstraint("Required and preferred attendance conflict");
    }

    protected Constraint preferredAttendanceConflict(ConstraintFactory constraintFactory) {
        return constraintFactory.forEachUniquePair(PreferredAttendance.class, Joiners.equal(Attendance::getPerson)).join(constraintFactory.forEachIncludingNullVars(MeetingAssignment.class).filter(assignment -> assignment.getStartingTimeGrain() != null), Joiners.equal((leftAttendance, rightAttendance) -> leftAttendance.getMeeting(), MeetingAssignment::getMeeting)).join(constraintFactory.forEachIncludingNullVars(MeetingAssignment.class).filter(assignment -> assignment.getStartingTimeGrain() != null), Joiners.equal((leftAttendance, rightAttendance, leftAssignment) -> rightAttendance.getMeeting(), MeetingAssignment::getMeeting), Joiners.overlapping((attendee1, attendee2, assignment) -> assignment.getStartingTimeGrain().getGrainIndex(), (attendee1, attendee2, assignment) -> assignment.getStartingTimeGrain().getGrainIndex() + assignment.getMeeting().getDurationInGrains(), assignment -> assignment.getStartingTimeGrain().getGrainIndex(), assignment -> assignment.getStartingTimeGrain().getGrainIndex() + assignment.getMeeting().getDurationInGrains())).penalizeConfigurable((leftPreferredAttendance, rightPreferredAttendance, leftAssignment, rightAssignment) -> rightAssignment.calculateOverlap((MeetingAssignment)leftAssignment)).asConstraint("Preferred attendance conflict");
    }

    protected Constraint doMeetingsAsSoonAsPossible(ConstraintFactory constraintFactory) {
        return constraintFactory.forEachIncludingNullVars(MeetingAssignment.class).filter(meetingAssignment -> meetingAssignment.getStartingTimeGrain() != null).penalizeConfigurable(MeetingAssignment::getLastTimeGrainIndex).asConstraint("Do all meetings as soon as possible");
    }

    protected Constraint oneBreakBetweenConsecutiveMeetings(ConstraintFactory constraintFactory) {
        return constraintFactory.forEachIncludingNullVars(MeetingAssignment.class).filter(meetingAssignment -> meetingAssignment.getStartingTimeGrain() != null).join(constraintFactory.forEachIncludingNullVars(MeetingAssignment.class).filter(assignment -> assignment.getStartingTimeGrain() != null), Joiners.equal(MeetingAssignment::getLastTimeGrainIndex, rightAssignment -> rightAssignment.getStartingTimeGrain().getGrainIndex() - 1)).penalizeConfigurable().asConstraint("One TimeGrain break between two consecutive meetings");
    }

    protected Constraint overlappingMeetings(ConstraintFactory constraintFactory) {
        return constraintFactory.forEachIncludingNullVars(MeetingAssignment.class).filter(meetingAssignment -> meetingAssignment.getStartingTimeGrain() != null).join(constraintFactory.forEachIncludingNullVars(MeetingAssignment.class).filter(meetingAssignment -> meetingAssignment.getStartingTimeGrain() != null), Joiners.greaterThan(leftAssignment -> leftAssignment.getMeeting().getId(), rightAssignment -> rightAssignment.getMeeting().getId()), Joiners.overlapping(assignment -> assignment.getStartingTimeGrain().getGrainIndex(), assignment -> assignment.getStartingTimeGrain().getGrainIndex() + assignment.getMeeting().getDurationInGrains())).penalizeConfigurable(MeetingAssignment::calculateOverlap).asConstraint("Overlapping meetings");
    }

    protected Constraint assignLargerRoomsFirst(ConstraintFactory constraintFactory) {
        return constraintFactory.forEachIncludingNullVars(MeetingAssignment.class).filter(meetingAssignment -> meetingAssignment.getRoom() != null).join(Room.class, Joiners.lessThan(MeetingAssignment::getRoomCapacity, Room::getCapacity)).penalizeConfigurable((meetingAssignment, room) -> room.getCapacity() - meetingAssignment.getRoomCapacity()).asConstraint("Assign larger rooms first");
    }

    protected Constraint roomStability(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Attendance.class).join(Attendance.class, Joiners.equal(Attendance::getPerson), Joiners.filtering((leftAttendance, rightAttendance) -> leftAttendance.getMeeting() != rightAttendance.getMeeting())).join(MeetingAssignment.class, Joiners.equal((leftAttendance, rightAttendance) -> leftAttendance.getMeeting(), MeetingAssignment::getMeeting)).join(MeetingAssignment.class, Joiners.equal((leftAttendance, rightAttendance, leftAssignment) -> rightAttendance.getMeeting(), MeetingAssignment::getMeeting), Joiners.lessThan((leftAttendance, rightAttendance, leftAssignment) -> leftAssignment.getStartingTimeGrain(), MeetingAssignment::getStartingTimeGrain), Joiners.filtering((leftAttendance, rightAttendance, leftAssignment, rightAssignment) -> leftAssignment.getRoom() != rightAssignment.getRoom()), Joiners.filtering((leftAttendance, rightAttendance, leftAssignment, rightAssignment) -> rightAssignment.getStartingTimeGrain().getGrainIndex() - leftAttendance.getMeeting().getDurationInGrains() - leftAssignment.getStartingTimeGrain().getGrainIndex() <= 2)).penalizeConfigurable().asConstraint("Room stability");
    }
}

