/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.experimental.impl;

import java.util.function.Function;
import org.optaplanner.examples.common.experimental.impl.IntervalSplitPoint;

public final class Interval<Interval_, Point_ extends Comparable<Point_>> {
    private final Interval_ value;
    private final IntervalSplitPoint<Interval_, Point_> startSplitPoint;
    private final IntervalSplitPoint<Interval_, Point_> endSplitPoint;

    public Interval(Interval_ value, Function<Interval_, Point_> startMapping, Function<Interval_, Point_> endMapping) {
        this.value = value;
        Comparable start = (Comparable)startMapping.apply(value);
        Comparable end = (Comparable)endMapping.apply(value);
        this.startSplitPoint = new IntervalSplitPoint(start);
        this.endSplitPoint = start == end ? this.startSplitPoint : new IntervalSplitPoint(end);
    }

    public Interval_ getValue() {
        return this.value;
    }

    public Point_ getStart() {
        return this.startSplitPoint.splitPoint;
    }

    public Point_ getEnd() {
        return this.endSplitPoint.splitPoint;
    }

    public IntervalSplitPoint<Interval_, Point_> getStartSplitPoint() {
        return this.startSplitPoint;
    }

    public IntervalSplitPoint<Interval_, Point_> getEndSplitPoint() {
        return this.endSplitPoint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Interval that = (Interval)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return System.identityHashCode(this.value);
    }

    public String toString() {
        return "Interval{value=" + this.value + ", start=" + this.getStart() + ", end=" + this.getEnd() + "}";
    }
}

