/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.inliner;

import java.math.BigDecimal;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInliner;
import org.optaplanner.constraint.streams.common.inliner.HardSoftBigDecimalScoreContext;
import org.optaplanner.constraint.streams.common.inliner.WeightedScoreImpacter;
import org.optaplanner.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScore;
import org.optaplanner.core.api.score.stream.Constraint;

final class HardSoftBigDecimalScoreInliner
extends AbstractScoreInliner<HardSoftBigDecimalScore> {
    private BigDecimal hardScore = BigDecimal.ZERO;
    private BigDecimal softScore = BigDecimal.ZERO;

    HardSoftBigDecimalScoreInliner(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled);
    }

    @Override
    public WeightedScoreImpacter<HardSoftBigDecimalScore, HardSoftBigDecimalScoreContext> buildWeightedScoreImpacter(Constraint constraint, HardSoftBigDecimalScore constraintWeight) {
        this.validateConstraintWeight(constraint, constraintWeight);
        HardSoftBigDecimalScoreContext context = new HardSoftBigDecimalScoreContext(this, constraint, constraintWeight, impact -> {
            this.hardScore = this.hardScore.add((BigDecimal)impact);
        }, impact -> {
            this.softScore = this.softScore.add((BigDecimal)impact);
        });
        if (constraintWeight.softScore().equals(BigDecimal.ZERO)) {
            return WeightedScoreImpacter.of(context, HardSoftBigDecimalScoreContext::changeHardScoreBy);
        }
        if (constraintWeight.hardScore().equals(BigDecimal.ZERO)) {
            return WeightedScoreImpacter.of(context, HardSoftBigDecimalScoreContext::changeSoftScoreBy);
        }
        return WeightedScoreImpacter.of(context, HardSoftBigDecimalScoreContext::changeScoreBy);
    }

    @Override
    public HardSoftBigDecimalScore extractScore(int initScore) {
        return HardSoftBigDecimalScore.ofUninitialized((int)initScore, (BigDecimal)this.hardScore, (BigDecimal)this.softScore);
    }

    public String toString() {
        return HardSoftBigDecimalScore.class.getSimpleName() + " inliner";
    }
}

