/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import java.util.function.Consumer;
import java.util.function.Function;
import org.optaplanner.constraint.streams.bavet.common.AbstractJoinNode;
import org.optaplanner.constraint.streams.bavet.common.LeftTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.RightTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.TupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.collection.TupleList;
import org.optaplanner.constraint.streams.bavet.common.collection.TupleListEntry;
import org.optaplanner.constraint.streams.bavet.common.index.IndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;

public abstract class AbstractIndexedJoinNode<LeftTuple_ extends Tuple, Right_, OutTuple_ extends Tuple, MutableOutTuple_ extends OutTuple_>
extends AbstractJoinNode<LeftTuple_, Right_, OutTuple_, MutableOutTuple_>
implements LeftTupleLifecycle<LeftTuple_>,
RightTupleLifecycle<UniTuple<Right_>> {
    private final Function<Right_, IndexProperties> mappingRight;
    private final int inputStoreIndexLeftProperties;
    private final int inputStoreIndexLeftEntry;
    private final int inputStoreIndexRightProperties;
    private final int inputStoreIndexRightEntry;
    private final Indexer<LeftTuple_> indexerLeft;
    private final Indexer<UniTuple<Right_>> indexerRight;

    protected AbstractIndexedJoinNode(Function<Right_, IndexProperties> mappingRight, int inputStoreIndexLeftProperties, int inputStoreIndexLeftEntry, int inputStoreIndexLeftOutTupleList, int inputStoreIndexRightProperties, int inputStoreIndexRightEntry, int inputStoreIndexRightOutTupleList, TupleLifecycle<OutTuple_> nextNodesTupleLifecycle, boolean isFiltering, int outputStoreIndexLeftOutEntry, int outputStoreIndexRightOutEntry, Indexer<LeftTuple_> indexerLeft, Indexer<UniTuple<Right_>> indexerRight) {
        super(inputStoreIndexLeftOutTupleList, inputStoreIndexRightOutTupleList, nextNodesTupleLifecycle, isFiltering, outputStoreIndexLeftOutEntry, outputStoreIndexRightOutEntry);
        this.mappingRight = mappingRight;
        this.inputStoreIndexLeftProperties = inputStoreIndexLeftProperties;
        this.inputStoreIndexLeftEntry = inputStoreIndexLeftEntry;
        this.inputStoreIndexRightProperties = inputStoreIndexRightProperties;
        this.inputStoreIndexRightEntry = inputStoreIndexRightEntry;
        this.indexerLeft = indexerLeft;
        this.indexerRight = indexerRight;
    }

    @Override
    public final void insertLeft(LeftTuple_ leftTuple) {
        if (leftTuple.getStore(this.inputStoreIndexLeftProperties) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + leftTuple + ") was already added in the tupleStore.");
        }
        IndexProperties indexProperties = this.createIndexPropertiesLeft(leftTuple);
        TupleList outTupleListLeft = new TupleList();
        leftTuple.setStore(this.inputStoreIndexLeftOutTupleList, outTupleListLeft);
        this.indexAndPropagateLeft(leftTuple, indexProperties);
    }

    @Override
    public final void updateLeft(LeftTuple_ leftTuple) {
        IndexProperties oldIndexProperties = (IndexProperties)leftTuple.getStore(this.inputStoreIndexLeftProperties);
        if (oldIndexProperties == null) {
            this.insertLeft(leftTuple);
            return;
        }
        IndexProperties newIndexProperties = this.createIndexPropertiesLeft(leftTuple);
        if (oldIndexProperties.equals(newIndexProperties)) {
            this.innerUpdateLeft(leftTuple, consumer -> this.indexerRight.forEach(oldIndexProperties, (Consumer<UniTuple<Right_>>)consumer));
        } else {
            TupleListEntry leftEntry = (TupleListEntry)leftTuple.getStore(this.inputStoreIndexLeftEntry);
            TupleList outTupleListLeft = (TupleList)leftTuple.getStore(this.inputStoreIndexLeftOutTupleList);
            this.indexerLeft.remove(oldIndexProperties, leftEntry);
            outTupleListLeft.forEach(this::retractOutTuple);
            this.indexAndPropagateLeft(leftTuple, newIndexProperties);
        }
    }

    private void indexAndPropagateLeft(LeftTuple_ leftTuple, IndexProperties indexProperties) {
        leftTuple.setStore(this.inputStoreIndexLeftProperties, indexProperties);
        TupleListEntry<LeftTuple_> leftEntry = this.indexerLeft.put(indexProperties, leftTuple);
        leftTuple.setStore(this.inputStoreIndexLeftEntry, leftEntry);
        this.indexerRight.forEach(indexProperties, rightTuple -> this.insertOutTupleFiltered(leftTuple, rightTuple));
    }

    @Override
    public final void retractLeft(LeftTuple_ leftTuple) {
        IndexProperties indexProperties = (IndexProperties)leftTuple.removeStore(this.inputStoreIndexLeftProperties);
        if (indexProperties == null) {
            return;
        }
        TupleListEntry leftEntry = (TupleListEntry)leftTuple.removeStore(this.inputStoreIndexLeftEntry);
        TupleList outTupleListLeft = (TupleList)leftTuple.removeStore(this.inputStoreIndexLeftOutTupleList);
        this.indexerLeft.remove(indexProperties, leftEntry);
        outTupleListLeft.forEach(this::retractOutTuple);
    }

    @Override
    public final void insertRight(UniTuple<Right_> rightTuple) {
        if (rightTuple.getStore(this.inputStoreIndexRightProperties) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + rightTuple + ") was already added in the tupleStore.");
        }
        IndexProperties indexProperties = this.mappingRight.apply(rightTuple.getFactA());
        TupleList outTupleListRight = new TupleList();
        rightTuple.setStore(this.inputStoreIndexRightOutTupleList, outTupleListRight);
        this.indexAndPropagateRight(rightTuple, indexProperties);
    }

    @Override
    public final void updateRight(UniTuple<Right_> rightTuple) {
        IndexProperties oldIndexProperties = (IndexProperties)rightTuple.getStore(this.inputStoreIndexRightProperties);
        if (oldIndexProperties == null) {
            this.insertRight(rightTuple);
            return;
        }
        IndexProperties newIndexProperties = this.mappingRight.apply(rightTuple.getFactA());
        if (oldIndexProperties.equals(newIndexProperties)) {
            this.innerUpdateRight(rightTuple, consumer -> this.indexerLeft.forEach(oldIndexProperties, (Consumer<LeftTuple_>)consumer));
        } else {
            TupleListEntry rightEntry = (TupleListEntry)rightTuple.getStore(this.inputStoreIndexRightEntry);
            TupleList outTupleListRight = (TupleList)rightTuple.getStore(this.inputStoreIndexRightOutTupleList);
            this.indexerRight.remove(oldIndexProperties, rightEntry);
            outTupleListRight.forEach(this::retractOutTuple);
            this.indexAndPropagateRight(rightTuple, newIndexProperties);
        }
    }

    private void indexAndPropagateRight(UniTuple<Right_> rightTuple, IndexProperties indexProperties) {
        rightTuple.setStore(this.inputStoreIndexRightProperties, indexProperties);
        TupleListEntry<UniTuple<Right_>> rightEntry = this.indexerRight.put(indexProperties, rightTuple);
        rightTuple.setStore(this.inputStoreIndexRightEntry, rightEntry);
        this.indexerLeft.forEach(indexProperties, leftTuple -> this.insertOutTupleFiltered(leftTuple, rightTuple));
    }

    @Override
    public final void retractRight(UniTuple<Right_> rightTuple) {
        IndexProperties indexProperties = (IndexProperties)rightTuple.removeStore(this.inputStoreIndexRightProperties);
        if (indexProperties == null) {
            return;
        }
        TupleListEntry rightEntry = (TupleListEntry)rightTuple.removeStore(this.inputStoreIndexRightEntry);
        TupleList outTupleListRight = (TupleList)rightTuple.removeStore(this.inputStoreIndexRightOutTupleList);
        this.indexerRight.remove(indexProperties, rightEntry);
        outTupleListRight.forEach(this::retractOutTuple);
    }

    protected abstract IndexProperties createIndexPropertiesLeft(LeftTuple_ var1);
}

