/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import java.util.ArrayDeque;
import java.util.Queue;
import org.optaplanner.constraint.streams.bavet.common.AbstractNode;
import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;
import org.optaplanner.constraint.streams.bavet.common.ExistsCounter;
import org.optaplanner.constraint.streams.bavet.common.LeftTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.RightTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.TupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.collection.TupleList;
import org.optaplanner.constraint.streams.bavet.common.collection.TupleListEntry;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;

public abstract class AbstractIfExistsNode<LeftTuple_ extends Tuple, Right_>
extends AbstractNode
implements LeftTupleLifecycle<LeftTuple_>,
RightTupleLifecycle<UniTuple<Right_>> {
    protected final boolean shouldExist;
    protected final int inputStoreIndexLeftTrackerList;
    protected final int inputStoreIndexRightTrackerList;
    private final TupleLifecycle<LeftTuple_> nextNodesTupleLifecycle;
    protected final boolean isFiltering;
    protected final Queue<ExistsCounter<LeftTuple_>> dirtyCounterQueue;

    protected AbstractIfExistsNode(boolean shouldExist, int inputStoreIndexLeftTrackerList, int inputStoreIndexRightTrackerList, TupleLifecycle<LeftTuple_> nextNodesTupleLifecycle, boolean isFiltering) {
        this.shouldExist = shouldExist;
        this.inputStoreIndexLeftTrackerList = inputStoreIndexLeftTrackerList;
        this.inputStoreIndexRightTrackerList = inputStoreIndexRightTrackerList;
        this.nextNodesTupleLifecycle = nextNodesTupleLifecycle;
        this.isFiltering = isFiltering;
        this.dirtyCounterQueue = new ArrayDeque<ExistsCounter<LeftTuple_>>(1000);
    }

    protected abstract boolean testFiltering(LeftTuple_ var1, UniTuple<Right_> var2);

    protected void initCounterLeft(ExistsCounter<LeftTuple_> counter) {
        if (this.shouldExist ? counter.countRight > 0 : counter.countRight == 0) {
            counter.state = BavetTupleState.CREATING;
            this.dirtyCounterQueue.add(counter);
        }
    }

    protected final void updateUnchangedCounterLeft(ExistsCounter<LeftTuple_> counter) {
        switch (counter.state) {
            case CREATING: 
            case UPDATING: 
            case DYING: 
            case ABORTING: 
            case DEAD: {
                break;
            }
            case OK: {
                counter.state = BavetTupleState.UPDATING;
                this.dirtyCounterQueue.add(counter);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: The counter (" + counter.state + ") in node (" + this + ") is in an unexpected state (" + counter.state + ").");
            }
        }
    }

    protected void updateCounterLeft(ExistsCounter<LeftTuple_> counter) {
        block14: {
            block13: {
                if (!(this.shouldExist ? counter.countRight > 0 : counter.countRight == 0)) break block13;
                switch (counter.state) {
                    case CREATING: 
                    case UPDATING: {
                        break block14;
                    }
                    case OK: {
                        counter.state = BavetTupleState.UPDATING;
                        this.dirtyCounterQueue.add(counter);
                        break block14;
                    }
                    case DYING: {
                        counter.state = BavetTupleState.UPDATING;
                        break block14;
                    }
                    case DEAD: {
                        counter.state = BavetTupleState.CREATING;
                        this.dirtyCounterQueue.add(counter);
                        break block14;
                    }
                    case ABORTING: {
                        counter.state = BavetTupleState.CREATING;
                        break block14;
                    }
                    default: {
                        throw new IllegalStateException("Impossible state: the counter (" + counter + ") has an impossible insert state (" + counter.state + ").");
                    }
                }
            }
            switch (counter.state) {
                case CREATING: {
                    counter.state = BavetTupleState.ABORTING;
                    break;
                }
                case UPDATING: {
                    counter.state = BavetTupleState.DYING;
                    break;
                }
                case OK: {
                    counter.state = BavetTupleState.DYING;
                    this.dirtyCounterQueue.add(counter);
                    break;
                }
                case DYING: 
                case ABORTING: 
                case DEAD: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible state: The counter (" + counter + ") has an impossible retract state (" + counter.state + ").");
                }
            }
        }
    }

    protected void killCounterLeft(ExistsCounter<LeftTuple_> counter) {
        if (this.shouldExist ? counter.countRight > 0 : counter.countRight == 0) {
            this.doRetractCounter(counter);
        }
    }

    protected void incrementCounterRight(ExistsCounter<LeftTuple_> counter) {
        if (counter.countRight == 0) {
            if (this.shouldExist) {
                this.doInsertCounter(counter);
            } else {
                this.doRetractCounter(counter);
            }
        }
        ++counter.countRight;
    }

    protected void decrementCounterRight(ExistsCounter<LeftTuple_> counter) {
        --counter.countRight;
        if (counter.countRight == 0) {
            if (this.shouldExist) {
                this.doRetractCounter(counter);
            } else {
                this.doInsertCounter(counter);
            }
        }
    }

    protected TupleList<FilteringTracker<LeftTuple_>> updateRightTrackerList(UniTuple<Right_> rightTuple) {
        TupleList rightTrackerList = (TupleList)rightTuple.getStore(this.inputStoreIndexRightTrackerList);
        rightTrackerList.forEach(filteringTacker -> {
            this.decrementCounterRight(filteringTacker.counter);
            filteringTacker.remove();
        });
        return rightTrackerList;
    }

    protected void updateCounterFromLeft(LeftTuple_ leftTuple, UniTuple<Right_> rightTuple, ExistsCounter<LeftTuple_> counter, TupleList<FilteringTracker<LeftTuple_>> leftTrackerList) {
        if (this.testFiltering(leftTuple, rightTuple)) {
            ++counter.countRight;
            TupleList rightTrackerList = (TupleList)rightTuple.getStore(this.inputStoreIndexRightTrackerList);
            new FilteringTracker<LeftTuple_>(counter, leftTrackerList, rightTrackerList);
        }
    }

    protected void updateCounterFromRight(UniTuple<Right_> rightTuple, ExistsCounter<LeftTuple_> counter, TupleList<FilteringTracker<LeftTuple_>> rightTrackerList) {
        if (this.testFiltering(counter.leftTuple, rightTuple)) {
            this.incrementCounterRight(counter);
            TupleList leftTrackerList = (TupleList)counter.leftTuple.getStore(this.inputStoreIndexLeftTrackerList);
            new FilteringTracker<LeftTuple_>(counter, leftTrackerList, rightTrackerList);
        }
    }

    private void doInsertCounter(ExistsCounter<LeftTuple_> counter) {
        switch (counter.state) {
            case DYING: {
                counter.state = BavetTupleState.UPDATING;
                break;
            }
            case DEAD: {
                counter.state = BavetTupleState.CREATING;
                this.dirtyCounterQueue.add(counter);
                break;
            }
            case ABORTING: {
                counter.state = BavetTupleState.CREATING;
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: the counter (" + counter + ") has an impossible insert state (" + counter.state + ").");
            }
        }
    }

    private void doRetractCounter(ExistsCounter<LeftTuple_> counter) {
        switch (counter.state) {
            case CREATING: {
                counter.state = BavetTupleState.ABORTING;
                break;
            }
            case UPDATING: {
                counter.state = BavetTupleState.DYING;
                break;
            }
            case OK: {
                counter.state = BavetTupleState.DYING;
                this.dirtyCounterQueue.add(counter);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: The counter (" + counter + ") has an impossible retract state (" + counter.state + ").");
            }
        }
    }

    @Override
    public final void calculateScore() {
        block6: for (ExistsCounter existsCounter : this.dirtyCounterQueue) {
            switch (existsCounter.state) {
                case CREATING: {
                    this.nextNodesTupleLifecycle.insert(existsCounter.leftTuple);
                    existsCounter.state = BavetTupleState.OK;
                    continue block6;
                }
                case UPDATING: {
                    this.nextNodesTupleLifecycle.update(existsCounter.leftTuple);
                    existsCounter.state = BavetTupleState.OK;
                    continue block6;
                }
                case DYING: {
                    this.nextNodesTupleLifecycle.retract(existsCounter.leftTuple);
                    existsCounter.state = BavetTupleState.DEAD;
                    continue block6;
                }
                case ABORTING: {
                    existsCounter.state = BavetTupleState.DEAD;
                    continue block6;
                }
            }
            throw new IllegalStateException("Impossible state: The dirty counter (" + existsCounter + ") has an non-dirty state (" + existsCounter.state + ").");
        }
        this.dirtyCounterQueue.clear();
    }

    protected static final class FilteringTracker<LeftTuple_ extends Tuple> {
        final ExistsCounter<LeftTuple_> counter;
        private final TupleListEntry<FilteringTracker<LeftTuple_>> leftTrackerEntry;
        private final TupleListEntry<FilteringTracker<LeftTuple_>> rightTrackerEntry;

        FilteringTracker(ExistsCounter<LeftTuple_> counter, TupleList<FilteringTracker<LeftTuple_>> leftTrackerList, TupleList<FilteringTracker<LeftTuple_>> rightTrackerList) {
            this.counter = counter;
            this.leftTrackerEntry = leftTrackerList.add(this);
            this.rightTrackerEntry = rightTrackerList.add(this);
        }

        public void remove() {
            this.leftTrackerEntry.remove();
            this.rightTrackerEntry.remove();
        }
    }
}

