/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.quad;

import java.math.BigDecimal;
import java.util.Set;
import org.optaplanner.constraint.streams.bavet.BavetConstraint;
import org.optaplanner.constraint.streams.bavet.BavetConstraintFactory;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.BavetScoringConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.NodeBuildHelper;
import org.optaplanner.constraint.streams.bavet.quad.BavetAbstractQuadConstraintStream;
import org.optaplanner.constraint.streams.bavet.quad.QuadScorer;
import org.optaplanner.constraint.streams.common.inliner.JustificationsSupplier;
import org.optaplanner.constraint.streams.common.inliner.WeightedScoreImpacter;
import org.optaplanner.core.api.function.PentaFunction;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.ToIntQuadFunction;
import org.optaplanner.core.api.function.ToLongQuadFunction;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintStream;

public final class BavetScoringQuadConstraintStream<Solution_, A, B, C, D>
extends BavetAbstractQuadConstraintStream<Solution_, A, B, C, D>
implements BavetScoringConstraintStream<Solution_> {
    private final BavetAbstractQuadConstraintStream<Solution_, A, B, C, D> parent;
    private final boolean noMatchWeigher;
    private final ToIntQuadFunction<A, B, C, D> intMatchWeigher;
    private final ToLongQuadFunction<A, B, C, D> longMatchWeigher;
    private final QuadFunction<A, B, C, D, BigDecimal> bigDecimalMatchWeigher;
    private BavetConstraint<Solution_> constraint;

    public BavetScoringQuadConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractQuadConstraintStream<Solution_, A, B, C, D> parent, ToIntQuadFunction<A, B, C, D> intMatchWeigher) {
        this(constraintFactory, parent, false, intMatchWeigher, null, null);
        if (intMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public BavetScoringQuadConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractQuadConstraintStream<Solution_, A, B, C, D> parent, ToLongQuadFunction<A, B, C, D> longMatchWeigher) {
        this(constraintFactory, parent, false, null, longMatchWeigher, null);
        if (longMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public BavetScoringQuadConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractQuadConstraintStream<Solution_, A, B, C, D> parent, QuadFunction<A, B, C, D, BigDecimal> bigDecimalMatchWeigher) {
        this(constraintFactory, parent, false, null, null, bigDecimalMatchWeigher);
        if (bigDecimalMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    private BavetScoringQuadConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractQuadConstraintStream<Solution_, A, B, C, D> parent, boolean noMatchWeigher, ToIntQuadFunction<A, B, C, D> intMatchWeigher, ToLongQuadFunction<A, B, C, D> longMatchWeigher, QuadFunction<A, B, C, D, BigDecimal> bigDecimalMatchWeigher) {
        super(constraintFactory, parent.getRetrievalSemantics());
        this.parent = parent;
        this.noMatchWeigher = noMatchWeigher;
        this.intMatchWeigher = intMatchWeigher;
        this.longMatchWeigher = longMatchWeigher;
        this.bigDecimalMatchWeigher = bigDecimalMatchWeigher;
    }

    @Override
    public void setConstraint(BavetConstraint<Solution_> constraint) {
        this.constraint = constraint;
    }

    public boolean guaranteesDistinct() {
        return this.parent.guaranteesDistinct();
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        this.parent.collectActiveConstraintStreams(constraintStreamSet);
        constraintStreamSet.add(this);
    }

    @Override
    public ConstraintStream getTupleSource() {
        return this.parent.getTupleSource();
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        QuadFunction scoreImpacter;
        if (!this.childStreamList.isEmpty()) {
            throw new IllegalStateException("Impossible state: the stream (" + this + ") has an non-empty childStreamList (" + this.childStreamList + ") but it's an endpoint.");
        }
        Score_ constraintWeight = buildHelper.getConstraintWeight((Constraint)this.constraint);
        WeightedScoreImpacter weightedScoreImpacter = buildHelper.getScoreInliner().buildWeightedScoreImpacter(this.constraint, constraintWeight);
        boolean constraintMatchEnabled = buildHelper.getScoreInliner().isConstraintMatchEnabled();
        if (this.intMatchWeigher != null) {
            scoreImpacter = constraintMatchEnabled ? (a, b, c, d) -> {
                int matchWeight = this.intMatchWeigher.applyAsInt(a, b, c, d);
                this.constraint.assertCorrectImpact(matchWeight);
                JustificationsSupplier justificationsSupplier = JustificationsSupplier.of(this.constraint, (PentaFunction)((PentaFunction)this.constraint.getJustificationMapping()), (QuadFunction)((QuadFunction)this.constraint.getIndictedObjectsMapping()), (Object)a, (Object)b, (Object)c, (Object)d);
                return weightedScoreImpacter.impactScore(matchWeight, justificationsSupplier);
            } : (a, b, c, d) -> {
                int matchWeight = this.intMatchWeigher.applyAsInt(a, b, c, d);
                this.constraint.assertCorrectImpact(matchWeight);
                return weightedScoreImpacter.impactScore(matchWeight, null);
            };
        } else if (this.longMatchWeigher != null) {
            scoreImpacter = constraintMatchEnabled ? (a, b, c, d) -> {
                long matchWeight = this.longMatchWeigher.applyAsLong(a, b, c, d);
                this.constraint.assertCorrectImpact(matchWeight);
                JustificationsSupplier justificationsSupplier = JustificationsSupplier.of(this.constraint, (PentaFunction)((PentaFunction)this.constraint.getJustificationMapping()), (QuadFunction)((QuadFunction)this.constraint.getIndictedObjectsMapping()), (Object)a, (Object)b, (Object)c, (Object)d);
                return weightedScoreImpacter.impactScore(matchWeight, justificationsSupplier);
            } : (a, b, c, d) -> {
                long matchWeight = this.longMatchWeigher.applyAsLong(a, b, c, d);
                this.constraint.assertCorrectImpact(matchWeight);
                return weightedScoreImpacter.impactScore(matchWeight, null);
            };
        } else if (this.bigDecimalMatchWeigher != null) {
            scoreImpacter = constraintMatchEnabled ? (a, b, c, d) -> {
                BigDecimal matchWeight = (BigDecimal)this.bigDecimalMatchWeigher.apply(a, b, c, d);
                this.constraint.assertCorrectImpact(matchWeight);
                JustificationsSupplier justificationsSupplier = JustificationsSupplier.of(this.constraint, (PentaFunction)((PentaFunction)this.constraint.getJustificationMapping()), (QuadFunction)((QuadFunction)this.constraint.getIndictedObjectsMapping()), (Object)a, (Object)b, (Object)c, (Object)d);
                return weightedScoreImpacter.impactScore(matchWeight, justificationsSupplier);
            } : (a, b, c, d) -> {
                BigDecimal matchWeight = (BigDecimal)this.bigDecimalMatchWeigher.apply(a, b, c, d);
                this.constraint.assertCorrectImpact(matchWeight);
                return weightedScoreImpacter.impactScore(matchWeight, null);
            };
        } else if (this.noMatchWeigher) {
            scoreImpacter = constraintMatchEnabled ? (a, b, c, d) -> {
                JustificationsSupplier justificationsSupplier = JustificationsSupplier.of(this.constraint, (PentaFunction)((PentaFunction)this.constraint.getJustificationMapping()), (QuadFunction)((QuadFunction)this.constraint.getIndictedObjectsMapping()), (Object)a, (Object)b, (Object)c, (Object)d);
                return weightedScoreImpacter.impactScore(1, justificationsSupplier);
            } : (a, b, c, d) -> weightedScoreImpacter.impactScore(1, null);
        } else {
            throw new IllegalStateException("Impossible state: neither of the supported match weighers provided.");
        }
        QuadScorer scorer = new QuadScorer(this.constraint.getConstraintPackage(), this.constraint.getConstraintName(), (Score<?>)constraintWeight, scoreImpacter, buildHelper.reserveTupleStoreIndex(this.parent.getTupleSource()));
        buildHelper.putInsertUpdateRetract((ConstraintStream)this, scorer);
    }

    public String toString() {
        return "Scoring(" + this.constraint.getConstraintName() + ")";
    }
}

