/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.drl.holder;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.drools.core.rule.consequence.InternalMatch;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.constraint.drl.holder.BendableBigDecimalScoreHolderImpl;
import org.optaplanner.constraint.drl.holder.BendableLongScoreHolderImpl;
import org.optaplanner.constraint.drl.holder.BendableScoreHolderImpl;
import org.optaplanner.constraint.drl.holder.HardMediumSoftBigDecimalScoreHolderImpl;
import org.optaplanner.constraint.drl.holder.HardMediumSoftLongScoreHolderImpl;
import org.optaplanner.constraint.drl.holder.HardMediumSoftScoreHolderImpl;
import org.optaplanner.constraint.drl.holder.HardSoftBigDecimalScoreHolderImpl;
import org.optaplanner.constraint.drl.holder.HardSoftLongScoreHolderImpl;
import org.optaplanner.constraint.drl.holder.HardSoftScoreHolderImpl;
import org.optaplanner.constraint.drl.holder.SimpleBigDecimalScoreHolderImpl;
import org.optaplanner.constraint.drl.holder.SimpleLongScoreHolderImpl;
import org.optaplanner.constraint.drl.holder.SimpleScoreHolderImpl;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatch;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.api.score.holder.ScoreHolder;
import org.optaplanner.core.impl.score.buildin.BendableBigDecimalScoreDefinition;
import org.optaplanner.core.impl.score.buildin.BendableLongScoreDefinition;
import org.optaplanner.core.impl.score.buildin.BendableScoreDefinition;
import org.optaplanner.core.impl.score.buildin.HardMediumSoftBigDecimalScoreDefinition;
import org.optaplanner.core.impl.score.buildin.HardMediumSoftLongScoreDefinition;
import org.optaplanner.core.impl.score.buildin.HardMediumSoftScoreDefinition;
import org.optaplanner.core.impl.score.buildin.HardSoftBigDecimalScoreDefinition;
import org.optaplanner.core.impl.score.buildin.HardSoftLongScoreDefinition;
import org.optaplanner.core.impl.score.buildin.HardSoftScoreDefinition;
import org.optaplanner.core.impl.score.buildin.SimpleBigDecimalScoreDefinition;
import org.optaplanner.core.impl.score.buildin.SimpleLongScoreDefinition;
import org.optaplanner.core.impl.score.buildin.SimpleScoreDefinition;
import org.optaplanner.core.impl.score.constraint.DefaultConstraintMatchTotal;
import org.optaplanner.core.impl.score.constraint.DefaultIndictment;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;

public abstract class AbstractScoreHolder<Score_ extends Score<Score_>>
implements ScoreHolder<Score_> {
    @Deprecated(forRemoval=true)
    private static final String CUSTOM_SCORE_HOLDER_CLASS_PROPERTY_NAME = "org.optaplanner.score.drools.holder";
    protected final boolean constraintMatchEnabled;
    protected final Map<String, ConstraintMatchTotal<Score_>> constraintMatchTotalMap;
    protected final Map<Object, Indictment<Score_>> indictmentMap;

    public static <Score_ extends Score<Score_>, ScoreHolder_ extends AbstractScoreHolder<Score_>> ScoreHolder_ buildScoreHolder(ScoreDefinition<Score_> scoreDefinition, boolean constraintMatchEnabled) {
        if (scoreDefinition instanceof SimpleScoreDefinition) {
            return (ScoreHolder_)new SimpleScoreHolderImpl(constraintMatchEnabled);
        }
        if (scoreDefinition instanceof SimpleLongScoreDefinition) {
            return (ScoreHolder_)new SimpleLongScoreHolderImpl(constraintMatchEnabled);
        }
        if (scoreDefinition instanceof SimpleBigDecimalScoreDefinition) {
            return (ScoreHolder_)new SimpleBigDecimalScoreHolderImpl(constraintMatchEnabled);
        }
        if (scoreDefinition instanceof HardSoftScoreDefinition) {
            return (ScoreHolder_)new HardSoftScoreHolderImpl(constraintMatchEnabled);
        }
        if (scoreDefinition instanceof HardSoftLongScoreDefinition) {
            return (ScoreHolder_)new HardSoftLongScoreHolderImpl(constraintMatchEnabled);
        }
        if (scoreDefinition instanceof HardSoftBigDecimalScoreDefinition) {
            return (ScoreHolder_)new HardSoftBigDecimalScoreHolderImpl(constraintMatchEnabled);
        }
        if (scoreDefinition instanceof HardMediumSoftScoreDefinition) {
            return (ScoreHolder_)new HardMediumSoftScoreHolderImpl(constraintMatchEnabled);
        }
        if (scoreDefinition instanceof HardMediumSoftLongScoreDefinition) {
            return (ScoreHolder_)new HardMediumSoftLongScoreHolderImpl(constraintMatchEnabled);
        }
        if (scoreDefinition instanceof HardMediumSoftBigDecimalScoreDefinition) {
            return (ScoreHolder_)new HardMediumSoftBigDecimalScoreHolderImpl(constraintMatchEnabled);
        }
        if (scoreDefinition instanceof BendableScoreDefinition) {
            BendableScoreDefinition bendableScoreDefinition = (BendableScoreDefinition)scoreDefinition;
            return (ScoreHolder_)new BendableScoreHolderImpl(constraintMatchEnabled, bendableScoreDefinition.getHardLevelsSize(), bendableScoreDefinition.getSoftLevelsSize());
        }
        if (scoreDefinition instanceof BendableLongScoreDefinition) {
            BendableLongScoreDefinition bendableScoreDefinition = (BendableLongScoreDefinition)scoreDefinition;
            return (ScoreHolder_)new BendableLongScoreHolderImpl(constraintMatchEnabled, bendableScoreDefinition.getHardLevelsSize(), bendableScoreDefinition.getSoftLevelsSize());
        }
        if (scoreDefinition instanceof BendableBigDecimalScoreDefinition) {
            BendableBigDecimalScoreDefinition bendableScoreDefinition = (BendableBigDecimalScoreDefinition)scoreDefinition;
            return (ScoreHolder_)new BendableBigDecimalScoreHolderImpl(constraintMatchEnabled, bendableScoreDefinition.getHardLevelsSize(), bendableScoreDefinition.getSoftLevelsSize());
        }
        String customScoreHolderClassName = System.getProperty(CUSTOM_SCORE_HOLDER_CLASS_PROPERTY_NAME);
        if (customScoreHolderClassName == null) {
            throw new UnsupportedOperationException("Unknown score definition class (" + scoreDefinition.getClass().getCanonicalName() + ").\nIf you're attempting to use a custom score, provide your " + AbstractScoreHolder.class.getSimpleName() + " implementation using the 'org.optaplanner.score.drools.holder' system property.\nNote: support for custom scores will be removed in OptaPlanner 9.0.");
        }
        try {
            Class<?> customScoreHolderClass = Class.forName(customScoreHolderClassName);
            if (!AbstractScoreHolder.class.isAssignableFrom(customScoreHolderClass)) {
                throw new IllegalStateException("Custom score holder class (" + customScoreHolderClassName + ") does not extend " + AbstractScoreHolder.class.getCanonicalName() + ".\nNote: support for custom scores will be removed in OptaPlanner 9.0.");
            }
            return (ScoreHolder_)((AbstractScoreHolder)customScoreHolderClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException cause) {
            throw new IllegalStateException("Custom score holder class (" + customScoreHolderClassName + ") can not be instantiated.\nMaybe add a no-arg public constructor?\nNote: support for custom scores will be removed in OptaPlanner 9.0.", cause);
        }
    }

    protected AbstractScoreHolder(boolean constraintMatchEnabled) {
        this.constraintMatchEnabled = constraintMatchEnabled;
        this.constraintMatchTotalMap = constraintMatchEnabled ? new LinkedHashMap() : null;
        this.indictmentMap = constraintMatchEnabled ? new LinkedHashMap() : null;
    }

    public boolean isConstraintMatchEnabled() {
        return this.constraintMatchEnabled;
    }

    public Map<String, ConstraintMatchTotal<Score_>> getConstraintMatchTotalMap() {
        if (!this.isConstraintMatchEnabled()) {
            throw new IllegalStateException("When constraintMatchEnabled (" + this.isConstraintMatchEnabled() + ") is disabled in the constructor, this method should not be called.");
        }
        return this.constraintMatchTotalMap;
    }

    public Map<Object, Indictment<Score_>> getIndictmentMap() {
        if (!this.isConstraintMatchEnabled()) {
            throw new IllegalStateException("When constraintMatchEnabled (" + this.isConstraintMatchEnabled() + ") is disabled in the constructor, this method should not be called.");
        }
        return this.indictmentMap;
    }

    public void configureConstraintWeight(Rule rule, Score_ constraintWeight) {
        if (constraintWeight.initScore() != 0) {
            throw new IllegalStateException("The initScore (" + constraintWeight.initScore() + ") must be 0.");
        }
        if (this.constraintMatchEnabled) {
            String constraintPackage = rule.getPackageName();
            String constraintName = rule.getName();
            String constraintId = ConstraintMatchTotal.composeConstraintId((String)constraintPackage, (String)constraintName);
            this.constraintMatchTotalMap.put(constraintId, (ConstraintMatchTotal<Score_>)new DefaultConstraintMatchTotal(constraintPackage, constraintName, constraintWeight));
        }
    }

    protected void registerConstraintMatch(RuleContext kcontext, Runnable constraintUndoListener, Supplier<Score_> scoreSupplier) {
        InternalMatch agendaItem = (InternalMatch)kcontext.getMatch();
        ConstraintActivationUnMatchListener constraintActivationUnMatchListener = new ConstraintActivationUnMatchListener(constraintUndoListener);
        agendaItem.setCallback((Runnable)constraintActivationUnMatchListener);
        if (this.constraintMatchEnabled) {
            List<Object> completeJustificationList = this.extractJustificationList(kcontext);
            constraintActivationUnMatchListener.constraintMatchTotal = this.findConstraintMatchTotal(kcontext);
            ConstraintMatch constraintMatch = constraintActivationUnMatchListener.constraintMatchTotal.addConstraintMatch(completeJustificationList, (Score)scoreSupplier.get());
            List indictmentList = completeJustificationList.stream().distinct().map(justification -> {
                DefaultIndictment indictment = (DefaultIndictment)this.indictmentMap.computeIfAbsent(justification, k -> new DefaultIndictment(justification, constraintMatch.getScore().zero()));
                indictment.addConstraintMatch(constraintMatch);
                return indictment;
            }).collect(Collectors.toList());
            constraintActivationUnMatchListener.constraintMatch = constraintMatch;
            constraintActivationUnMatchListener.indictmentList = indictmentList;
        }
    }

    private DefaultConstraintMatchTotal<Score_> findConstraintMatchTotal(RuleContext kcontext) {
        Rule rule = kcontext.getRule();
        String constraintPackage = rule.getPackageName();
        String constraintName = rule.getName();
        String constraintId = ConstraintMatchTotal.composeConstraintId((String)constraintPackage, (String)constraintName);
        return (DefaultConstraintMatchTotal)this.constraintMatchTotalMap.computeIfAbsent(constraintId, k -> new DefaultConstraintMatchTotal(constraintPackage, constraintName));
    }

    public void impactScore(RuleContext kcontext) {
        throw new UnsupportedOperationException("In the rule (" + kcontext.getRule().getName() + "), the scoreHolder class (" + this.getClass() + ") requires a weightMultiplier.");
    }

    public abstract void impactScore(RuleContext var1, int var2);

    public abstract void impactScore(RuleContext var1, long var2);

    public abstract void impactScore(RuleContext var1, BigDecimal var2);

    public abstract Score_ extractScore(int var1);

    protected List<Object> extractJustificationList(RuleContext kcontext) {
        InternalMatch activation = (InternalMatch)kcontext.getMatch();
        return new ArrayList<Object>(activation.getObjectsDeep());
    }

    public class ConstraintActivationUnMatchListener
    implements Runnable {
        private final Runnable constraintUndoListener;
        private DefaultConstraintMatchTotal<Score_> constraintMatchTotal;
        private List<DefaultIndictment<Score_>> indictmentList;
        private ConstraintMatch<Score_> constraintMatch;

        public ConstraintActivationUnMatchListener(Runnable constraintUndoListener) {
            this.constraintUndoListener = constraintUndoListener;
        }

        @Override
        public final void run() {
            this.constraintUndoListener.run();
            if (AbstractScoreHolder.this.constraintMatchEnabled) {
                this.constraintMatchTotal.removeConstraintMatch(this.constraintMatch);
                for (DefaultIndictment indictment : this.indictmentList) {
                    indictment.removeConstraintMatch(this.constraintMatch);
                    if (!indictment.getConstraintMatchSet().isEmpty()) continue;
                    AbstractScoreHolder.this.indictmentMap.remove(indictment.getIndictedObject());
                }
            }
        }
    }

    @FunctionalInterface
    protected static interface ScoreMatchExecutor<Score_ extends Score<Score_>> {
        public void accept(RuleContext var1, Score_ var2);
    }

    @FunctionalInterface
    protected static interface BigDecimalMatchExecutor {
        public void accept(RuleContext var1, BigDecimal var2);
    }

    @FunctionalInterface
    protected static interface LongMatchExecutor {
        public void accept(RuleContext var1, long var2);
    }

    @FunctionalInterface
    protected static interface IntMatchExecutor {
        public void accept(RuleContext var1, int var2);
    }
}

