/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic.movecountperstep;

import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.File;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.optaplanner.benchmark.config.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.ProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.SubSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.common.MillisecondsSpentNumberFormat;
import org.optaplanner.benchmark.impl.statistic.movecountperstep.MoveCountPerStepStatisticPoint;
import org.optaplanner.benchmark.impl.statistic.movecountperstep.MoveCountPerStepSubSingleStatistic;

public class MoveCountPerStepProblemStatistic
extends ProblemStatistic {
    protected File graphFile = null;

    public MoveCountPerStepProblemStatistic(ProblemBenchmarkResult problemBenchmarkResult) {
        super(problemBenchmarkResult, ProblemStatisticType.MOVE_COUNT_PER_STEP);
    }

    @Override
    public SubSingleStatistic createSubSingleStatistic(SubSingleBenchmarkResult subSingleBenchmarkResult) {
        return new MoveCountPerStepSubSingleStatistic(subSingleBenchmarkResult);
    }

    @Override
    public List<File> getGraphFileList() {
        return Collections.singletonList(this.graphFile);
    }

    @Override
    public void writeGraphFiles(BenchmarkReport benchmarkReport) {
        Locale locale = benchmarkReport.getLocale();
        NumberAxis xAxis = new NumberAxis("Time spent");
        xAxis.setNumberFormatOverride((NumberFormat)new MillisecondsSpentNumberFormat(locale));
        NumberAxis yAxis = new NumberAxis("Accepted/selected moves per step");
        yAxis.setNumberFormatOverride(NumberFormat.getInstance(locale));
        XYPlot plot = new XYPlot(null, (ValueAxis)xAxis, (ValueAxis)yAxis, null);
        DefaultDrawingSupplier drawingSupplier = new DefaultDrawingSupplier();
        plot.setOrientation(PlotOrientation.VERTICAL);
        int seriesIndex = 0;
        for (SingleBenchmarkResult singleBenchmarkResult : this.problemBenchmarkResult.getSingleBenchmarkResultList()) {
            XYSeries acceptedSeries = new XYSeries((Comparable)((Object)(singleBenchmarkResult.getSolverBenchmarkResult().getNameWithFavoriteSuffix() + " accepted")));
            XYSeries selectedSeries = new XYSeries((Comparable)((Object)(singleBenchmarkResult.getSolverBenchmarkResult().getNameWithFavoriteSuffix() + " selected")));
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, false);
            if (singleBenchmarkResult.hasAllSuccess()) {
                MoveCountPerStepSubSingleStatistic subSingleStatistic = (MoveCountPerStepSubSingleStatistic)singleBenchmarkResult.getSubSingleStatistic(this.problemStatisticType);
                List list = subSingleStatistic.getPointList();
                for (MoveCountPerStepStatisticPoint point : list) {
                    long timeMillisSpent = point.getTimeMillisSpent();
                    long acceptedMoveCount = point.getMoveCountPerStepMeasurement().getAcceptedMoveCount();
                    long selectedMoveCount = point.getMoveCountPerStepMeasurement().getSelectedMoveCount();
                    acceptedSeries.add((double)timeMillisSpent, (double)acceptedMoveCount);
                    selectedSeries.add((double)timeMillisSpent, (double)selectedMoveCount);
                }
            }
            XYSeriesCollection seriesCollection = new XYSeriesCollection();
            seriesCollection.addSeries(acceptedSeries);
            seriesCollection.addSeries(selectedSeries);
            plot.setDataset(seriesIndex, (XYDataset)seriesCollection);
            if (singleBenchmarkResult.getSolverBenchmarkResult().isFavorite()) {
                renderer.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
                renderer.setSeriesStroke(1, (Stroke)new BasicStroke(2.0f, 1, 1, 1.0f, new float[]{2.0f, 6.0f}, 0.0f));
            } else {
                renderer.setSeriesStroke(1, (Stroke)new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{2.0f, 6.0f}, 0.0f));
            }
            Paint linePaint = drawingSupplier.getNextPaint();
            renderer.setSeriesPaint(0, linePaint);
            renderer.setSeriesPaint(1, linePaint);
            plot.setRenderer(seriesIndex, (XYItemRenderer)renderer);
            ++seriesIndex;
        }
        JFreeChart chart = new JFreeChart(this.problemBenchmarkResult.getName() + " move count per step statistic", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        this.graphFile = this.writeChartToImageFile(chart, this.problemBenchmarkResult.getName() + "MoveCountPerStepStatistic");
    }
}

