/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import org.jfree.chart.JFreeChart;
import org.optaplanner.benchmark.config.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.report.ReportHelper;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.SubSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.bestscore.BestScoreProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.bestsolutionmutation.BestSolutionMutationProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.common.GraphSupport;
import org.optaplanner.benchmark.impl.statistic.memoryuse.MemoryUseProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.movecountperstep.MoveCountPerStepProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.scorecalculationspeed.ScoreCalculationSpeedProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.stepscore.StepScoreProblemStatistic;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlSeeAlso(value={BestScoreProblemStatistic.class, StepScoreProblemStatistic.class, ScoreCalculationSpeedProblemStatistic.class, BestSolutionMutationProblemStatistic.class, MoveCountPerStepProblemStatistic.class, MemoryUseProblemStatistic.class})
public abstract class ProblemStatistic {
    @XmlTransient
    protected ProblemBenchmarkResult<Object> problemBenchmarkResult;
    protected final ProblemStatisticType problemStatisticType;
    protected List<String> warningList = null;

    public ProblemStatistic() {
        this.problemStatisticType = null;
    }

    protected ProblemStatistic(ProblemBenchmarkResult problemBenchmarkResult, ProblemStatisticType problemStatisticType) {
        this.problemBenchmarkResult = problemBenchmarkResult;
        this.problemStatisticType = problemStatisticType;
    }

    public ProblemBenchmarkResult getProblemBenchmarkResult() {
        return this.problemBenchmarkResult;
    }

    public void setProblemBenchmarkResult(ProblemBenchmarkResult problemBenchmarkResult) {
        this.problemBenchmarkResult = problemBenchmarkResult;
    }

    public ProblemStatisticType getProblemStatisticType() {
        return this.problemStatisticType;
    }

    public String getAnchorId() {
        return ReportHelper.escapeHtmlId(this.problemBenchmarkResult.getName() + "_" + this.problemStatisticType.name());
    }

    public List<String> getWarningList() {
        return this.warningList;
    }

    public List<SubSingleStatistic> getSubSingleStatisticList() {
        List<SingleBenchmarkResult> singleBenchmarkResultList = this.problemBenchmarkResult.getSingleBenchmarkResultList();
        ArrayList<SubSingleStatistic> subSingleStatisticList = new ArrayList<SubSingleStatistic>(singleBenchmarkResultList.size());
        for (SingleBenchmarkResult singleBenchmarkResult : singleBenchmarkResultList) {
            if (singleBenchmarkResult.getSubSingleBenchmarkResultList().isEmpty()) continue;
            subSingleStatisticList.add(singleBenchmarkResult.getSubSingleBenchmarkResultList().get(0).getEffectiveSubSingleStatisticMap().get(this.problemStatisticType));
        }
        return subSingleStatisticList;
    }

    public abstract SubSingleStatistic createSubSingleStatistic(SubSingleBenchmarkResult var1);

    public void accumulateResults(BenchmarkReport benchmarkReport) {
        this.warningList = new ArrayList<String>();
        this.fillWarningList();
    }

    public abstract void writeGraphFiles(BenchmarkReport var1);

    protected void fillWarningList() {
    }

    protected File writeChartToImageFile(JFreeChart chart, String fileNameBase) {
        File chartFile = new File(this.problemBenchmarkResult.getProblemReportDirectory(), fileNameBase + ".png");
        GraphSupport.writeChartToImageFile(chart, chartFile);
        return chartFile;
    }

    public File getGraphFile() {
        List<File> graphFileList = this.getGraphFileList();
        if (graphFileList == null || graphFileList.isEmpty()) {
            return null;
        }
        if (graphFileList.size() > 1) {
            throw new IllegalStateException("Cannot get graph file for the ProblemStatistic (" + this + ") because it has more than 1 graph file. See method getGraphList() and " + ProblemStatisticType.class.getSimpleName() + ".hasScoreLevels()");
        }
        return graphFileList.get(0);
    }

    public abstract List<File> getGraphFileList();

    public String toString() {
        return this.problemBenchmarkResult + "_" + this.problemStatisticType;
    }
}

