/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.report;

import freemarker.core.Environment;
import freemarker.core.TemplateFormatUtil;
import freemarker.core.TemplateNumberFormat;
import freemarker.core.TemplateNumberFormatFactory;
import freemarker.core.TemplateValueFormatException;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import java.time.Duration;
import java.util.Locale;

final class MillisecondDurationNumberFormatFactory
extends TemplateNumberFormatFactory {
    static final MillisecondDurationNumberFormatFactory INSTANCE = new MillisecondDurationNumberFormatFactory();

    MillisecondDurationNumberFormatFactory() {
    }

    public TemplateNumberFormat get(String params, Locale locale, Environment environment) throws TemplateValueFormatException {
        TemplateFormatUtil.checkHasNoParameters((String)params);
        return MillisecondDurationNumberFormat.INSTANCE;
    }

    static final class MillisecondDurationNumberFormat
    extends TemplateNumberFormat {
        static final MillisecondDurationNumberFormat INSTANCE = new MillisecondDurationNumberFormat();

        MillisecondDurationNumberFormat() {
        }

        public String formatToPlainText(TemplateNumberModel templateNumberModel) throws TemplateModelException {
            Number n = templateNumberModel.getAsNumber();
            if (n == null) {
                return "None.";
            }
            long millis = n.longValue();
            if (millis == 0L) {
                return "0 ms.";
            }
            return MillisecondDurationNumberFormat.processNonZeroMillis(millis);
        }

        private static String processNonZeroMillis(long millis) {
            Duration duration = Duration.ofMillis(millis);
            long daysPart = duration.toDaysPart();
            long hoursPart = duration.toHoursPart();
            long minutesPart = duration.toMinutesPart();
            double seconds = (double)duration.toSecondsPart() + (double)duration.toMillisPart() / 1000.0;
            if (daysPart > 0L) {
                return String.format("%02d:%02d:%02d:%06.3f s. (%,d ms.)", daysPart, hoursPart, minutesPart, seconds, millis);
            }
            if (hoursPart > 0L) {
                return String.format("%02d:%02d:%06.3f s. (%,d ms.)", hoursPart, minutesPart, seconds, millis);
            }
            if (minutesPart > 0L) {
                return String.format("%02d:%06.3f s. (%,d ms.)", minutesPart, seconds, millis);
            }
            return String.format("%.3f s. (%,d ms.)", seconds, millis);
        }

        public boolean isLocaleBound() {
            return true;
        }

        public String getDescription() {
            return "Millisecond Duration";
        }
    }
}

