/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl;

import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.StatisticRegistry;
import org.optaplanner.benchmark.impl.statistic.SubSingleStatistic;
import org.optaplanner.core.api.score.ScoreManager;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.solver.DefaultSolver;
import org.optaplanner.core.impl.solver.DefaultSolverFactory;
import org.optaplanner.core.impl.solver.scope.SolverScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class SubSingleBenchmarkRunner<Solution_>
implements Callable<SubSingleBenchmarkRunner<Solution_>> {
    public static final String NAME_MDC = "subSingleBenchmark.name";
    private static final Logger LOGGER = LoggerFactory.getLogger(SubSingleBenchmarkRunner.class);
    private final SubSingleBenchmarkResult subSingleBenchmarkResult;
    private final boolean warmUp;
    private Long randomSeed = null;
    private Throwable failureThrowable = null;

    public SubSingleBenchmarkRunner(SubSingleBenchmarkResult subSingleBenchmarkResult, boolean warmUp) {
        this.subSingleBenchmarkResult = subSingleBenchmarkResult;
        this.warmUp = warmUp;
    }

    public SubSingleBenchmarkResult getSubSingleBenchmarkResult() {
        return this.subSingleBenchmarkResult;
    }

    public Long getRandomSeed() {
        return this.randomSeed;
    }

    public Throwable getFailureThrowable() {
        return this.failureThrowable;
    }

    public void setFailureThrowable(Throwable failureThrowable) {
        this.failureThrowable = failureThrowable;
    }

    @Override
    public SubSingleBenchmarkRunner<Solution_> call() {
        MDC.put((String)NAME_MDC, (String)this.subSingleBenchmarkResult.getName());
        Runtime runtime = Runtime.getRuntime();
        SingleBenchmarkResult singleBenchmarkResult = this.subSingleBenchmarkResult.getSingleBenchmarkResult();
        ProblemBenchmarkResult problemBenchmarkResult = singleBenchmarkResult.getProblemBenchmarkResult();
        Object problem = problemBenchmarkResult.readProblem();
        if (!problemBenchmarkResult.getPlannerBenchmarkResult().hasMultipleParallelBenchmarks()) {
            runtime.gc();
            this.subSingleBenchmarkResult.setUsedMemoryAfterInputSolution(runtime.totalMemory() - runtime.freeMemory());
        }
        LOGGER.trace("Benchmark problem has been read for subSingleBenchmarkResult ({}).", (Object)this.subSingleBenchmarkResult);
        SolverConfig solverConfig = singleBenchmarkResult.getSolverBenchmarkResult().getSolverConfig();
        if (singleBenchmarkResult.getSubSingleCount() > 1) {
            solverConfig = new SolverConfig(solverConfig);
            solverConfig.offerRandomSeedFromSubSingleIndex((long)this.subSingleBenchmarkResult.getSubSingleBenchmarkIndex());
        }
        HashMap<String, String> subSingleBenchmarkTagMap = new HashMap<String, String>();
        String runId = UUID.randomUUID().toString();
        subSingleBenchmarkTagMap.put("optaplanner.benchmark.run", runId);
        solverConfig = new SolverConfig(solverConfig);
        this.randomSeed = solverConfig.getRandomSeed();
        DefaultSolverFactory solverFactory = new DefaultSolverFactory(new SolverConfig(solverConfig));
        DefaultSolver solver = (DefaultSolver)solverFactory.buildSolver();
        solver.setMonitorTagMap(subSingleBenchmarkTagMap);
        StatisticRegistry statisticRegistry = new StatisticRegistry(solver);
        Metrics.addRegistry(statisticRegistry);
        solver.addPhaseLifecycleListener(statisticRegistry);
        Tags runTag = Tags.of((String)"optaplanner.benchmark.run", (String)runId);
        for (SubSingleStatistic subSingleStatistic : this.subSingleBenchmarkResult.getEffectiveSubSingleStatisticMap().values()) {
            subSingleStatistic.open(statisticRegistry, runTag, solver);
            subSingleStatistic.initPointList();
        }
        Object solution = solver.solve(problem);
        solver.removePhaseLifecycleListener(statisticRegistry);
        Metrics.removeRegistry(statisticRegistry);
        long timeMillisSpent = solver.getTimeMillisSpent();
        for (SubSingleStatistic subSingleStatistic : this.subSingleBenchmarkResult.getEffectiveSubSingleStatisticMap().values()) {
            subSingleStatistic.close(statisticRegistry, runTag, solver);
            subSingleStatistic.hibernatePointList();
        }
        if (!this.warmUp) {
            SolverScope solverScope = solver.getSolverScope();
            SolutionDescriptor solutionDescriptor = solverScope.getSolutionDescriptor();
            problemBenchmarkResult.registerScale(solutionDescriptor.getEntityCount(solution), solutionDescriptor.getGenuineVariableCount(solution), solutionDescriptor.getMaximumValueCount(solution), solutionDescriptor.getProblemScale(solution));
            this.subSingleBenchmarkResult.setScore(solutionDescriptor.getScore(solution));
            this.subSingleBenchmarkResult.setTimeMillisSpent(timeMillisSpent);
            this.subSingleBenchmarkResult.setScoreCalculationCount(solverScope.getScoreCalculationCount());
            ScoreManager scoreManager = ScoreManager.create((SolverFactory)solverFactory);
            boolean isConstraintMatchEnabled = solver.getSolverScope().getScoreDirector().isConstraintMatchEnabled();
            if (isConstraintMatchEnabled) {
                this.subSingleBenchmarkResult.setScoreExplanationSummary(scoreManager.getSummary(solution));
            }
            problemBenchmarkResult.writeSolution(this.subSingleBenchmarkResult, solution);
        }
        MDC.remove((String)NAME_MDC);
        return this;
    }

    public String getName() {
        return this.subSingleBenchmarkResult.getName();
    }

    public String toString() {
        return this.subSingleBenchmarkResult.toString();
    }
}

