/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.extended.FileConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.FilenameUtils;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.benchmark.impl.AbstractPlannerBenchmarkFactory;
import org.optaplanner.core.config.SolverConfigContext;
import org.optaplanner.core.impl.solver.XStreamXmlSolverFactory;

public class XStreamXmlPlannerBenchmarkFactory
extends AbstractPlannerBenchmarkFactory {
    protected XStream xStream = XStreamXmlSolverFactory.buildXStream();

    public XStreamXmlPlannerBenchmarkFactory() {
        this(new SolverConfigContext());
    }

    public XStreamXmlPlannerBenchmarkFactory(SolverConfigContext solverConfigContext) {
        super(solverConfigContext);
        ClassLoader actualClassLoader = solverConfigContext.determineActualClassLoader();
        this.xStream.setClassLoader(actualClassLoader);
        this.xStream.processAnnotations(PlannerBenchmarkConfig.class);
        this.xStream.registerConverter((SingleValueConverter)new FileConverter(){

            public String toString(Object obj) {
                return FilenameUtils.separatorsToUnix((String)((File)obj).getPath());
            }
        });
    }

    public void addXStreamAnnotations(Class ... xStreamAnnotations) {
        this.xStream.processAnnotations(xStreamAnnotations);
        this.xStream.allowTypes(xStreamAnnotations);
    }

    public XStream getXStream() {
        return this.xStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XStreamXmlPlannerBenchmarkFactory configure(String benchmarkConfigResource) {
        ClassLoader actualClassLoader = this.solverConfigContext.determineActualClassLoader();
        try (InputStream in = actualClassLoader.getResourceAsStream(benchmarkConfigResource);){
            if (in == null) {
                String errorMessage = "The benchmarkConfigResource (" + benchmarkConfigResource + ") does not exist as a classpath resource in the classLoader (" + actualClassLoader + ").";
                if (!benchmarkConfigResource.startsWith("/")) throw new IllegalArgumentException(errorMessage);
                errorMessage = errorMessage + "\nAs from 6.1, a classpath resource should not start with a slash (/). A benchmarkConfigResource now adheres to ClassLoader.getResource(String). Remove the leading slash from the benchmarkConfigResource if you're upgrading from 6.0.";
                throw new IllegalArgumentException(errorMessage);
            }
            XStreamXmlPlannerBenchmarkFactory xStreamXmlPlannerBenchmarkFactory = this.configure(in);
            return xStreamXmlPlannerBenchmarkFactory;
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException("Unmarshalling of benchmarkConfigResource (" + benchmarkConfigResource + ") fails.", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Reading the benchmarkConfigResource (" + benchmarkConfigResource + ") failed.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XStreamXmlPlannerBenchmarkFactory configure(File benchmarkConfigFile) {
        try (FileInputStream in = new FileInputStream(benchmarkConfigFile);){
            XStreamXmlPlannerBenchmarkFactory xStreamXmlPlannerBenchmarkFactory = this.configure(in);
            return xStreamXmlPlannerBenchmarkFactory;
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("The benchmarkConfigFile (" + benchmarkConfigFile + ") was not found.", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Reading the benchmarkConfigFile (" + benchmarkConfigFile + ") failed.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XStreamXmlPlannerBenchmarkFactory configure(InputStream in) {
        try (InputStreamReader reader = new InputStreamReader(in, "UTF-8");){
            XStreamXmlPlannerBenchmarkFactory xStreamXmlPlannerBenchmarkFactory = this.configure(reader);
            return xStreamXmlPlannerBenchmarkFactory;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("This vm does not support UTF-8 encoding.", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Reading failed.", e);
        }
    }

    public XStreamXmlPlannerBenchmarkFactory configure(Reader reader) {
        this.plannerBenchmarkConfig = (PlannerBenchmarkConfig)this.xStream.fromXML(reader);
        return this;
    }
}

