/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal;

import io.undertow.security.api.SecurityContext;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.handlers.ServletRequestContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.undertow.internal.PaxWebServletInfo;
import org.ops4j.pax.web.service.undertow.internal.security.OsgiSecurityContext;

public class PaxWebSecurityHandler
implements HandlerWrapper {
    private OsgiContextModel defaultOsgiContextModel;
    private WebContainerContext defaultWebContainerContext;

    public HttpHandler wrap(final HttpHandler handler) {
        return new HttpHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleRequest(HttpServerExchange exchange) throws Exception {
                ServletRequestContext context = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                ServletInfo servletInfo = context.getCurrentServlet().getManagedServlet().getServletInfo();
                if (servletInfo instanceof PaxWebServletInfo) {
                    PaxWebServletInfo paxWebServletInfo = (PaxWebServletInfo)servletInfo;
                    HttpServletRequest req = (HttpServletRequest)context.getServletRequest();
                    HttpServletResponse res = (HttpServletResponse)context.getServletResponse();
                    WebContainerContext webContext = !paxWebServletInfo.is404() ? paxWebServletInfo.getWebContainerContext() : PaxWebSecurityHandler.this.defaultWebContainerContext;
                    try {
                        if (webContext == null || webContext.handleSecurity(req, res)) {
                            if (webContext != null) {
                                Object user = req.getAttribute("org.osgi.service.http.authentication.remote.user");
                                Object authType = req.getAttribute("org.osgi.service.http.authentication.type");
                                SecurityContext sc = exchange.getSecurityContext();
                                if (sc == null) {
                                    if (user != null || authType != null) {
                                        exchange.setSecurityContext((SecurityContext)new OsgiSecurityContext(exchange, user, authType));
                                    }
                                } else if (!(sc.isAuthenticated() || sc.isAuthenticationRequired() || user == null && authType == null)) {
                                    exchange.setSecurityContext((SecurityContext)new OsgiSecurityContext(exchange, user, authType));
                                }
                            }
                            handler.handleRequest(exchange);
                        } else if (!res.isCommitted()) {
                            res.sendError(403);
                        }
                    }
                    finally {
                        if (webContext != null) {
                            webContext.finishSecurity(req, res);
                        }
                    }
                }
            }
        };
    }

    public OsgiContextModel getDefaultOsgiContextModel() {
        return this.defaultOsgiContextModel;
    }

    public void setDefaultOsgiContextModel(OsgiContextModel defaultOsgiContextModel, WebContainerContext resolvedWebContainerContext) {
        this.defaultOsgiContextModel = defaultOsgiContextModel;
        this.defaultWebContainerContext = resolvedWebContainerContext;
    }
}

