/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ops4j.pax.web.service.spi.servlet.OsgiFilterChain;
import org.ops4j.pax.web.service.spi.servlet.PreprocessorFilterConfig;

public class PaxWebPreprocessorsHandler
implements HandlerWrapper {
    private final List<PreprocessorFilterConfig> preprocessors = new LinkedList<PreprocessorFilterConfig>();

    public HttpHandler wrap(final HttpHandler handler) {
        return new HttpHandler(){

            public void handleRequest(final HttpServerExchange exchange) throws Exception {
                ServletRequestContext context = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                HttpServletRequest incomingRequest = (HttpServletRequest)context.getServletRequest();
                HttpServletResponse outgoingRequest = (HttpServletResponse)context.getServletResponse();
                List preprocessorInstances = PaxWebPreprocessorsHandler.this.preprocessors.stream().map(PreprocessorFilterConfig::getInstance).collect(Collectors.toList());
                final Exception[] ex = new Exception[]{null};
                Consumer authListener = null;
                OsgiFilterChain chain = new OsgiFilterChain(new ArrayList(preprocessorInstances), null, null, new FilterChain(){

                    public void doFilter(ServletRequest request, ServletResponse response) {
                        try {
                            handler.handleRequest(exchange);
                        }
                        catch (Exception e) {
                            ex[0] = e;
                        }
                    }
                }, null, authListener);
                chain.doFilter((ServletRequest)incomingRequest, (ServletResponse)outgoingRequest);
                if (ex[0] != null) {
                    throw ex[0];
                }
            }
        };
    }

    public List<PreprocessorFilterConfig> getPreprocessors() {
        return this.preprocessors;
    }
}

