/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;

public class RootHttpOptionsHandler
implements HttpHandler {
    private final String allowedMethods;
    private final HttpHandler next;

    public RootHttpOptionsHandler(HttpHandler next, List<String> disallowedMethods) {
        LinkedHashSet<String> methods = new LinkedHashSet<String>(Arrays.asList("GET", "HEAD", "POST", "PUT", "DELETE", "OPTIONS", "TRACE"));
        for (String m : disallowedMethods) {
            methods.remove(m);
        }
        this.allowedMethods = String.join((CharSequence)", ", methods);
        this.next = next;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (Methods.OPTIONS.equals(exchange.getRequestMethod()) && "*".equals(exchange.getRequestPath())) {
            exchange.setStatusCode(200);
            exchange.getResponseHeaders().put(Headers.ALLOW, this.allowedMethods);
            exchange.endExchange();
        } else {
            this.next.handleRequest(exchange);
        }
    }
}

