/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal.security;

import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.security.idm.X509CertificateCredential;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class JaasIdentityManager
implements IdentityManager {
    private final String realm;
    private final String userPrincipalClassName;
    private final Set<String> rolePrincipalClassNames;

    public JaasIdentityManager(Map<String, String> config) {
        this.realm = config.get("realm");
        this.userPrincipalClassName = config.get("userPrincipalClassName");
        this.rolePrincipalClassNames = Collections.singleton(config.get("rolePrincipalClassNames"));
    }

    public JaasIdentityManager(String realm, String userPrincipalClassName, Set<String> rolePrincipalClassNames) {
        this.realm = realm;
        this.userPrincipalClassName = userPrincipalClassName;
        this.rolePrincipalClassNames = rolePrincipalClassNames;
    }

    public Account verify(Account account) {
        if (!(account instanceof AccountImpl)) {
            return null;
        }
        AccountImpl accountImpl = (AccountImpl)account;
        return this.verify(accountImpl.getPrincipal().getName(), accountImpl.getCredential());
    }

    public Account verify(Credential credential) {
        if (credential instanceof X509CertificateCredential) {
            X509CertificateCredential certCredential = (X509CertificateCredential)credential;
            X509Certificate certificate = certCredential.getCertificate();
            return this.verify(certificate.getSubjectDN().getName(), credential);
        }
        throw new IllegalArgumentException("Parameter must be a X509CertificateCredential");
    }

    public Account verify(String id, Credential credential) {
        try {
            if (credential instanceof PasswordCredential) {
                char[] password = ((PasswordCredential)credential).getPassword();
                Subject subject = new Subject();
                LoginContext loginContext = new LoginContext(this.realm, subject, callbacks -> {
                    for (Callback callback : callbacks) {
                        if (callback instanceof NameCallback) {
                            ((NameCallback)callback).setName(id);
                            continue;
                        }
                        if (callback instanceof PasswordCallback) {
                            ((PasswordCallback)callback).setPassword(password);
                            continue;
                        }
                        throw new UnsupportedCallbackException(callback);
                    }
                });
                loginContext.login();
                Principal userPrincipal = null;
                HashSet<String> roles = new HashSet<String>();
                for (Principal principal : subject.getPrincipals()) {
                    String clazz = principal.getClass().getName();
                    if (this.userPrincipalClassName.equals(clazz)) {
                        userPrincipal = principal;
                        continue;
                    }
                    if (!this.rolePrincipalClassNames.contains(clazz)) continue;
                    roles.add(principal.getName());
                }
                return new AccountImpl(subject, userPrincipal, roles, credential);
            }
        }
        catch (LoginException e) {
            return null;
        }
        return null;
    }

    private static class AccountImpl
    implements Account {
        private final Subject subject;
        private final Principal principal;
        private final Set<String> roles;
        private final Credential credential;

        AccountImpl(Subject subject, Principal principal, Set<String> roles, Credential credential) {
            this.subject = subject;
            this.principal = principal;
            this.roles = roles;
            this.credential = credential;
        }

        public Subject getSubject() {
            return this.subject;
        }

        public Principal getPrincipal() {
            return this.principal;
        }

        public Set<String> getRoles() {
            return this.roles;
        }

        public Credential getCredential() {
            return this.credential;
        }
    }
}

