/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import io.undertow.server.session.SessionManagerStatistics;
import java.util.Set;

public class PaxWebSessionManager
implements SessionManager {
    private final SessionManager delegate;

    public PaxWebSessionManager(SessionManager sessionManager) {
        this.delegate = sessionManager;
    }

    public String getDeploymentName() {
        return this.delegate.getDeploymentName();
    }

    public void start() {
        this.delegate.start();
    }

    public void stop() {
        this.delegate.stop();
    }

    public Session createSession(HttpServerExchange serverExchange, SessionConfig sessionCookieConfig) {
        return this.delegate.createSession(serverExchange, sessionCookieConfig);
    }

    public Session getSession(HttpServerExchange serverExchange, SessionConfig sessionCookieConfig) {
        return this.delegate.getSession(serverExchange, sessionCookieConfig);
    }

    public Session getSession(String sessionId) {
        return this.delegate.getSession(sessionId);
    }

    public void registerSessionListener(final SessionListener listener) {
        this.delegate.registerSessionListener(new SessionListener(){

            public void sessionCreated(Session session, HttpServerExchange exchange) {
                listener.sessionCreated(session, exchange);
            }

            public void sessionDestroyed(Session session, HttpServerExchange exchange, SessionListener.SessionDestroyedReason reason) {
                listener.sessionDestroyed(session, exchange, reason);
            }

            public void attributeAdded(Session session, String name, Object value) {
                if (!name.startsWith("__osgi@session@")) {
                    super.attributeAdded(session, name, value);
                }
            }

            public void attributeUpdated(Session session, String name, Object newValue, Object oldValue) {
                if (!name.startsWith("__osgi@session@")) {
                    super.attributeUpdated(session, name, newValue, oldValue);
                }
            }

            public void attributeRemoved(Session session, String name, Object oldValue) {
                if (!name.startsWith("__osgi@session@")) {
                    super.attributeRemoved(session, name, oldValue);
                }
            }

            public void sessionIdChanged(Session session, String oldSessionId) {
                listener.sessionIdChanged(session, oldSessionId);
            }

            public int hashCode() {
                return listener.hashCode();
            }

            public boolean equals(Object obj) {
                return listener.equals(obj);
            }
        });
    }

    public void removeSessionListener(SessionListener listener) {
        this.delegate.removeSessionListener(listener);
    }

    public void setDefaultSessionTimeout(int timeout) {
        this.delegate.setDefaultSessionTimeout(timeout);
    }

    public Set<String> getTransientSessions() {
        return this.delegate.getTransientSessions();
    }

    public Set<String> getActiveSessions() {
        return this.delegate.getActiveSessions();
    }

    public Set<String> getAllSessions() {
        return this.delegate.getAllSessions();
    }

    public SessionManagerStatistics getStatistics() {
        return this.delegate.getStatistics();
    }
}

