/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal.web;

import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.ServletContainerInitializerInfo;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import jakarta.servlet.ServletContainerInitializer;
import org.ops4j.pax.web.service.spi.model.elements.ContainerInitializerModel;
import org.ops4j.pax.web.service.spi.model.elements.ElementModel;
import org.ops4j.pax.web.service.spi.servlet.OsgiDynamicServletContext;
import org.ops4j.pax.web.service.spi.servlet.RegisteringContainerInitializer;
import org.ops4j.pax.web.service.spi.servlet.SCIWrapper;

public class OsgiServletContainerInitializerInfo
extends ServletContainerInitializerInfo
implements Comparable<OsgiServletContainerInitializerInfo> {
    private final ContainerInitializerModel model;

    public OsgiServletContainerInitializerInfo(ContainerInitializerModel model, OsgiDynamicServletContext context) {
        super(model.getContainerInitializer().getClass(), (InstanceFactory)new SCIInstanceFactory(context, model), model.getClasses());
        this.model = model;
    }

    public OsgiServletContainerInitializerInfo(RegisteringContainerInitializer initializer) {
        super(initializer.getClass(), (InstanceFactory)new ImmediateInstanceFactory((Object)initializer), null);
        this.model = null;
    }

    public ContainerInitializerModel getModel() {
        return this.model;
    }

    @Override
    public int compareTo(OsgiServletContainerInitializerInfo o) {
        return this.model.compareTo((ElementModel)o.model);
    }

    private static final class SCIInstanceFactory
    implements InstanceFactory<ServletContainerInitializer> {
        private final OsgiDynamicServletContext context;
        private ContainerInitializerModel model;

        SCIInstanceFactory(OsgiDynamicServletContext context, ContainerInitializerModel model) {
            this.context = context;
            this.model = model;
        }

        public InstanceHandle<ServletContainerInitializer> createInstance() {
            return new InstanceHandle<ServletContainerInitializer>(){

                public ServletContainerInitializer getInstance() {
                    if (model != null) {
                        return new SCIWrapper(context, model);
                    }
                    return (c, ctx) -> {};
                }

                public void release() {
                }
            };
        }
    }
}

