/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal.security;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.AbstractSecurityContext;
import io.undertow.server.HttpServerExchange;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class OsgiSecurityContext
extends AbstractSecurityContext {
    private final Account principal;
    private final String authMechanism;

    public OsgiSecurityContext(HttpServerExchange exchange, Object principal, Object authMechanism) {
        super(exchange);
        this.principal = principal instanceof String ? new OsgiContextAccount((String)principal) : null;
        this.authMechanism = authMechanism instanceof String ? (String)authMechanism : null;
    }

    public boolean isAuthenticated() {
        return this.principal != null;
    }

    public Account getAuthenticatedAccount() {
        return this.principal;
    }

    public String getMechanismName() {
        return this.authMechanism;
    }

    public boolean authenticate() {
        return this.isAuthenticated();
    }

    public boolean login(String username, String password) {
        return false;
    }

    public void addAuthenticationMechanism(AuthenticationMechanism mechanism) {
    }

    public List<AuthenticationMechanism> getAuthenticationMechanisms() {
        return Collections.emptyList();
    }

    public IdentityManager getIdentityManager() {
        return null;
    }

    private static final class OsgiContextAccount
    implements Account {
        private final OsgiContextPrincipal principal;

        private OsgiContextAccount(String principal) {
            this.principal = new OsgiContextPrincipal(principal);
        }

        public Principal getPrincipal() {
            return this.principal;
        }

        public Set<String> getRoles() {
            return Collections.emptySet();
        }
    }

    private static final class OsgiContextPrincipal
    implements Principal {
        private final String name;

        private OsgiContextPrincipal(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

