/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal;

import io.undertow.security.idm.IdentityManager;
import jakarta.servlet.Servlet;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.ops4j.pax.web.service.spi.ServerController;
import org.ops4j.pax.web.service.spi.ServerState;
import org.ops4j.pax.web.service.spi.config.Configuration;
import org.ops4j.pax.web.service.spi.model.events.ServerEvent;
import org.ops4j.pax.web.service.spi.model.events.ServerListener;
import org.ops4j.pax.web.service.spi.task.Batch;
import org.ops4j.pax.web.service.spi.task.BatchVisitor;
import org.ops4j.pax.web.service.undertow.internal.UndertowFactory;
import org.ops4j.pax.web.service.undertow.internal.UndertowServerWrapper;
import org.ops4j.pax.web.service.undertow.internal.web.UndertowResourceServlet;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndertowServerController
implements ServerController {
    private static final Logger LOG = LoggerFactory.getLogger(UndertowServerController.class);
    private final Bundle paxWebUndertowBundle;
    private final ClassLoader classLoader;
    private final Configuration configuration;
    private ServerState state;
    private final Set<ServerListener> listeners;
    private final UndertowFactory undertowFactory;
    private UndertowServerWrapper undertowServerWrapper;
    private IdentityManager identityManager;

    public UndertowServerController(Bundle paxWebUndertowBundle, ClassLoader classLoader, UndertowFactory undertowFactory, Configuration configuration) {
        this.paxWebUndertowBundle = paxWebUndertowBundle;
        this.classLoader = classLoader;
        this.undertowFactory = undertowFactory;
        this.configuration = configuration;
        this.state = ServerState.UNCONFIGURED;
        this.listeners = Collections.synchronizedSet(new LinkedHashSet());
    }

    public ServerState getState() {
        return this.state;
    }

    public void configure() throws Exception {
        LOG.info("Configuring {}", (Object)this);
        if (this.state != ServerState.UNCONFIGURED) {
            throw new IllegalStateException("Can't configure Undertow server controller in state " + String.valueOf(this.state));
        }
        this.undertowServerWrapper = new UndertowServerWrapper(this.configuration, this.undertowFactory, this.paxWebUndertowBundle, this.classLoader);
        this.undertowServerWrapper.configure();
        this.state = ServerState.STOPPED;
        this.notifyListeners(new ServerEvent(ServerEvent.State.CONFIGURED, this.undertowServerWrapper.getAddresses(false)));
    }

    public synchronized void start() throws Exception {
        LOG.info("Starting {}", (Object)this);
        if (this.state != ServerState.STOPPED) {
            throw new IllegalStateException("Can't start Undertow server controller in state " + String.valueOf(this.state));
        }
        this.undertowServerWrapper.start();
        this.state = ServerState.STARTED;
        this.notifyListeners(new ServerEvent(ServerEvent.State.STARTED, this.undertowServerWrapper.getAddresses(true)));
    }

    public void stop() throws Exception {
        LOG.info("Stopping {}", (Object)this);
        if (this.state != ServerState.STARTED) {
            throw new IllegalStateException("Can't stop Undertow server controller in state " + String.valueOf(this.state));
        }
        this.undertowServerWrapper.stop();
        this.state = ServerState.STOPPED;
        this.notifyListeners(new ServerEvent(ServerEvent.State.STOPPED, null));
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void addListener(ServerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("ServerListener is null");
        }
        if (this.listeners.add(listener)) {
            if (this.state == ServerState.STOPPED) {
                listener.stateChanged(new ServerEvent(ServerEvent.State.CONFIGURED, this.undertowServerWrapper.getAddresses(false)));
            } else if (this.state == ServerState.STARTED) {
                listener.stateChanged(new ServerEvent(ServerEvent.State.STARTED, this.undertowServerWrapper.getAddresses(true)));
            }
        }
    }

    public void removeListener(ServerListener listener) {
        this.listeners.remove(listener);
    }

    void notifyListeners(ServerEvent event) {
        for (ServerListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    public Servlet createResourceServlet(URL urlBase, String base) {
        Integer maxAge;
        Integer maxEntries;
        Integer maxEntrySize;
        File baseDirectory;
        try {
            baseDirectory = urlBase == null ? null : new File(urlBase.toURI());
        }
        catch (URISyntaxException notPossbleButStill) {
            throw new IllegalArgumentException(notPossbleButStill.getMessage(), notPossbleButStill);
        }
        String chroot = baseDirectory == null ? base : null;
        UndertowResourceServlet undertowResourceServlet = new UndertowResourceServlet(baseDirectory, chroot);
        Integer maxSize = this.configuration.resources().maxTotalCacheSize();
        if (maxSize == null) {
            maxSize = 0x400000;
        }
        if ((maxEntrySize = this.configuration.resources().maxCacheEntrySize()) == null) {
            maxEntrySize = 0x200000;
        }
        if ((maxEntries = this.configuration.resources().maxCacheEntries()) == null) {
            maxEntries = 2048;
        }
        if ((maxAge = this.configuration.resources().maxCacheTTL()) == null) {
            maxAge = 60000;
        }
        int metadataCacheSize = maxEntries;
        undertowResourceServlet.setCachingConfiguration(metadataCacheSize, maxEntrySize, maxSize, maxAge);
        return undertowResourceServlet;
    }

    public void sendBatch(Batch batch) {
        LOG.info("Receiving {}", (Object)batch);
        if (this.state == ServerState.UNCONFIGURED) {
            throw new IllegalStateException("Can't process batch in Undertow server controller in state " + String.valueOf(this.state));
        }
        batch.accept((BatchVisitor)this.undertowServerWrapper);
    }

    public String toString() {
        return "UndertowServerController{configuration=" + this.configuration.id() + ",state=" + String.valueOf(this.state) + "}";
    }
}

