/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.configuration.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.ops4j.pax.web.service.undertow.internal.configuration.ParserUtils;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public class ServletContainer {
    protected static final QName ATT_NAME = new QName("name");
    protected static final QName ATT_DEFAULT_SESSION_TIMEOUT = new QName("default-session-timeout");
    private String name;
    private String defaultSessionTimeout = "30";
    private JspConfig jspConfig;
    private PersistentSessionsConfig persistentSessions;
    private Websockets websockets;
    private final List<WelcomeFile> welcomeFiles = new ArrayList<WelcomeFile>();
    private SessionCookie sessionCookie;

    public static ServletContainer create(Map<QName, String> attributes, Locator locator) {
        ServletContainer container = new ServletContainer();
        container.name = attributes.get(ATT_NAME);
        container.defaultSessionTimeout = attributes.get(ATT_DEFAULT_SESSION_TIMEOUT);
        return container;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDefaultSessionTimeout() {
        return this.defaultSessionTimeout;
    }

    public void setDefaultSessionTimeout(String defaultSessionTimeout) {
        this.defaultSessionTimeout = defaultSessionTimeout;
    }

    public JspConfig getJspConfig() {
        return this.jspConfig;
    }

    public void setJspConfig(JspConfig jspConfig) {
        this.jspConfig = jspConfig;
    }

    public PersistentSessionsConfig getPersistentSessions() {
        return this.persistentSessions;
    }

    public void setPersistentSessions(PersistentSessionsConfig persistentSessions) {
        this.persistentSessions = persistentSessions;
    }

    public Websockets getWebsockets() {
        return this.websockets;
    }

    public void setWebsockets(Websockets websockets) {
        this.websockets = websockets;
    }

    public List<WelcomeFile> getWelcomeFiles() {
        return this.welcomeFiles;
    }

    public SessionCookie getSessionCookie() {
        return this.sessionCookie;
    }

    public void setSessionCookie(SessionCookie sessionCookie) {
        this.sessionCookie = sessionCookie;
    }

    public String toString() {
        return "{ name: " + this.name + ", default session timeout: " + this.defaultSessionTimeout + ", jsp config: " + String.valueOf(this.jspConfig) + ", session cookie config: " + String.valueOf(this.sessionCookie) + ", websockets: " + String.valueOf(this.websockets) + ", welcome files: " + String.valueOf(this.welcomeFiles) + " }";
    }

    public static class JspConfig {
        public String toString() {
            return "{ }";
        }
    }

    public static class PersistentSessionsConfig {
        private static final QName ATT_PATH = new QName("path");
        private String path;

        public static PersistentSessionsConfig create(Map<QName, String> attributes, Locator locator) {
            PersistentSessionsConfig config = new PersistentSessionsConfig();
            config.path = attributes.get(ATT_PATH);
            return config;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String toString() {
            return "{ path: " + this.path + "}";
        }
    }

    public static class Websockets {
        protected static final QName ATT_WORKER = new QName("worker");
        protected static final QName ATT_BUFFER_POOL = new QName("buffer-pool");
        protected static final QName ATT_DISPATCH_TO_WORKER = new QName("dispatch-to-worker");
        protected static final QName ATT_PER_MESSAGE_DEFLATE = new QName("per-message-deflate");
        protected static final QName ATT_DEFLATER_LEVEL = new QName("deflater-level");
        protected String workerName = "default";
        protected String bufferPoolName = "default";
        protected boolean dispatchToWorker = true;
        protected boolean perMessageDeflate = false;
        protected int deflaterLevel = 1;

        public static Websockets create(Map<QName, String> attributes, Locator locator) throws SAXParseException {
            Websockets ws = new Websockets();
            ws.workerName = ParserUtils.toStringValue(attributes.get(ATT_WORKER), locator, "default");
            ws.bufferPoolName = ParserUtils.toStringValue(attributes.get(ATT_BUFFER_POOL), locator, "default");
            ws.dispatchToWorker = ParserUtils.toBoolean(attributes.get(ATT_DISPATCH_TO_WORKER), locator, true);
            ws.perMessageDeflate = ParserUtils.toBoolean(attributes.get(ATT_PER_MESSAGE_DEFLATE), locator, false);
            ws.deflaterLevel = ParserUtils.toInteger(attributes.get(ATT_DEFLATER_LEVEL), locator, 1);
            return ws;
        }

        public String getWorkerName() {
            return this.workerName;
        }

        public void setWorkerName(String workerName) {
            this.workerName = workerName;
        }

        public String getBufferPoolName() {
            return this.bufferPoolName;
        }

        public void setBufferPoolName(String bufferPoolName) {
            this.bufferPoolName = bufferPoolName;
        }

        public boolean isDispatchToWorker() {
            return this.dispatchToWorker;
        }

        public void setDispatchToWorker(boolean dispatchToWorker) {
            this.dispatchToWorker = dispatchToWorker;
        }

        public boolean isPerMessageDeflate() {
            return this.perMessageDeflate;
        }

        public void setPerMessageDeflate(boolean perMessageDeflate) {
            this.perMessageDeflate = perMessageDeflate;
        }

        public int getDeflaterLevel() {
            return this.deflaterLevel;
        }

        public void setDeflaterLevel(int deflaterLevel) {
            this.deflaterLevel = deflaterLevel;
        }

        public String toString() {
            return "{ worker name: " + this.workerName + ", buffer pool name: " + this.bufferPoolName + ", dispatch: " + this.dispatchToWorker + ", per message deflate: " + this.perMessageDeflate + ", deflater level: " + this.deflaterLevel + " }";
        }
    }

    public static class SessionCookie {
        protected static final QName ATT_NAME = new QName("name");
        protected static final QName ATT_DOMAIN = new QName("domain");
        protected static final QName ATT_COMMENT = new QName("comment");
        protected static final QName ATT_HTTP_ONLY = new QName("http-only");
        protected static final QName ATT_SECURE = new QName("secure");
        protected static final QName ATT_MAX_AGE = new QName("max-age");
        private String name;
        private String domain;
        private String comment;
        private boolean httpOnly = true;
        private boolean secure = true;
        private Integer maxAge;

        public static SessionCookie create(Map<QName, String> attributes, Locator locator) throws SAXParseException {
            SessionCookie config = new SessionCookie();
            config.name = attributes.get(ATT_NAME);
            config.domain = attributes.get(ATT_DOMAIN);
            config.comment = attributes.get(ATT_COMMENT);
            config.httpOnly = ParserUtils.toBoolean(attributes.get(ATT_HTTP_ONLY), locator, true);
            config.secure = ParserUtils.toBoolean(attributes.get(ATT_SECURE), locator, true);
            config.maxAge = ParserUtils.toInteger(attributes.get(ATT_MAX_AGE), locator, null);
            return config;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDomain() {
            return this.domain;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public boolean isHttpOnly() {
            return this.httpOnly;
        }

        public void setHttpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public void setSecure(boolean secure) {
            this.secure = secure;
        }

        public Integer getMaxAge() {
            return this.maxAge;
        }

        public void setMaxAge(Integer maxAge) {
            this.maxAge = maxAge;
        }

        public String toString() {
            return "{ name: " + this.name + ", domain: " + this.domain + ", comment: " + this.comment + ", http only: " + this.httpOnly + ", secure: " + this.secure + ", max age: " + this.maxAge + " }";
        }
    }

    public static class WelcomeFile {
        protected static final QName ATT_NAME = new QName("name");
        private String name;

        public static WelcomeFile create(Map<QName, String> attributes, Locator locator) {
            WelcomeFile wf = new WelcomeFile();
            wf.name = attributes.get(ATT_NAME);
            return wf;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return "{ name: " + this.name + " }";
        }
    }
}

