/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal.web;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.server.handlers.resource.CachingResourceManager;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Enumeration;
import org.ops4j.pax.web.service.spi.servlet.OsgiScopedServletContext;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContext;
import org.ops4j.pax.web.service.undertow.internal.web.DefaultServlet;
import org.ops4j.pax.web.service.undertow.internal.web.FileETagFunction;
import org.ops4j.pax.web.service.undertow.internal.web.FlexibleDeployment;
import org.ops4j.pax.web.service.undertow.internal.web.FlexibleServletContextImpl;
import org.ops4j.pax.web.service.undertow.internal.web.OsgiResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndertowResourceServlet
extends DefaultServlet
implements ResourceManager {
    public static final Logger LOG = LoggerFactory.getLogger(UndertowResourceServlet.class);
    private ResourceManager cachingResourceManager;
    private final File baseDirectory;
    private final String chroot;
    private ResourceManager resourceManager;
    private String[] welcomeFiles;
    private boolean redirectWelcome = false;
    private boolean pathInfoOnly = true;
    private boolean cacheConfigurable = false;
    private int metadataCacheSize;
    private Integer maxEntrySize;
    private Integer maxSize;
    private Integer maxAge;

    public UndertowResourceServlet(File baseDirectory, String chroot) {
        this.baseDirectory = baseDirectory;
        this.chroot = chroot;
    }

    public void setCachingResourceManager(CachingResourceManager cachingResourceManager) {
        this.cachingResourceManager = cachingResourceManager;
    }

    public void setCachingConfiguration(int metadataCacheSize, Integer maxEntrySize, Integer maxSize, Integer maxAge) {
        this.metadataCacheSize = metadataCacheSize;
        this.maxEntrySize = maxEntrySize;
        this.maxSize = maxSize;
        this.maxAge = maxAge;
        this.cacheConfigurable = true;
    }

    public void setWelcomeFiles(String[] welcomeFiles) {
        this.welcomeFiles = welcomeFiles;
        this.configureCache();
    }

    public void setWelcomeFilesRedirect(boolean welcomeFilesRedirect) {
        this.redirectWelcome = welcomeFilesRedirect;
    }

    @Override
    public void init(final ServletConfig config) throws ServletException {
        this.configureCache();
        FlexibleDeployment deployment = new FlexibleDeployment(config.getServletContext(), this.cachingResourceManager);
        FlexibleServletContextImpl flexibleServletContext = new FlexibleServletContextImpl(deployment);
        super.init(new ServletConfig(){
            final /* synthetic */ ServletContext val$flexibleServletContext;
            {
                this.val$flexibleServletContext = servletContext;
            }

            public String getServletName() {
                return config.getServletName();
            }

            public ServletContext getServletContext() {
                return this.val$flexibleServletContext;
            }

            public String getInitParameter(String name) {
                return config.getInitParameter(name);
            }

            public Enumeration<String> getInitParameterNames() {
                return config.getInitParameterNames();
            }
        });
        this.redirectWelcome = "true".equalsIgnoreCase(this.getInitParameter("redirectWelcome"));
        this.pathInfoOnly = !"false".equalsIgnoreCase(this.getInitParameter("pathInfoOnly"));
        ServletContext osgiScopedServletContext = config.getServletContext();
        if (this.welcomeFiles == null) {
            if (osgiScopedServletContext instanceof OsgiScopedServletContext) {
                this.welcomeFiles = ((OsgiScopedServletContext)osgiScopedServletContext).getWelcomeFiles();
                this.redirectWelcome = ((OsgiScopedServletContext)osgiScopedServletContext).isWelcomeFilesRedirect();
            } else if (osgiScopedServletContext instanceof OsgiServletContext) {
                this.welcomeFiles = ((OsgiServletContext)osgiScopedServletContext).getWelcomeFiles();
                this.redirectWelcome = ((OsgiServletContext)osgiScopedServletContext).isWelcomeFilesRedirect();
            }
        }
        if (this.welcomeFiles == null) {
            this.welcomeFiles = new String[0];
        }
        this.resourceManager = this.baseDirectory != null ? FileResourceManager.builder().setBase(Paths.get(this.baseDirectory.getAbsolutePath(), new String[0])).setETagFunction((PathResourceManager.ETagFunction)new FileETagFunction()).build() : new OsgiResourceManager(this.chroot, config.getServletContext());
    }

    private void configureCache() {
        if (this.cacheConfigurable) {
            int maxMemory = this.maxSize;
            boolean maxRegions = true;
            int maxRegionSize = this.maxSize;
            int slicePerPage = 32;
            int sliceSize = this.maxSize / slicePerPage;
            DirectBufferCache cache = new DirectBufferCache(sliceSize, slicePerPage, maxMemory);
            this.cachingResourceManager = new CachingResourceManager(this.metadataCacheSize, (long)this.maxEntrySize.intValue(), cache, (ResourceManager)this, this.maxAge.intValue());
        }
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String relativePath;
        boolean included = false;
        String requestURI = (String)req.getAttribute("jakarta.servlet.include.request_uri");
        if (requestURI == null) {
            requestURI = req.getRequestURI();
        } else {
            included = true;
        }
        if (requestURI == null || !requestURI.endsWith("/")) {
            super.doGet(req, resp);
            return;
        }
        String servletPath = (String)req.getAttribute("jakarta.servlet.include.servlet_path");
        if (servletPath == null) {
            String string = servletPath = !included ? req.getServletPath() : "";
        }
        if (servletPath.endsWith("/")) {
            servletPath = servletPath.substring(0, servletPath.length() - 1);
        }
        if ("".equals(relativePath = this.getPath(req))) {
            relativePath = "/";
        }
        HttpServerExchange exchange = UndertowResourceServlet.requireCurrentServletRequestContext().getOriginalRequest().getExchange();
        String resolvedWelcome = null;
        for (String welcome : this.welcomeFiles) {
            String path = relativePath + welcome;
            Resource resource = this.resourceSupplier.getResource(exchange, path);
            if (resource == null) continue;
            resolvedWelcome = this.pathInfoOnly ? servletPath + path : path;
            break;
        }
        RequestDispatcher dispatcher = null;
        if (resolvedWelcome == null) {
            for (String welcome : this.welcomeFiles) {
                String path = relativePath + welcome;
                dispatcher = req.getRequestDispatcher(path);
                if (dispatcher == null) continue;
                resolvedWelcome = path;
                break;
            }
        }
        if (resolvedWelcome != null) {
            if (this.redirectWelcome) {
                if (included) {
                    LOG.warn("Can't redirect to welcome page for INCLUDE dispatch");
                    return;
                }
                String queryString = req.getQueryString();
                if (queryString != null && !"".equals(queryString)) {
                    resolvedWelcome = resolvedWelcome + "?" + queryString;
                }
                resolvedWelcome = req.getContextPath() + resolvedWelcome;
                resp.sendRedirect(resp.encodeRedirectURL(resolvedWelcome));
            } else {
                if (dispatcher == null) {
                    dispatcher = req.getRequestDispatcher(resolvedWelcome);
                }
                if (included) {
                    dispatcher.include((ServletRequest)req, (ServletResponse)resp);
                } else {
                    dispatcher.forward((ServletRequest)req, (ServletResponse)resp);
                }
            }
            return;
        }
        Resource resource = this.resourceSupplier.getResource(exchange, relativePath);
        if (resource == null) {
            if (req.getDispatcherType() == DispatcherType.ERROR) {
                resp.sendError(((Integer)req.getAttribute("jakarta.servlet.error.status_code")).intValue());
            } else {
                resp.sendError(404, requestURI);
            }
            return;
        }
        if (req.getDispatcherType() == DispatcherType.ERROR) {
            resp.sendError(((Integer)req.getAttribute("jakarta.servlet.error.status_code")).intValue());
        } else {
            resp.sendError(403, requestURI);
        }
        super.doGet(req, resp);
    }

    @Override
    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setHeader("Allow", "GET, HEAD, OPTIONS");
    }

    public Resource getResource(String path) throws IOException {
        HttpServletRequestImpl originalRequest = UndertowResourceServlet.requireCurrentServletRequestContext().getOriginalRequest();
        String pathInfo = originalRequest.getPathInfo();
        if (pathInfo == null && this.pathInfoOnly) {
            String servletPath = originalRequest.getServletPath();
            if (servletPath != null && servletPath.startsWith("/")) {
                servletPath = servletPath.substring(1);
            }
            if (path.equals(servletPath)) {
                path = "";
            }
        }
        return this.resourceManager.getResource(path);
    }

    public boolean isResourceChangeListenerSupported() {
        return false;
    }

    public void registerResourceChangeListener(ResourceChangeListener listener) {
    }

    public void removeResourceChangeListener(ResourceChangeListener listener) {
    }

    public void close() throws IOException {
        this.resourceManager.close();
    }
}

