/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal;

import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import io.undertow.servlet.util.ImmediateInstanceHandle;
import jakarta.servlet.Servlet;
import java.util.ArrayList;
import java.util.List;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.elements.ServletModel;
import org.ops4j.pax.web.service.spi.servlet.OsgiInitializedServlet;
import org.ops4j.pax.web.service.spi.servlet.OsgiScopedServletContext;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContext;
import org.ops4j.pax.web.service.undertow.internal.web.UndertowResourceServlet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceObjects;

public class PaxWebServletInfo
extends ServletInfo {
    private final ServletModel servletModel;
    private OsgiContextModel osgiContextModel;
    private Servlet servlet;
    private Class<? extends Servlet> servletClass;
    private final OsgiServletContext osgiServletContext;
    private final OsgiScopedServletContext servletContext;
    private final WebContainerContext webContainerContext;
    private boolean is404 = false;
    private final List<String> mappings = new ArrayList<String>();
    private final boolean whiteboardTCCL;

    PaxWebServletInfo(String name, Servlet servlet, boolean is404) {
        super(name, servlet.getClass(), (InstanceFactory)new ImmediateInstanceFactory((Object)servlet));
        this.servletModel = null;
        this.osgiContextModel = null;
        this.osgiServletContext = null;
        this.servletContext = null;
        this.webContainerContext = null;
        this.servlet = servlet;
        this.is404 = is404;
        this.whiteboardTCCL = false;
    }

    public PaxWebServletInfo(ServletModel model, OsgiContextModel osgiContextModel, OsgiServletContext osgiServletContext, boolean whiteboardTCCL) {
        super(model.getName(), model.getActualClass(), (InstanceFactory)new ServletModelFactory(model, new OsgiScopedServletContext(osgiServletContext, model.getRegisteringBundle()), whiteboardTCCL));
        this.osgiContextModel = osgiContextModel;
        this.osgiServletContext = osgiServletContext;
        this.servletModel = model;
        for (String pattern : model.getUrlPatterns()) {
            this.addMapping(pattern);
        }
        this.servletModel.getInitParams().forEach((arg_0, arg_1) -> ((PaxWebServletInfo)this).addInitParam(arg_0, arg_1));
        this.setAsyncSupported(this.servletModel.getAsyncSupported() != null && this.servletModel.getAsyncSupported() != false);
        if (this.servletModel.getLoadOnStartup() != null) {
            this.setLoadOnStartup(this.servletModel.getLoadOnStartup());
        }
        this.setMultipartConfig(this.servletModel.getMultipartConfigElement());
        this.servletContext = ((ServletModelFactory)super.getInstanceFactory()).getServletContext();
        this.webContainerContext = this.servletContext.getResolvedWebContainerContext();
        this.whiteboardTCCL = whiteboardTCCL;
    }

    public ServletModel getServletModel() {
        return this.servletModel;
    }

    public Bundle getRegisteringBundle() {
        return this.servletModel.getRegisteringBundle();
    }

    public boolean is404() {
        return this.is404;
    }

    public OsgiScopedServletContext getServletContext() {
        return this.servletContext;
    }

    public OsgiServletContext getOsgiServletContext() {
        return this.osgiServletContext;
    }

    public void setOsgiContextModel(OsgiContextModel osgiContextModel) {
        this.osgiContextModel = osgiContextModel;
    }

    public OsgiContextModel getOsgiContextModel() {
        return this.osgiContextModel;
    }

    public WebContainerContext getWebContainerContext() {
        return this.webContainerContext;
    }

    public List<String> getMappings() {
        return this.mappings;
    }

    public ServletInfo addMapping(String mapping) {
        if (!(mapping.startsWith("/") || mapping.startsWith("*") || mapping.isEmpty())) {
            this.mappings.add("/" + mapping);
        } else {
            this.mappings.add(mapping);
        }
        return this;
    }

    public ServletInfo clone() {
        PaxWebServletInfo info;
        if (!this.is404) {
            info = new PaxWebServletInfo(this.servletModel, this.osgiContextModel, this.osgiServletContext, this.whiteboardTCCL);
        } else {
            info = new PaxWebServletInfo(this.getName(), this.servlet, true);
            info.addMappings(this.getMappings());
        }
        info.setJspFile(this.getJspFile());
        info.setLoadOnStartup(this.getLoadOnStartup());
        info.setEnabled(this.isEnabled());
        info.setAsyncSupported(this.isAsyncSupported());
        info.setRunAs(this.getRunAs());
        info.setMultipartConfig(this.getMultipartConfig());
        info.setExecutor(this.getExecutor());
        info.setRequireWelcomeFileMapping(this.isRequireWelcomeFileMapping());
        this.getSecurityRoleRefs().forEach(r -> info.addSecurityRoleRef(r.getRole(), r.getLinkedRole()));
        this.getHandlerChainWrappers().forEach(arg_0 -> ((ServletInfo)info).addHandlerChainWrapper(arg_0));
        if (this.getServletSecurityInfo() != null) {
            info.setServletSecurityInfo(this.getServletSecurityInfo().clone());
        }
        this.getInitParams().forEach((arg_0, arg_1) -> ((ServletInfo)info).addInitParam(arg_0, arg_1));
        return info;
    }

    public String toString() {
        return "PaxWebServletInfo{mappings=" + String.valueOf(this.mappings) + ", servletClass=" + String.valueOf(this.servletClass) + ", name='" + this.getName() + "'}";
    }

    private static class ServletModelFactory
    implements InstanceFactory<Servlet> {
        private final ServletModel model;
        private final OsgiScopedServletContext osgiScopedServletContext;
        private ServiceObjects<Servlet> serviceObjects;
        private final boolean whiteboardTCCL;

        ServletModelFactory(ServletModel model, OsgiScopedServletContext osgiScopedServletContext, boolean whiteboardTCCL) {
            this.model = model;
            this.osgiScopedServletContext = osgiScopedServletContext;
            this.whiteboardTCCL = whiteboardTCCL;
        }

        public InstanceHandle<Servlet> createInstance() throws InstantiationException {
            Servlet instance = this.model.getServlet();
            if (instance == null) {
                if (this.model.getElementReference() != null) {
                    BundleContext context = this.model.getRegisteringBundle().getBundleContext();
                    if (context != null) {
                        if (!this.model.isPrototype()) {
                            instance = (Servlet)context.getService(this.model.getElementReference());
                        } else {
                            this.serviceObjects = context.getServiceObjects(this.model.getElementReference());
                            instance = (Servlet)this.serviceObjects.getService();
                        }
                    }
                    if (instance == null) {
                        this.model.setDtoFailureCode(5);
                        throw new RuntimeException("Can't get a Servlet service from the reference " + String.valueOf(this.model.getElementReference()));
                    }
                } else if (this.model.getServletClass() != null) {
                    try {
                        instance = (Servlet)this.model.getServletClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        InstantiationException instantiationException = new InstantiationException(e.getMessage());
                        instantiationException.initCause(e);
                        throw instantiationException;
                    }
                } else if (this.model.getElementSupplier() != null) {
                    instance = (Servlet)this.model.getElementSupplier().get();
                }
            }
            if (instance != null && this.model.isResourceServlet()) {
                ((UndertowResourceServlet)instance).setWelcomeFiles(this.osgiScopedServletContext.getWelcomeFiles());
                ((UndertowResourceServlet)instance).setWelcomeFilesRedirect(this.osgiScopedServletContext.isWelcomeFilesRedirect());
            }
            return new ImmediateInstanceHandle<Servlet>((Servlet)new OsgiInitializedServlet(instance, this.osgiScopedServletContext, this.whiteboardTCCL, this.model)){

                public void release() {
                    if (model.getElementReference() != null) {
                        try {
                            if (!model.isPrototype()) {
                                BundleContext context = model.getRegisteringBundle().getBundleContext();
                                if (context != null) {
                                    context.ungetService(model.getElementReference());
                                }
                            } else if (this.getInstance() != null) {
                                Servlet realServlet = (Servlet)this.getInstance();
                                if (realServlet instanceof OsgiInitializedServlet) {
                                    realServlet = ((OsgiInitializedServlet)realServlet).getDelegate();
                                }
                                serviceObjects.ungetService((Object)realServlet);
                            }
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                    }
                    if (model.getRegisteringBundle() != null) {
                        try {
                            osgiScopedServletContext.releaseWebContainerContext(model.getRegisteringBundle());
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                    }
                }
            };
        }

        public OsgiScopedServletContext getServletContext() {
            return this.osgiScopedServletContext;
        }
    }
}

