/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal;

import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.util.ImmediateInstanceHandle;
import jakarta.servlet.Filter;
import jakarta.servlet.ServletContext;
import java.util.Map;
import org.ops4j.pax.web.service.spi.model.elements.FilterModel;
import org.ops4j.pax.web.service.spi.servlet.OsgiInitializedFilter;
import org.ops4j.pax.web.service.spi.servlet.OsgiScopedServletContext;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContext;
import org.ops4j.pax.web.service.spi.servlet.ScopedFilter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;

public class PaxWebFilterInfo
extends FilterInfo {
    private final FilterModel filterModel;
    private final OsgiServletContext osgiServletContext;
    private ServiceReference<? extends Filter> serviceReference;
    private final boolean whiteboardTCCL;

    public PaxWebFilterInfo(FilterModel model, OsgiServletContext osgiServletContext, boolean whiteboardTCCL) {
        super(model.getName(), model.getActualClass(), (InstanceFactory)new FilterModelFactory(model, new OsgiScopedServletContext(osgiServletContext, model.getRegisteringBundle()), whiteboardTCCL));
        this.osgiServletContext = osgiServletContext;
        this.filterModel = model;
        for (Map.Entry param : this.filterModel.getInitParams().entrySet()) {
            this.addInitParam((String)param.getKey(), (String)param.getValue());
        }
        this.setAsyncSupported(this.filterModel.getAsyncSupported() != null && this.filterModel.getAsyncSupported() != false);
        this.filterModel.getInitParams().forEach((arg_0, arg_1) -> ((PaxWebFilterInfo)this).addInitParam(arg_0, arg_1));
        this.whiteboardTCCL = whiteboardTCCL;
    }

    public FilterInfo clone() {
        PaxWebFilterInfo info = new PaxWebFilterInfo(this.filterModel, this.osgiServletContext, this.whiteboardTCCL);
        info.setAsyncSupported(this.isAsyncSupported());
        this.getInitParams().forEach((arg_0, arg_1) -> ((FilterInfo)info).addInitParam(arg_0, arg_1));
        return info;
    }

    public FilterModel getFilterModel() {
        return this.filterModel;
    }

    private static class FilterModelFactory
    implements InstanceFactory<Filter> {
        private final FilterModel model;
        private final OsgiScopedServletContext osgiScopedServletContext;
        private ServiceObjects<Filter> serviceObjects;
        private final boolean whiteboardTCCL;

        FilterModelFactory(FilterModel model, OsgiScopedServletContext osgiScopedServletContext, boolean whiteboardTCCL) {
            this.model = model;
            this.osgiScopedServletContext = osgiScopedServletContext;
            this.whiteboardTCCL = whiteboardTCCL;
        }

        public InstanceHandle<Filter> createInstance() throws InstantiationException {
            Filter instance = this.model.getFilter();
            if (instance == null) {
                if (this.model.getElementReference() != null) {
                    BundleContext context = this.model.getRegisteringBundle().getBundleContext();
                    if (context != null) {
                        if (!this.model.isPrototype()) {
                            instance = (Filter)context.getService(this.model.getElementReference());
                        } else {
                            this.serviceObjects = context.getServiceObjects(this.model.getElementReference());
                            instance = (Filter)this.serviceObjects.getService();
                        }
                    }
                    if (instance == null) {
                        this.model.setDtoFailureCode(5);
                        throw new RuntimeException("Can't get a Filter service from the reference " + String.valueOf(this.model.getElementReference()));
                    }
                } else if (this.model.getFilterClass() != null) {
                    try {
                        instance = (Filter)this.model.getFilterClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        InstantiationException instantiationException = new InstantiationException(e.getMessage());
                        instantiationException.initCause(e);
                        throw instantiationException;
                    }
                } else if (this.model.getElementSupplier() != null) {
                    instance = (Filter)this.model.getElementSupplier().get();
                }
            }
            OsgiInitializedFilter osgiInitializedFilter = new OsgiInitializedFilter(instance, this.model, (ServletContext)this.osgiScopedServletContext, this.whiteboardTCCL);
            ScopedFilter scopedFilter = new ScopedFilter((Filter)osgiInitializedFilter, this.model);
            return new ImmediateInstanceHandle<Filter>((Filter)scopedFilter){

                public void release() {
                    if (model.getElementReference() != null) {
                        try {
                            if (!model.isPrototype()) {
                                BundleContext context = model.getRegisteringBundle().getBundleContext();
                                if (context != null) {
                                    context.ungetService(model.getElementReference());
                                }
                            } else if (this.getInstance() != null) {
                                Filter realFilter = (Filter)this.getInstance();
                                if (realFilter instanceof ScopedFilter) {
                                    realFilter = ((ScopedFilter)realFilter).getDelegate();
                                }
                                if (realFilter instanceof OsgiInitializedFilter) {
                                    realFilter = ((OsgiInitializedFilter)realFilter).getDelegate();
                                }
                                serviceObjects.ungetService((Object)realFilter);
                            }
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                    }
                    if (model.getRegisteringBundle() != null) {
                        osgiScopedServletContext.releaseWebContainerContext(model.getRegisteringBundle());
                    }
                }
            };
        }

        public OsgiScopedServletContext getServletContext() {
            return this.osgiScopedServletContext;
        }
    }
}

