/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.configuration.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.ops4j.pax.web.service.undertow.internal.configuration.ParserUtils;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public class IoSubsystem {
    private final List<Worker> workers = new ArrayList<Worker>();
    private final List<BufferPool> bufferPools = new ArrayList<BufferPool>();

    public List<Worker> getWorkers() {
        return this.workers;
    }

    public List<BufferPool> getBufferPools() {
        return this.bufferPools;
    }

    public String toString() {
        return "{\n\t\tworkers: " + String.valueOf(this.workers) + "\n\t\tbuffer pools: " + String.valueOf(this.bufferPools) + "\n\t}";
    }

    public static class BufferPool {
        private static final QName ATT_NAME = new QName("name");
        private static final QName ATT_BUFFER_SIZE = new QName("buffer-size");
        private static final QName ATT_DIRECT_BUFFERS = new QName("direct-buffers");
        private String name;
        private Integer bufferSize;
        private boolean directBuffers = true;

        public static BufferPool create(Map<QName, String> attributes, Locator locator) throws SAXParseException {
            BufferPool pool = new BufferPool();
            pool.name = attributes.get(ATT_NAME);
            pool.bufferSize = ParserUtils.toInteger(attributes.get(ATT_BUFFER_SIZE), locator, null);
            pool.directBuffers = ParserUtils.toBoolean(attributes.get(ATT_DIRECT_BUFFERS), locator, true);
            return pool;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getBufferSize() {
            return this.bufferSize;
        }

        public void setBufferSize(Integer bufferSize) {
            this.bufferSize = bufferSize;
        }

        public boolean getDirectBuffers() {
            return this.directBuffers;
        }

        public void setDirectBuffers(boolean directBuffers) {
            this.directBuffers = directBuffers;
        }

        public String toString() {
            return "{ name: " + this.name + ", buffer size: " + this.bufferSize + ", use direct buffers: " + this.directBuffers + " }";
        }
    }

    public static class Worker {
        private static final QName ATT_NAME = new QName("name");
        private static final QName ATT_IO_THREADS = new QName("io-threads");
        private static final QName ATT_TASK_KEEP_ALIVE = new QName("task-keepalive");
        private static final QName ATT_TASK_CORE_THREADS = new QName("task-core-threads");
        private static final QName ATT_TASK_MAX_THREADS = new QName("task-max-threads");
        private static final QName ATT_STACK_SIZE = new QName("stack-size");
        private static final int DEFAULT_IO_THREADS = Math.max(Runtime.getRuntime().availableProcessors(), 2);
        private static final int DEFAULT_TASK_CORE_THREADS = Math.max(Runtime.getRuntime().availableProcessors(), 2) * 8;
        private static final int DEFAULT_TASK_MAX_THREADS = Math.max(Runtime.getRuntime().availableProcessors(), 2) * 8;
        private String name;
        private int ioThreads = DEFAULT_IO_THREADS;
        private int taskKeepalive = 60000;
        private int taskCoreThreads = DEFAULT_TASK_CORE_THREADS;
        private int taskMaxThreads = DEFAULT_TASK_MAX_THREADS;
        private long stackSize = 0L;

        public static Worker create(Map<QName, String> attributes, Locator locator) throws SAXParseException {
            Worker worker = new Worker();
            worker.name = attributes.get(ATT_NAME);
            worker.ioThreads = ParserUtils.toInteger(attributes.get(ATT_IO_THREADS), locator, DEFAULT_IO_THREADS);
            worker.taskKeepalive = ParserUtils.toInteger(attributes.get(ATT_TASK_KEEP_ALIVE), locator, 60000);
            worker.taskCoreThreads = ParserUtils.toInteger(attributes.get(ATT_TASK_CORE_THREADS), locator, DEFAULT_TASK_CORE_THREADS);
            worker.taskMaxThreads = ParserUtils.toInteger(attributes.get(ATT_TASK_MAX_THREADS), locator, DEFAULT_TASK_MAX_THREADS);
            worker.stackSize = ParserUtils.toLong(attributes.get(ATT_STACK_SIZE), locator, 0L);
            return worker;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getIoThreads() {
            return this.ioThreads;
        }

        public void setIoThreads(int ioThreads) {
            this.ioThreads = ioThreads;
        }

        public int getTaskKeepalive() {
            return this.taskKeepalive;
        }

        public void setTaskKeepalive(int taskKeepalive) {
            this.taskKeepalive = taskKeepalive;
        }

        public int getTaskCoreThreads() {
            return this.taskCoreThreads;
        }

        public void setTaskCoreThreads(int taskCoreThreads) {
            this.taskCoreThreads = taskCoreThreads;
        }

        public int getTaskMaxThreads() {
            return this.taskMaxThreads;
        }

        public void setTaskMaxThreads(int taskMaxThreads) {
            this.taskMaxThreads = taskMaxThreads;
        }

        public long getStackSize() {
            return this.stackSize;
        }

        public void setStackSize(long stackSize) {
            this.stackSize = stackSize;
        }

        public String toString() {
            return "{ name: " + this.name + ", io threads: " + this.ioThreads + ", task max threads: " + this.taskMaxThreads + ", task core threads: " + this.taskCoreThreads + ", task keep alive: " + this.taskKeepalive + ", stack size: " + this.stackSize + " }";
        }
    }
}

