/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.security.idm.Account;
import java.io.Serializable;
import java.security.Principal;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.AdapterUtils;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OidcKeycloakAccount;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;

public class KeycloakUndertowAccount
implements Account,
Serializable,
OidcKeycloakAccount {
    protected static Logger log = Logger.getLogger(KeycloakUndertowAccount.class);
    protected KeycloakPrincipal<RefreshableKeycloakSecurityContext> principal;
    protected Set<String> accountRoles;

    public KeycloakUndertowAccount(KeycloakPrincipal<RefreshableKeycloakSecurityContext> principal) {
        this.principal = principal;
        this.setRoles((RefreshableKeycloakSecurityContext)principal.getKeycloakSecurityContext());
    }

    protected void setRoles(RefreshableKeycloakSecurityContext session) {
        Set roles;
        this.accountRoles = roles = AdapterUtils.getRolesFromSecurityContext((RefreshableKeycloakSecurityContext)session);
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Set<String> getRoles() {
        return this.accountRoles;
    }

    public RefreshableKeycloakSecurityContext getKeycloakSecurityContext() {
        return (RefreshableKeycloakSecurityContext)this.principal.getKeycloakSecurityContext();
    }

    public void setCurrentRequestInfo(KeycloakDeployment deployment, AdapterTokenStore tokenStore) {
        ((RefreshableKeycloakSecurityContext)this.principal.getKeycloakSecurityContext()).setCurrentRequestInfo(deployment, tokenStore);
    }

    public boolean checkActive() {
        RefreshableKeycloakSecurityContext session = this.getKeycloakSecurityContext();
        if (session.isActive() && !session.getDeployment().isAlwaysRefreshToken()) {
            log.debug((Object)"session is active");
            return true;
        }
        log.debug((Object)"session is not active or refresh is enforced. Try refresh");
        boolean success = session.refreshExpiredToken(false);
        if (!success || !session.isActive()) {
            log.debug((Object)"session is not active return with failure");
            return false;
        }
        log.debug((Object)"refresh succeeded");
        this.setRoles(session);
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KeycloakUndertowAccount)) {
            return false;
        }
        KeycloakUndertowAccount otherAccount = (KeycloakUndertowAccount)other;
        return (this.principal != null ? this.principal.equals(otherAccount.principal) : otherAccount.principal == null) && (this.accountRoles != null ? this.accountRoles.equals(otherAccount.accountRoles) : otherAccount.accountRoles == null);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.principal == null ? 0 : this.principal.hashCode());
        result = 31 * result + (this.accountRoles == null ? 0 : this.accountRoles.hashCode());
        return result;
    }
}

