/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal.web;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Set;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.WebResourceSet;
import org.apache.catalina.webresources.AbstractResource;
import org.apache.catalina.webresources.AbstractResourceSet;
import org.apache.catalina.webresources.DirResourceSet;
import org.apache.catalina.webresources.EmptyResource;
import org.apache.catalina.webresources.FileResource;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.juli.logging.Log;
import org.ops4j.pax.web.service.tomcat.internal.web.TomcatResourceServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OsgiStandardRoot
extends StandardRoot {
    public static final Logger LOG = LoggerFactory.getLogger(OsgiStandardRoot.class);
    private final ServletContext osgiScopedServletContext;
    private final File baseDirectory;
    private final String chroot;
    private final WebResourceRoot root;
    private final int maxEntrySize;

    OsgiStandardRoot(WebResourceRoot root, File baseDirectory, String chroot, ServletContext osgiScopedServletContext, int maxEntrySize) {
        super(root.getContext());
        this.root = root;
        this.baseDirectory = baseDirectory;
        this.chroot = chroot;
        this.osgiScopedServletContext = osgiScopedServletContext;
        this.maxEntrySize = maxEntrySize;
    }

    @Override
    protected WebResourceSet createMainResourceSet() {
        if (this.baseDirectory != null) {
            return new DirResourceSet(this, "/", this.baseDirectory.getAbsolutePath(), "/");
        }
        return new AbstractResourceSet(){

            @Override
            public boolean getClassLoaderOnly() {
                return false;
            }

            @Override
            public boolean getStaticOnly() {
                return true;
            }

            @Override
            protected void initInternal() throws LifecycleException {
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public WebResource getResource(String path) {
                URL resource;
                String fullPath;
                block37: {
                    fullPath = OsgiStandardRoot.this.chroot + path;
                    if (fullPath.startsWith("/")) {
                        fullPath = fullPath.substring(1);
                    }
                    resource = null;
                    try {
                        resource = OsgiStandardRoot.this.osgiScopedServletContext.getResource(fullPath);
                    }
                    catch (MalformedURLException e) {
                        TomcatResourceServlet.LOG.warn(e.getMessage(), (Throwable)e);
                    }
                    if (resource == null) {
                        if (fullPath.equals("")) {
                            fullPath = "/";
                        }
                        try {
                            resource = OsgiStandardRoot.this.osgiScopedServletContext.getResource(fullPath);
                        }
                        catch (MalformedURLException e) {
                            TomcatResourceServlet.LOG.warn(e.getMessage(), (Throwable)e);
                        }
                        if (resource == null) {
                            return new EmptyResource(OsgiStandardRoot.this.root, path);
                        }
                    }
                    if (resource.getProtocol().equals("file")) {
                        try {
                            File file = new File(resource.toURI());
                            if (file.isFile()) return new FileResource(OsgiStandardRoot.this.root, fullPath, file, true, null);
                            if (!file.isDirectory()) return new EmptyResource(OsgiStandardRoot.this.root, path);
                            return new FileResource(OsgiStandardRoot.this.root, fullPath, file, true, null);
                        }
                        catch (URISyntaxException e) {
                            LOG.warn(e.getMessage(), (Throwable)e);
                            return new EmptyResource(OsgiStandardRoot.this.root, path);
                        }
                    }
                    if (resource.getProtocol().equals("bundle")) {
                        if ("/".equals(resource.getPath())) {
                            return new DirectoryURLResource(OsgiStandardRoot.this, resource, fullPath);
                        }
                        if (!resource.getPath().endsWith("/")) {
                            try {
                                UrlResource potentialDirectory = new UrlResource(OsgiStandardRoot.this, resource, fullPath, OsgiStandardRoot.this.maxEntrySize);
                                if (!potentialDirectory.exists()) break block37;
                                try (InputStream is = potentialDirectory.getInputStream();){
                                    URL fixedURL;
                                    UrlResource properDirectory;
                                    if (!(is != null && is.available() != 0 || potentialDirectory.getContent() != null && potentialDirectory.getContent().length != 0 || !(properDirectory = new UrlResource(OsgiStandardRoot.this, fixedURL = new URL(resource.toExternalForm() + "/"), fullPath, OsgiStandardRoot.this.maxEntrySize)).exists())) {
                                        UrlResource urlResource = properDirectory;
                                        return urlResource;
                                    }
                                }
                            }
                            catch (IOException e) {
                                LOG.warn("Problem checking directory bundle resource: {}", (Object)e.getMessage(), (Object)e);
                                return new EmptyResource(OsgiStandardRoot.this.root, path);
                            }
                        }
                    } else if (resource.getProtocol().equals("bundleentry")) {
                        if ("/".equals(resource.getPath())) {
                            return new DirectoryURLResource(OsgiStandardRoot.this, resource, fullPath);
                        }
                        if (resource.getPath().endsWith("/")) {
                            return new DirectoryURLResource(OsgiStandardRoot.this, resource, fullPath);
                        }
                    }
                }
                try {
                    return new UrlResource(OsgiStandardRoot.this, resource, fullPath, OsgiStandardRoot.this.maxEntrySize);
                }
                catch (IOException e) {
                    LOG.warn(e.getMessage(), (Throwable)e);
                    return new EmptyResource(OsgiStandardRoot.this.root, path);
                }
            }

            @Override
            public String[] list(String path) {
                return new String[0];
            }

            @Override
            public Set<String> listWebAppPaths(String path) {
                return Collections.emptySet();
            }

            @Override
            public boolean mkdir(String path) {
                return false;
            }

            @Override
            public boolean write(String path, InputStream is, boolean overwrite) {
                return false;
            }

            @Override
            public URL getBaseUrl() {
                return null;
            }

            @Override
            public void setReadOnly(boolean readOnly) {
            }

            @Override
            public boolean isReadOnly() {
                return true;
            }

            @Override
            public void gc() {
            }

            @Override
            public void setAllowLinking(boolean b) {
            }

            @Override
            public boolean getAllowLinking() {
                return false;
            }
        };
    }

    private static class DirectoryURLResource
    extends AbstractResource {
        private final URL url;

        DirectoryURLResource(WebResourceRoot root, URL url, String fullPath) {
            super(root, fullPath);
            this.url = url;
        }

        @Override
        protected InputStream doGetInputStream() {
            return null;
        }

        @Override
        protected Log getLog() {
            return null;
        }

        @Override
        public long getLastModified() {
            return 0L;
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public boolean isVirtual() {
            return false;
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public boolean isFile() {
            return false;
        }

        @Override
        public boolean delete() {
            return false;
        }

        @Override
        public String getName() {
            return "/";
        }

        @Override
        public long getContentLength() {
            return 0L;
        }

        @Override
        public String getCanonicalPath() {
            return "/";
        }

        @Override
        public boolean canRead() {
            return true;
        }

        @Override
        public byte[] getContent() {
            return new byte[0];
        }

        @Override
        public long getCreation() {
            return 0L;
        }

        @Override
        public URL getURL() {
            return this.url;
        }

        @Override
        public URL getCodeBase() {
            return null;
        }

        @Override
        public Certificate[] getCertificates() {
            return new Certificate[0];
        }

        @Override
        public Manifest getManifest() {
            return null;
        }
    }

    private static class UrlResource
    extends AbstractResource {
        private final URL url;
        private final int maxEntrySize;
        private URLConnection urlConnection;
        private InputStream in;
        private final File file;
        private byte[] content;

        UrlResource(WebResourceRoot root, URL url, String fullPath, int maxEntrySize) throws IOException {
            super(root, fullPath);
            this.url = url;
            this.maxEntrySize = maxEntrySize;
            this.doGetInputStream(false);
            this.file = new File(url.getPath());
        }

        @Override
        protected InputStream doGetInputStream() {
            return this.doGetInputStream(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized InputStream doGetInputStream(boolean forceNew) {
            block8: {
                if (this.urlConnection == null) {
                    try {
                        this.urlConnection = this.url.openConnection();
                        this.urlConnection.setUseCaches(true);
                        this.in = this.urlConnection.getInputStream();
                        if (this.getContentLength() > (long)this.maxEntrySize) break block8;
                        byte[] buf = new byte[4096];
                        int read = -1;
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        try {
                            while ((read = this.in.read(buf)) > 0) {
                                baos.write(buf, 0, read);
                            }
                            this.content = baos.toByteArray();
                        }
                        finally {
                            this.in.close();
                            this.in = null;
                        }
                    }
                    catch (IOException e) {
                        LOG.warn(e.getMessage(), (Throwable)e);
                    }
                }
            }
            InputStream result = this.in;
            if (forceNew) {
                this.in = null;
                this.urlConnection = null;
            }
            return result;
        }

        @Override
        protected Log getLog() {
            return null;
        }

        @Override
        public long getLastModified() {
            return this.urlConnection.getLastModified();
        }

        @Override
        public boolean exists() {
            this.doGetInputStream(false);
            return this.in != null || this.content != null;
        }

        @Override
        public boolean isVirtual() {
            return true;
        }

        @Override
        public boolean isDirectory() {
            return this.url.getPath().endsWith("/");
        }

        @Override
        public boolean isFile() {
            return !this.url.getPath().endsWith("/");
        }

        @Override
        public boolean delete() {
            return false;
        }

        @Override
        public String getName() {
            return this.file.getName();
        }

        @Override
        public long getContentLength() {
            return this.urlConnection.getContentLength();
        }

        @Override
        public String getCanonicalPath() {
            try {
                return this.file.getCanonicalPath();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        @Override
        public boolean canRead() {
            this.doGetInputStream(false);
            return this.in != null || this.content != null;
        }

        @Override
        public byte[] getContent() {
            return this.content;
        }

        @Override
        public long getCreation() {
            return this.urlConnection.getLastModified();
        }

        @Override
        public URL getURL() {
            return this.url;
        }

        @Override
        public URL getCodeBase() {
            return null;
        }

        @Override
        public Certificate[] getCertificates() {
            return new Certificate[0];
        }

        @Override
        public Manifest getManifest() {
            return null;
        }
    }
}

