/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal;

import java.util.HashMap;
import java.util.Map;
import org.ops4j.pax.web.service.spi.ServerController;
import org.ops4j.pax.web.service.spi.ServerControllerFactory;
import org.ops4j.pax.web.service.spi.config.Configuration;
import org.ops4j.pax.web.service.tomcat.internal.TomcatFactory;
import org.ops4j.pax.web.service.tomcat.internal.TomcatServerController;
import org.osgi.framework.Bundle;

public class TomcatServerControllerFactory
implements ServerControllerFactory {
    private final Bundle paxWebTomcatBundle;
    private final ClassLoader classLoader;
    private final Map<String, ServerController> serverControllers = new HashMap<String, ServerController>();
    private final TomcatFactory tomcatFactory;

    public TomcatServerControllerFactory(Bundle paxWebTomcatBundle, ClassLoader classLoader) {
        this.paxWebTomcatBundle = paxWebTomcatBundle;
        this.classLoader = classLoader;
        this.tomcatFactory = new TomcatFactory(classLoader);
    }

    public synchronized ServerController createServerController(Configuration configuration) {
        if (this.serverControllers.containsKey(configuration.id())) {
            return this.serverControllers.get(configuration.id());
        }
        TomcatServerController controller = new TomcatServerController(this.paxWebTomcatBundle, this.classLoader, this.tomcatFactory, configuration);
        this.serverControllers.put(configuration.id(), controller);
        return controller;
    }

    public void releaseServerController(ServerController controller, Configuration configuration) {
        this.serverControllers.remove(configuration.id(), controller);
    }
}

