/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.Servlet;
import org.ops4j.pax.web.service.spi.Configuration;
import org.ops4j.pax.web.service.spi.LifeCycle;
import org.ops4j.pax.web.service.spi.ServerController;
import org.ops4j.pax.web.service.spi.ServerControllerEx;
import org.ops4j.pax.web.service.spi.ServerEvent;
import org.ops4j.pax.web.service.spi.ServerListener;
import org.ops4j.pax.web.service.spi.model.ContainerInitializerModel;
import org.ops4j.pax.web.service.spi.model.ContextModel;
import org.ops4j.pax.web.service.spi.model.ErrorPageModel;
import org.ops4j.pax.web.service.spi.model.EventListenerModel;
import org.ops4j.pax.web.service.spi.model.FilterModel;
import org.ops4j.pax.web.service.spi.model.SecurityConstraintMappingModel;
import org.ops4j.pax.web.service.spi.model.ServletModel;
import org.ops4j.pax.web.service.spi.model.WelcomeFileModel;
import org.ops4j.pax.web.service.tomcat.internal.ServerState;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TomcatServerController
implements ServerController,
ServerControllerEx {
    private static final Logger LOG = LoggerFactory.getLogger(TomcatServerController.class);
    private ServerState serverState;
    private final Set<ServerListener> listeners = this.newThreadSafeSet();

    private TomcatServerController(ServerState initialState) {
        this.serverState = initialState;
    }

    private Set<ServerListener> newThreadSafeSet() {
        return new CopyOnWriteArraySet<ServerListener>();
    }

    public void start() {
        LOG.debug("start server");
        this.serverState = this.serverState.start();
        this.fireStateChange(ServerEvent.STARTED);
    }

    public void stop() {
        LOG.debug("stop server");
        this.serverState = this.serverState.stop();
        this.fireStateChange(ServerEvent.STOPPED);
    }

    public boolean isStarted() {
        return this.serverState.isStarted();
    }

    public boolean isConfigured() {
        return this.serverState.isConfigured();
    }

    public void configure(Configuration configuration) {
        LOG.debug("set configuration");
        this.serverState = this.serverState.configure(configuration);
        this.fireStateChange(ServerEvent.CONFIGURED);
        this.start();
    }

    public Configuration getConfiguration() {
        return this.serverState.getConfiguration();
    }

    public void addListener(ServerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ServerListener listener) {
        this.listeners.remove(listener);
    }

    public void removeContext(HttpContext httpContext) {
        this.serverState.removeContext(httpContext);
    }

    public void addServlet(ServletModel model) {
        this.serverState.addServlet(model);
    }

    public void removeServlet(ServletModel model) {
        this.serverState.removeServlet(model);
    }

    public void addEventListener(EventListenerModel eventListenerModel) {
        this.serverState.addEventListener(eventListenerModel);
    }

    public void removeEventListener(EventListenerModel eventListenerModel) {
        this.serverState.removeEventListener(eventListenerModel);
    }

    public void addFilter(FilterModel filterModel) {
        this.serverState.addFilter(filterModel);
    }

    public void removeFilter(FilterModel filterModel) {
        this.serverState.removeFilter(filterModel);
    }

    public void addErrorPage(ErrorPageModel model) {
        this.serverState.addErrorPage(model);
    }

    public void removeErrorPage(ErrorPageModel model) {
        this.serverState.removeErrorPage(model);
    }

    public LifeCycle getContext(ContextModel model) {
        return this.serverState.getContext(model);
    }

    public Integer getHttpPort() {
        return this.serverState.getHttpPort();
    }

    public Integer getHttpSecurePort() {
        return this.serverState.getHttpSecurePort();
    }

    public Servlet createResourceServlet(ContextModel contextModel, String alias, String name) {
        return this.serverState.createResourceServlet(contextModel, alias, name);
    }

    public void addSecurityConstraintMapping(SecurityConstraintMappingModel secMapModel) {
        this.serverState.addSecurityConstraintMapping(secMapModel);
    }

    public void removeSecurityConstraintMapping(SecurityConstraintMappingModel secMapModel) {
        this.serverState.removeSecurityConstraintMapping(secMapModel);
    }

    public void addContainerInitializerModel(ContainerInitializerModel model) {
        this.serverState.addContainerInitializerModel(model);
    }

    private void fireStateChange(ServerEvent event) {
        for (ServerListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    static ServerController newInstance(ServerState serverState) {
        return new TomcatServerController(serverState);
    }

    public void addWelcomFiles(WelcomeFileModel model) {
        this.serverState.addWelcomeFiles(model);
    }

    public void removeWelcomeFiles(WelcomeFileModel model) {
        this.serverState.removeWelcomeFiles(model);
    }
}

