/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.Contained;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.mapper.Mapper;
import org.apache.catalina.mapper.MappingData;
import org.apache.catalina.valves.ValveBase;

public class ContextSelectionHostValve
extends ValveBase {
    Valve standardHostValve;
    Mapper mapper;

    public ContextSelectionHostValve(Valve standardHostValve, Mapper mapper) {
        super(true);
        this.standardHostValve = standardHostValve;
        this.mapper = mapper;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        MappingData md = request.getMappingData();
        if (md.contexts != null && md.contexts.length > 1 && md.wrapper == null) {
            for (int i = 0; md.wrapper == null && i < md.contexts.length; ++i) {
                md.context = md.contexts[i];
                this.mapper.map(md.context, request.getDecodedRequestURIMB(), md);
            }
        }
        this.standardHostValve.invoke(request, response);
    }

    public void setContainer(Container container) {
        super.setContainer(container);
        if (this.standardHostValve instanceof Contained) {
            ((Contained)this.standardHostValve).setContainer(container);
        }
    }

    protected void startInternal() throws LifecycleException {
        super.startInternal();
        if (this.standardHostValve instanceof Lifecycle) {
            ((Lifecycle)this.standardHostValve).start();
        }
    }

    protected void stopInternal() throws LifecycleException {
        super.stopInternal();
        if (this.standardHostValve instanceof Lifecycle) {
            ((Lifecycle)this.standardHostValve).stop();
        }
    }
}

