/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal;

import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.Servlet;
import org.ops4j.pax.web.service.spi.Configuration;
import org.ops4j.pax.web.service.spi.LifeCycle;
import org.ops4j.pax.web.service.spi.model.ContainerInitializerModel;
import org.ops4j.pax.web.service.spi.model.ContextModel;
import org.ops4j.pax.web.service.spi.model.ErrorPageModel;
import org.ops4j.pax.web.service.spi.model.EventListenerModel;
import org.ops4j.pax.web.service.spi.model.FilterModel;
import org.ops4j.pax.web.service.spi.model.SecurityConstraintMappingModel;
import org.ops4j.pax.web.service.spi.model.ServletModel;
import org.ops4j.pax.web.service.spi.model.WelcomeFileModel;
import org.ops4j.pax.web.service.tomcat.internal.AbstractServerState;
import org.ops4j.pax.web.service.tomcat.internal.ServerState;
import org.ops4j.pax.web.service.tomcat.internal.ServerStateFactory;
import org.ops4j.pax.web.service.tomcat.internal.ServerWrapper;
import org.osgi.service.http.HttpContext;

class ActiveServerState
extends AbstractServerState
implements ServerState {
    private final ServerState initializedState;
    private final ServerWrapper serverWrapper;

    ActiveServerState(ServerStateFactory serverStateFactory, ServerState initializedState, ServerWrapper serverWrapper) {
        super(serverStateFactory);
        this.initializedState = initializedState;
        this.serverWrapper = serverWrapper;
    }

    @Override
    public Servlet createResourceServlet(ContextModel contextModel, String alias, String name) {
        return this.serverWrapper.createResourceServlet(contextModel, alias, name);
    }

    @Override
    public void addSecurityConstraintMapping(SecurityConstraintMappingModel secMapModel) {
        this.serverWrapper.addSecurityConstraintMapping(secMapModel);
    }

    @Override
    public void removeSecurityConstraintMapping(SecurityConstraintMappingModel secMapModel) {
        this.serverWrapper.removeSecurityConstraintMapping(secMapModel);
    }

    @Override
    public void addContainerInitializerModel(ContainerInitializerModel model) {
        super.addContainerInitializerModel(model);
    }

    static ServerState getInstance(ServerStateFactory serverStateFactory, ServerState initializedState, ServerWrapper server) {
        return new ActiveServerState(serverStateFactory, initializedState, server);
    }

    @Override
    public ServerState start() {
        return (ServerState)this.throwIllegalState();
    }

    @Override
    public ServerState stop() {
        this.serverWrapper.stop();
        return this.initializedState;
    }

    @Override
    public boolean isStarted() {
        return true;
    }

    @Override
    public boolean isConfigured() {
        return true;
    }

    @Override
    public ServerState configure(Configuration configuration) {
        return this.stop().configure(configuration).start();
    }

    @Override
    public ServerState.States getState() {
        return ServerState.States.ACTIVE;
    }

    @Override
    public Configuration getConfiguration() {
        return this.initializedState.getConfiguration();
    }

    @Override
    public void addServlet(ServletModel model) {
        this.serverWrapper.addServlet(model);
    }

    @Override
    public void removeServlet(ServletModel model) {
        this.serverWrapper.removeServlet(model);
    }

    @Override
    public void removeContext(HttpContext httpContext) {
        this.serverWrapper.removeContext(httpContext);
    }

    @Override
    public void addErrorPage(ErrorPageModel model) {
        this.serverWrapper.addErrorPage(model);
    }

    @Override
    public void removeErrorPage(ErrorPageModel model) {
        this.serverWrapper.removeErrorPage(model);
    }

    @Override
    public void addFilter(FilterModel filterModel) {
        this.serverWrapper.addFilter(filterModel);
    }

    @Override
    public void removeFilter(FilterModel filterModel) {
        this.serverWrapper.removeFilter(filterModel);
    }

    @Override
    public void addEventListener(EventListenerModel eventListenerModel) {
        this.serverWrapper.addEventListener(eventListenerModel);
    }

    @Override
    public void removeEventListener(EventListenerModel eventListenerModel) {
        this.serverWrapper.removeEventListener(eventListenerModel);
    }

    @Override
    Collection<String> getSupportedOperations() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("#*(...)");
        return result;
    }

    @Override
    public Integer getHttpPort() {
        return this.initializedState.getHttpPort();
    }

    @Override
    public Integer getHttpSecurePort() {
        return this.initializedState.getHttpSecurePort();
    }

    @Override
    public LifeCycle getContext(ContextModel model) {
        return this.serverWrapper.getContext(model);
    }

    @Override
    public void addWelcomeFiles(WelcomeFileModel model) {
        this.serverWrapper.addWelcomeFiles(model);
    }

    @Override
    public void removeWelcomeFiles(WelcomeFileModel model) {
        this.serverWrapper.removeWelcomeFiles(model);
    }
}

