/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextAttributeListener;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.http.HttpSessionAttributeListener;
import jakarta.servlet.http.HttpSessionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.apache.catalina.AccessLog;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Executor;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.AccessLogAdapter;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.loader.ParallelWebappClassLoader;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.util.ToStringUtil;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.catalina.webresources.TomcatURLStreamHandlerFactory;
import org.apache.tomcat.util.descriptor.web.ErrorPage;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.apache.tomcat.util.descriptor.web.SecurityCollection;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.apache.tomcat.util.descriptor.web.WebXml;
import org.apache.tomcat.util.descriptor.web.WebXmlParser;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.http.Rfc6265CookieProcessor;
import org.apache.tomcat.util.http.SameSiteCookies;
import org.ops4j.pax.web.service.spi.config.Configuration;
import org.ops4j.pax.web.service.spi.config.LogConfiguration;
import org.ops4j.pax.web.service.spi.config.SessionConfiguration;
import org.ops4j.pax.web.service.spi.model.ContextMetadataModel;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.ServletContextModel;
import org.ops4j.pax.web.service.spi.model.elements.ContainerInitializerModel;
import org.ops4j.pax.web.service.spi.model.elements.ElementModel;
import org.ops4j.pax.web.service.spi.model.elements.ErrorPageModel;
import org.ops4j.pax.web.service.spi.model.elements.EventListenerModel;
import org.ops4j.pax.web.service.spi.model.elements.FilterModel;
import org.ops4j.pax.web.service.spi.model.elements.LoginConfigModel;
import org.ops4j.pax.web.service.spi.model.elements.SecurityConfigurationModel;
import org.ops4j.pax.web.service.spi.model.elements.SecurityConstraintModel;
import org.ops4j.pax.web.service.spi.model.elements.ServletModel;
import org.ops4j.pax.web.service.spi.model.elements.WebSocketModel;
import org.ops4j.pax.web.service.spi.model.elements.WelcomeFileModel;
import org.ops4j.pax.web.service.spi.model.events.ServerEvent;
import org.ops4j.pax.web.service.spi.servlet.Default404Servlet;
import org.ops4j.pax.web.service.spi.servlet.DynamicRegistrations;
import org.ops4j.pax.web.service.spi.servlet.OsgiDynamicServletContext;
import org.ops4j.pax.web.service.spi.servlet.OsgiInitializedServlet;
import org.ops4j.pax.web.service.spi.servlet.OsgiScopedListener;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContext;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContextClassLoader;
import org.ops4j.pax.web.service.spi.servlet.OsgiSessionAttributeListener;
import org.ops4j.pax.web.service.spi.servlet.PreprocessorFilterConfig;
import org.ops4j.pax.web.service.spi.servlet.RegisteringContainerInitializer;
import org.ops4j.pax.web.service.spi.servlet.SCIWrapper;
import org.ops4j.pax.web.service.spi.task.BatchVisitor;
import org.ops4j.pax.web.service.spi.task.Change;
import org.ops4j.pax.web.service.spi.task.ClearDynamicRegistrationsChange;
import org.ops4j.pax.web.service.spi.task.ContainerInitializerModelChange;
import org.ops4j.pax.web.service.spi.task.ContextMetadataModelChange;
import org.ops4j.pax.web.service.spi.task.ContextParamsChange;
import org.ops4j.pax.web.service.spi.task.ContextStartChange;
import org.ops4j.pax.web.service.spi.task.ContextStopChange;
import org.ops4j.pax.web.service.spi.task.ErrorPageModelChange;
import org.ops4j.pax.web.service.spi.task.ErrorPageStateChange;
import org.ops4j.pax.web.service.spi.task.EventListenerModelChange;
import org.ops4j.pax.web.service.spi.task.FilterModelChange;
import org.ops4j.pax.web.service.spi.task.FilterStateChange;
import org.ops4j.pax.web.service.spi.task.MimeAndLocaleMappingChange;
import org.ops4j.pax.web.service.spi.task.OpCode;
import org.ops4j.pax.web.service.spi.task.OsgiContextModelChange;
import org.ops4j.pax.web.service.spi.task.SecurityConfigChange;
import org.ops4j.pax.web.service.spi.task.ServletContextModelChange;
import org.ops4j.pax.web.service.spi.task.ServletModelChange;
import org.ops4j.pax.web.service.spi.task.TransactionStateChange;
import org.ops4j.pax.web.service.spi.task.WebSocketModelChange;
import org.ops4j.pax.web.service.spi.task.WelcomeFileModelChange;
import org.ops4j.pax.web.service.spi.util.Utils;
import org.ops4j.pax.web.service.tomcat.internal.OsgiContextConfiguration;
import org.ops4j.pax.web.service.tomcat.internal.PaxWebFilterDef;
import org.ops4j.pax.web.service.tomcat.internal.PaxWebFilterMap;
import org.ops4j.pax.web.service.tomcat.internal.PaxWebSessionIdGenerator;
import org.ops4j.pax.web.service.tomcat.internal.PaxWebSessionManager;
import org.ops4j.pax.web.service.tomcat.internal.PaxWebStandardContext;
import org.ops4j.pax.web.service.tomcat.internal.PaxWebStandardWrapper;
import org.ops4j.pax.web.service.tomcat.internal.TomcatFactory;
import org.ops4j.pax.web.service.tomcat.internal.web.TomcatResourceServlet;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

class TomcatServerWrapper
implements BatchVisitor {
    public static final Logger LOG = LoggerFactory.getLogger(TomcatServerWrapper.class);
    private static final String TOMCAT_CATALINA_NAME = "Catalina";
    private final Bundle paxWebTomcatBundle;
    private final ClassLoader classLoader;
    private boolean deferredConfiguration = true;
    private Server server;
    private StandardService service;
    private StandardEngine engine;
    private Host defaultHost;
    private final Map<String, Host> hosts = new HashMap<String, Host>();
    private Executor serverExecutor;
    private final TomcatFactory tomcatFactory;
    private final Set<String> transactions = new HashSet<String>();
    private final Map<String, List<ElementModel<?, ?>>> delayedRemovals = new HashMap();
    private final Map<String, PaxWebStandardContext> contextHandlers = new HashMap<String, PaxWebStandardContext>();
    private final Map<OsgiContextModel, OsgiServletContext> osgiServletContexts = new HashMap<OsgiContextModel, OsgiServletContext>();
    private final Map<OsgiContextModel, LifecycleListener> configurationListeners = new HashMap<OsgiContextModel, LifecycleListener>();
    private final Map<String, TreeSet<OsgiContextModel>> osgiContextModels = new HashMap<String, TreeSet<OsgiContextModel>>();
    private final Map<String, TreeSet<SCIWrapper>> initializers = new HashMap<String, TreeSet<SCIWrapper>>();
    private final Map<String, DynamicRegistrations> dynamicRegistrations = new HashMap<String, DynamicRegistrations>();
    private final Configuration configuration;
    private final Default404Servlet default404Servlet = new Default404Servlet();
    private SessionCookieConfig defaultSessionCookieConfig;
    private final List<EventListenerModel> sessionListenerModels = new ArrayList<EventListenerModel>();
    private final Map<String, TreeMap<OsgiContextModel, SecurityConfigurationModel>> contextSecurityConstraints = new HashMap<String, TreeMap<OsgiContextModel, SecurityConfigurationModel>>();

    TomcatServerWrapper(Configuration config, TomcatFactory tomcatFactory, Bundle paxWebTomcatBundle, ClassLoader classLoader) {
        this.configuration = config;
        this.tomcatFactory = tomcatFactory;
        this.paxWebTomcatBundle = paxWebTomcatBundle;
        this.classLoader = classLoader;
        String flag = paxWebTomcatBundle == null ? null : paxWebTomcatBundle.getBundleContext().getProperty("org.ops4j.pax.web.configuration.deferred");
        this.deferredConfiguration = flag == null || Boolean.parseBoolean(flag);
    }

    public void configure() throws Exception {
        LOG.info("Creating Tomcat server instance using configuration properties.");
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(TomcatServerWrapper.class.getClassLoader());
            this.applyTomcatConfiguration();
            this.verifyConnectorConfiguration();
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        if (this.configuration.logging().isLogNCSAFormatEnabled().booleanValue()) {
            this.configureRequestLog();
        }
        this.defaultSessionCookieConfig = this.configuration.session().getDefaultSessionCookieConfig();
    }

    private void createServer() {
        this.serverExecutor = this.tomcatFactory.createThreadPool(this.configuration);
        StandardServer server = new StandardServer();
        server.setUtilityThreads(2);
        StandardService service = new StandardService();
        service.setName(TOMCAT_CATALINA_NAME);
        service.addExecutor(this.serverExecutor);
        server.addService(service);
        StandardEngine engine = new StandardEngine();
        engine.setName(TOMCAT_CATALINA_NAME);
        engine.setDefaultHost("localhost");
        service.setContainer(engine);
        StandardHost host = new StandardHost();
        host.setName("localhost");
        host.setAppBase(".");
        host.setStartChildren(false);
        engine.addChild(host);
        this.server = server;
        this.service = service;
        this.engine = engine;
        this.defaultHost = host;
        LOG.info("Created {}", (Object)ToStringUtil.toString((Object)this, this.engine));
    }

    private void applyTomcatConfiguration() {
        File[] locations = this.configuration.server().getConfigurationFiles();
        URL tomcatResource = this.getClass().getResource("/tomcat-server.xml");
        if (locations.length == 0) {
            if (tomcatResource == null) {
                LOG.info("No external Tomcat configuration files specified. Default/PID configuration will be used.");
            } else {
                LOG.info("Found \"tomcat-server.xml\" resource on the classpath: {}.", (Object)tomcatResource);
            }
        } else if (locations.length > 1) {
            LOG.warn("Can't specify Tomcat configuration using more than one XML file. Only {} will be used.", (Object)locations[0]);
        } else {
            if (tomcatResource != null) {
                LOG.info("Found additional \"tomcat-server.xml\" resource on the classpath: {}, but {} will be used instead.", (Object)tomcatResource, (Object)locations[0]);
            }
            LOG.info("Processing Tomcat configuration from file: {}", (Object)locations[0]);
        }
        URL config = null;
        try {
            config = locations.length == 0 ? tomcatResource : locations[0].toURI().toURL();
        }
        catch (MalformedURLException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
        TomcatFactory.ServerHolder holder = new TomcatFactory.ServerHolder();
        if (config != null) {
            Digester digester = this.tomcatFactory.createServerDigester(this.configuration);
            digester.push((Object)holder);
            LOG.debug("Parsing {}", (Object)config);
            try (InputStream is = config.openStream();){
                digester.parse(is);
            }
            catch (IOException | SAXException e) {
                LOG.warn("Problem parsing {}: {}", new Object[]{config, e.getMessage(), e});
            }
        }
        if (holder.getServer() == null) {
            this.createServer();
        } else {
            this.server = holder.getServer();
            if (this.server.findServices().length == 0) {
                LOG.info("No Service configured in Tomcat XML configuration. Creating default \"Catalina\" Service.");
                this.service = new StandardService();
                this.server.addService(this.service);
            } else {
                this.service = (StandardService)this.server.findServices()[0];
                if (this.server.findServices().length > 1) {
                    LOG.warn("More than one Service configured in Tomcat XML configuration. Using \"{}\" and removing the other ones.", (Object)this.service.getName());
                    Service[] findServices = this.server.findServices();
                    for (int i = 1; i < findServices.length; ++i) {
                        this.server.removeService(findServices[i]);
                    }
                }
            }
            this.service.setName(TOMCAT_CATALINA_NAME);
            if (this.service.findExecutors().length == 0) {
                LOG.info("No Executor configured in Tomcat XML configuration. Creating default Executor from configuration.");
                this.serverExecutor = this.tomcatFactory.createThreadPool(this.configuration);
                this.service.addExecutor(this.serverExecutor);
            } else {
                this.serverExecutor = this.service.findExecutors()[0];
                if (this.service.findExecutors().length > 1) {
                    LOG.warn("More than one Executor configured in Tomcat XML configuration. Using \"{}\" as the default and keeping the other ones.", (Object)this.serverExecutor.getName());
                }
            }
            this.engine = (StandardEngine)this.service.getContainer();
            if (this.engine == null) {
                LOG.info("No Engine configured in Tomcat XML configuration. Creating default \"Catalina\" Engine.");
                this.engine = new StandardEngine();
                this.service.setContainer(this.engine);
            }
            this.engine.setName(TOMCAT_CATALINA_NAME);
            this.engine.setDefaultHost("localhost");
            if (this.engine.findChildren().length == 0 || this.engine.findChild("localhost") == null) {
                LOG.info("No \"localhost\" Host configured in Tomcat XML configuration. Creating one.");
                StandardHost host = new StandardHost();
                host.setName("localhost");
                host.setAppBase(".");
                this.engine.addChild(host);
            }
            for (Container child : this.engine.findChildren()) {
                ((ContainerBase)child).setStartChildren(false);
            }
            this.defaultHost = (Host)this.engine.findChild("localhost");
        }
    }

    private void verifyConnectorConfiguration() {
        String[] addresses;
        boolean httpEnabled = this.configuration.server().isHttpEnabled();
        Integer httpPort = this.configuration.server().getHttpPort();
        boolean httpsEnabled = this.configuration.server().isHttpSecureEnabled();
        Integer httpsPort = this.configuration.server().getHttpSecurePort();
        for (String address : addresses = this.configuration.server().getListeningAddresses()) {
            this.verifyConnector(address, httpPort, httpEnabled, false, () -> this.tomcatFactory.createDefaultConnector(this.server, address, this.serverExecutor, this.configuration));
            this.verifyConnector(address, httpsPort, httpsEnabled, true, () -> this.tomcatFactory.createSecureConnector(this.server, address, this.serverExecutor, this.configuration));
        }
    }

    private void verifyConnector(String address, Integer port, boolean enabled, boolean secure, Supplier<Connector> connectorProvider) {
        Connector expectedConnector = null;
        boolean connectorFound = false;
        Connector backupConnector = null;
        Service service = this.server.findService(TOMCAT_CATALINA_NAME);
        Connector[] currentConnectors = service.findConnectors();
        if (currentConnectors == null) {
            currentConnectors = new Connector[]{};
        }
        for (Connector connector : currentConnectors) {
            if (!"org.apache.coyote.http11.Http11Nio2Protocol".equals(connector.getProtocolHandlerClassName()) && !"org.apache.coyote.http11.Http11NioProtocol".equals(connector.getProtocolHandlerClassName()) && !"org.ops4j.pax.web.service.tomcat.internal.PaxWebHttp11Nio2Protocol".equals(connector.getProtocolHandlerClassName())) continue;
            if (this.match(address, port, connector)) {
                if (connector.getSecure() != secure) continue;
                expectedConnector = connector;
                connectorFound = true;
                continue;
            }
            backupConnector = connector;
        }
        if (expectedConnector == null && backupConnector != null) {
            expectedConnector = backupConnector;
        }
        if (connectorFound) {
            if (enabled) {
                LOG.info("Using configured {} as {} connector for address: {}:{}", new Object[]{expectedConnector, secure ? "secure" : "non secure", address, port});
                if (expectedConnector.getProperty("name") == null) {
                    if (secure) {
                        expectedConnector.setProperty("name", this.configuration.server().getHttpSecureConnectorName());
                    } else {
                        expectedConnector.setProperty("name", this.configuration.server().getHttpConnectorName());
                    }
                }
            } else {
                for (Connector connector : currentConnectors) {
                    if (connector.getSecure() != secure) continue;
                    LOG.warn("Connector defined in external configuration will be removed, because it's not enabled: {}", (Object)connector);
                    service.removeConnector(connector);
                }
            }
        } else if (enabled) {
            LOG.info("Creating {} connector for address {}:{}", new Object[]{secure ? "secure" : "non secure", address, port});
            Connector connector = connectorProvider.get();
            service.addConnector(connector);
        }
    }

    private boolean match(String address, Integer port, Connector connector) {
        InetAddress address2 = (InetAddress)connector.getProperty("address");
        int port2 = connector.getPort();
        InetSocketAddress isa1 = address != null ? new InetSocketAddress(address, (int)port) : new InetSocketAddress(port);
        InetSocketAddress isa2 = address2 != null ? new InetSocketAddress(address2, port2) : new InetSocketAddress(port2);
        return isa1.equals(isa2);
    }

    public void configureRequestLog() {
        Valve[] valves;
        LogConfiguration lc = this.configuration.logging();
        if (lc.getLogNCSADirectory() == null) {
            throw new IllegalArgumentException("Log directory for NCSA logging is not specified. Please set org.ops4j.pax.web.log.ncsa.directory property.");
        }
        File logDir = new File(lc.getLogNCSADirectory());
        if (logDir.isFile()) {
            throw new IllegalArgumentException(String.valueOf(logDir) + " is not a valid directory to store request logs");
        }
        AccessLogValve ncsaLogger = new AccessLogValve();
        ncsaLogger.setPattern(lc.isLogNCSAExtended() != false ? "combined" : "common");
        ncsaLogger.setDirectory(new File(lc.getLogNCSADirectory()).getAbsolutePath());
        ncsaLogger.setPrefix(lc.getLogNCSAFile());
        ncsaLogger.setFileDateFormat("." + lc.getLogNCSAFilenameDateFormat());
        ncsaLogger.setSuffix(".log");
        ncsaLogger.setBuffered(lc.getLogNCSABuffered());
        AccessLogAdapter adapter = null;
        for (Valve valve : valves = this.engine.getPipeline().getValves()) {
            if (!(valve instanceof AccessLog)) continue;
            if (adapter == null) {
                adapter = new AccessLogAdapter((AccessLog)((Object)valve));
            } else {
                adapter.add((AccessLog)((Object)valve));
            }
            this.engine.getPipeline().removeValve(valve);
        }
        if (adapter != null) {
            adapter.add(ncsaLogger);
        } else {
            this.engine.getPipeline().addValve(ncsaLogger);
        }
        LOG.info("NCSARequestlogging is using directory {}", (Object)lc.getLogNCSADirectory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        LOG.info("Starting {}", (Object)this.server);
        long t1 = System.currentTimeMillis();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            TomcatURLStreamHandlerFactory.disable();
            this.server.start();
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        long t2 = System.currentTimeMillis();
        LOG.info("Tomcat server started in " + (t2 - t1) + " ms");
    }

    public void stop() {
        try {
            LOG.info("Stopping {}", (Object)this.server);
            this.server.stop();
            LOG.info("Destroying Tomcat server {}", (Object)this.server);
            this.server.destroy();
            this.osgiServletContexts.values().forEach(OsgiServletContext::unregister);
        }
        catch (Throwable e) {
            LOG.error("Problem stopping Tomcat server {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public ServerEvent.Address[] getAddresses(boolean useLocalPort) {
        Service service = this.server.findService(TOMCAT_CATALINA_NAME);
        if (service == null) {
            return new ServerEvent.Address[0];
        }
        Connector[] currentConnectors = service.findConnectors();
        if (currentConnectors == null) {
            currentConnectors = new Connector[]{};
        }
        ArrayList<ServerEvent.Address> result = new ArrayList<ServerEvent.Address>(currentConnectors.length);
        for (Connector connector : currentConnectors) {
            int port;
            InetAddress address = (InetAddress)connector.getProperty("address");
            int n = port = useLocalPort ? connector.getLocalPort() : connector.getPort();
            if (address == null) {
                result.add(new ServerEvent.Address(new InetSocketAddress(port), connector.getSecure()));
                continue;
            }
            result.add(new ServerEvent.Address(new InetSocketAddress(address, port), connector.getSecure()));
        }
        return result.toArray(new ServerEvent.Address[0]);
    }

    public void visitTransactionStateChange(TransactionStateChange change) {
        String contextPath = change.getContextPath();
        if (change.getKind() == OpCode.ASSOCIATE) {
            if (!this.transactions.add(contextPath)) {
                throw new IllegalStateException("Context path " + contextPath + " is already associated with config transaction");
            }
            this.delayedRemovals.computeIfAbsent(contextPath, cp -> new ArrayList());
        } else if (change.getKind() == OpCode.DISASSOCIATE) {
            if (!this.transactions.remove(contextPath)) {
                throw new IllegalStateException("Context path " + contextPath + " is not associated with any config transaction");
            }
            List<ElementModel<?, ?>> toRemove = this.delayedRemovals.get(contextPath);
            if (toRemove != null && this.contextHandlers.containsKey(contextPath)) {
                Iterator<ElementModel<?, ?>> iterator = toRemove.iterator();
                while (iterator.hasNext()) {
                    ElementModel<?, ?> model = iterator.next();
                    if (model instanceof ServletModel) {
                        this.removeServletModel(contextPath, (ServletModel)model);
                    } else if (model instanceof EventListenerModel) {
                        this.removeEventListenerModel(this.contextHandlers.get(contextPath), (EventListenerModel)model, ((EventListenerModel)model).getResolvedListener());
                    }
                    iterator.remove();
                }
            }
            this.delayedRemovals.remove(contextPath);
            if (this.contextHandlers.containsKey(contextPath)) {
                PaxWebStandardContext context = this.contextHandlers.get(contextPath);
                if (this.server.getState() == LifecycleState.STARTED) {
                    this.ensureServletContextStarted(context);
                }
            }
        }
    }

    public void visitServletContextModelChange(ServletContextModelChange change) {
        ServletContextModel model = change.getServletContextModel();
        String contextPath = model.getContextPath();
        if (change.getKind() == OpCode.ADD) {
            if (this.contextHandlers.containsKey(contextPath)) {
                return;
            }
            LOG.info("Creating new Tomcat context for {}", (Object)model);
            PaxWebStandardContext context = new PaxWebStandardContext(this.default404Servlet, new OsgiSessionAttributeListener(this.sessionListenerModels));
            context.setWhiteboardTCCL("whiteboard".equalsIgnoreCase(this.configuration.server().getTCCLType()));
            context.setPath("/".equals(contextPath) ? "" : contextPath);
            context.setName(contextPath);
            context.createInitialOsgiFilter();
            context.setMapperContextRootRedirectEnabled(true);
            WebXml webXml = new WebXml();
            WebXmlParser webXmlParser = new WebXmlParser(true, false, true);
            try {
                URL internalXml = OsgiContextModel.class.getResource("/org/ops4j/pax/web/service/spi/model/default-web.xml");
                if (internalXml != null) {
                    webXmlParser.parseWebXml(internalXml, webXml, false);
                } else {
                    webXml.addMimeMapping("txt", "text/plain");
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            webXml.getMimeMappings().forEach(context::addMimeMapping);
            this.defaultHost.addChild(context);
            SessionConfiguration sc = this.configuration.session();
            context.setSessionTimeout(sc.getSessionTimeout());
            context.setSessionCookieName(this.defaultSessionCookieConfig.getName());
            context.setSessionCookieDomain(this.defaultSessionCookieConfig.getDomain());
            context.setSessionCookiePath(this.defaultSessionCookieConfig.getPath());
            context.setUseHttpOnly(this.defaultSessionCookieConfig.isHttpOnly());
            context.setSessionCookiePathUsesTrailingSlash(false);
            context.setValidateClientProvidedNewSessionId(true);
            Rfc6265CookieProcessor cookieProcessor = new Rfc6265CookieProcessor();
            String sameSiteValue = sc.getSessionCookieSameSite();
            if (sameSiteValue != null) {
                cookieProcessor.setSameSiteCookies(sameSiteValue);
            } else {
                cookieProcessor.setSameSiteCookies(SameSiteCookies.UNSET.getValue());
            }
            context.setCookieProcessor(cookieProcessor);
            PaxWebSessionManager manager = new PaxWebSessionManager();
            manager.setSessionIdGenerator(new PaxWebSessionIdGenerator());
            if (sc.getSessionStoreDirectory() != null) {
                manager.setPathname(new File(sc.getSessionStoreDirectory(), "SESSIONS.ser").getAbsolutePath());
            }
            context.setManager(manager);
            this.contextHandlers.put(contextPath, context);
            this.osgiContextModels.put(contextPath, new TreeSet());
            this.initializers.put(contextPath, new TreeSet());
            this.dynamicRegistrations.put(contextPath, new DynamicRegistrations());
        } else if (change.getKind() == OpCode.DELETE) {
            OsgiContextModel highestRankedModel = Utils.getHighestRankedModel((Set)this.osgiContextModels.get(contextPath));
            if (highestRankedModel != null) {
                return;
            }
            this.dynamicRegistrations.remove(contextPath);
            this.initializers.remove(contextPath);
            this.osgiContextModels.remove(contextPath);
            PaxWebStandardContext context = this.contextHandlers.remove(contextPath);
            if (context != null && context.isStarted()) {
                LOG.info("Stopping Tomcat context \"{}\"", (Object)contextPath);
                try {
                    context.stop();
                }
                catch (Exception e) {
                    LOG.warn("Error stopping Tomcat context \"{}\": {}", new Object[]{contextPath, e.getMessage(), e});
                }
            }
            this.defaultHost.removeChild(context);
        }
    }

    public void visitOsgiContextModelChange(OsgiContextModelChange change) {
        OsgiContextModel highestRankedModel;
        if (change.getKind() == OpCode.ASSOCIATE || change.getKind() == OpCode.DISASSOCIATE) {
            return;
        }
        OsgiContextModel osgiModel = change.getOsgiContextModel();
        ServletContextModel servletContextModel = change.getServletContextModel();
        String contextPath = osgiModel.getContextPath();
        PaxWebStandardContext realContext = this.contextHandlers.get(contextPath);
        if (realContext == null) {
            if (change.getKind() == OpCode.DELETE) {
                return;
            }
            this.visitServletContextModelChange(new ServletContextModelChange(OpCode.ADD, new ServletContextModel(contextPath)));
            realContext = this.contextHandlers.get(contextPath);
        }
        if (change.getKind() == OpCode.ADD) {
            LOG.info("Adding {} to {}", (Object)osgiModel, (Object)realContext);
            if (this.osgiServletContexts.containsKey(osgiModel)) {
                throw new IllegalStateException(String.valueOf(osgiModel) + " is already registered");
            }
            Object classLoader = null;
            if (osgiModel.getClassLoader() != null) {
                classLoader = osgiModel.getClassLoader();
            }
            if (this.paxWebTomcatBundle != null) {
                OsgiServletContextClassLoader loader = classLoader != null ? classLoader : new OsgiServletContextClassLoader();
                loader.addBundle(osgiModel.getOwnerBundle());
                loader.addBundle(this.paxWebTomcatBundle);
                loader.addBundle(Utils.getPaxWebJspBundle((Bundle)this.paxWebTomcatBundle));
                loader.addBundle(Utils.getTomcatWebSocketBundle((Bundle)this.paxWebTomcatBundle));
                loader.makeImmutable();
                classLoader = loader;
            } else if (classLoader == null) {
                classLoader = this.classLoader;
            }
            OsgiServletContext osgiContext = new OsgiServletContext(realContext.getServletContext(), osgiModel, servletContextModel, this.defaultSessionCookieConfig, (ClassLoader)classLoader);
            File tmpLocation = new File(this.configuration.server().getTemporaryDirectory(), osgiModel.getTemporaryLocation());
            if (!tmpLocation.exists() && !tmpLocation.mkdirs()) {
                LOG.warn("Can't create temporary directory for {}: {}", (Object)osgiModel, (Object)tmpLocation.getAbsolutePath());
            }
            osgiModel.getInitialContextAttributes().put("jakarta.servlet.context.tempdir", tmpLocation);
            osgiContext.setAttribute("jakarta.servlet.context.tempdir", (Object)tmpLocation);
            this.osgiServletContexts.put(osgiModel, osgiContext);
            this.osgiContextModels.get(contextPath).add(osgiModel);
            this.configurationListeners.put(osgiModel, new OsgiContextConfiguration(osgiModel, this.configuration, this.tomcatFactory, this.contextSecurityConstraints));
        }
        boolean hasStopped = false;
        if (change.getKind() == OpCode.DELETE) {
            OsgiServletContext currentHighestRankedContext;
            LOG.info("Removing {} from {}", (Object)osgiModel, (Object)realContext);
            OsgiServletContext removedOsgiServletContext = this.osgiServletContexts.remove(osgiModel);
            TreeSet<OsgiContextModel> models = this.osgiContextModels.get(contextPath);
            if (models != null) {
                models.remove(osgiModel);
            }
            if (removedOsgiServletContext != null) {
                removedOsgiServletContext.unregister();
                removedOsgiServletContext.releaseWebContainerContext();
            }
            if ((currentHighestRankedContext = realContext.getDefaultServletContext()) == removedOsgiServletContext || this.pendingTransaction(contextPath)) {
                if (realContext.isStarted()) {
                    LOG.info("Stopping Tomcat context \"{}\"", (Object)contextPath);
                    try {
                        if (realContext.isStarted()) {
                            realContext.stop();
                            hasStopped = true;
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("Error stopping Tomcat context \"{}\": {}", new Object[]{contextPath, e.getMessage(), e});
                    }
                }
                realContext.setDefaultOsgiContextModel(null, null);
                realContext.setDefaultServletContext(null);
            }
            this.configurationListeners.remove(osgiModel);
        }
        if ((highestRankedModel = Utils.getHighestRankedModel((Set)this.osgiContextModels.get(contextPath))) != null) {
            if (highestRankedModel != realContext.getDefaultOsgiContextModel()) {
                LOG.info("Changing default OSGi context model for " + String.valueOf(realContext));
                OsgiServletContext highestRankedContext = this.osgiServletContexts.get(highestRankedModel);
                realContext.setDefaultOsgiContextModel(highestRankedModel, highestRankedContext.getResolvedWebContainerContext());
                realContext.setDefaultServletContext(highestRankedContext);
                this.osgiServletContexts.forEach((ocm, osc) -> {
                    if (ocm.getContextPath().equals(contextPath) && osc != highestRankedContext) {
                        osc.unregister();
                    }
                });
                if (!hasStopped && realContext.isStarted()) {
                    LOG.info("Stopping Tomcat context \"{}\"", (Object)contextPath);
                    try {
                        if (realContext.isStarted()) {
                            realContext.stop();
                            hasStopped = true;
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("Error stopping Tomcat context \"{}\": {}", new Object[]{contextPath, e.getMessage(), e});
                    }
                }
            }
            if (hasStopped) {
                if (this.pendingTransaction(contextPath)) {
                    change.registerBatchCompletedAction((Change)new ContextStartChange(OpCode.MODIFY, new String[]{contextPath}));
                } else {
                    this.ensureServletContextStarted(realContext);
                }
            }
        } else {
            realContext.setDefaultOsgiContextModel(null, null);
            realContext.setDefaultServletContext(null);
            this.visitServletContextModelChange(new ServletContextModelChange(OpCode.DELETE, new ServletContextModel(contextPath)));
        }
    }

    public void visitContextMetadataModelChange(ContextMetadataModelChange change) {
        if (change.getKind() == OpCode.ADD) {
            OsgiContextModel ocm = change.getOsgiContextModel();
            ContextMetadataModel meta = change.getMetadata();
            String contextPath = ocm.getContextPath();
            PaxWebStandardContext context = this.contextHandlers.get(contextPath);
            if (context == null) {
                throw new IllegalStateException(String.valueOf(ocm) + " refers to unknown ServletContext for path " + contextPath);
            }
            OsgiContextModel highestRankedModel = Utils.getHighestRankedModel((Set)this.osgiContextModels.get(contextPath));
            if (ocm == highestRankedModel) {
                LOG.info("Configuring metadata of {}", (Object)ocm);
                context.setEffectiveMajorVersion(meta.getMajorVersion());
                context.setEffectiveMinorVersion(meta.getMinorVersion());
                context.setDisplayName(meta.getDisplayName());
                context.setDistributable(meta.getDistributable());
                context.setIgnoreAnnotations(meta.isMetadataComplete());
                context.setPublicId(meta.getPublicId());
                context.setRequestCharacterEncoding(meta.getRequestCharacterEncoding());
                context.setResponseCharacterEncoding(meta.getResponseCharacterEncoding());
                context.setDenyUncoveredHttpMethods(meta.isDenyUncoveredHttpMethods());
            }
        }
    }

    public void visitMimeAndLocaleMappingChange(MimeAndLocaleMappingChange change) {
        if (change.getKind() == OpCode.ADD) {
            OsgiContextModel ocm = change.getOsgiContextModel();
            String contextPath = ocm.getContextPath();
            PaxWebStandardContext context = this.contextHandlers.get(contextPath);
            if (context == null) {
                throw new IllegalStateException(String.valueOf(ocm) + " refers to unknown ServletContext for path " + contextPath);
            }
            OsgiContextModel highestRankedModel = Utils.getHighestRankedModel((Set)this.osgiContextModels.get(contextPath));
            if (ocm == highestRankedModel) {
                LOG.info("Configuring MIME and Locale Encoding mapping of {}", (Object)ocm);
                change.getMimeMapping().forEach(context::addMimeMapping);
                change.getLocaleEncodingMapping().forEach(context::addLocaleEncodingMappingParameter);
            }
        }
    }

    public void visitServletModelChange(ServletModelChange change) {
        HashSet done = new HashSet();
        if (change.getKind() == OpCode.ADD && !change.isDisabled() || change.getKind() == OpCode.ENABLE) {
            ServletModel model = change.getServletModel();
            if (change.getNewModelsInfo() == null) {
                LOG.info("Adding servlet {}", (Object)model);
            } else {
                LOG.info("Adding servlet {} to new contexts {}", (Object)model, (Object)change.getNewModelsInfo());
            }
            change.getContextModels().forEach(osgiContext -> {
                String contextPath = osgiContext.getContextPath();
                if (!done.add(contextPath)) {
                    return;
                }
                if (!this.deferredConfiguration && model.getLoadOnStartup() == null) {
                    model.setLoadOnStartup(Integer.valueOf(0));
                }
                LOG.debug("Adding servlet {} to {}", (Object)model.getName(), (Object)contextPath);
                PaxWebStandardContext realContext = this.contextHandlers.get(contextPath);
                OsgiServletContext context = this.osgiServletContexts.get(osgiContext);
                PaxWebStandardWrapper wrapper = new PaxWebStandardWrapper(model, (OsgiContextModel)osgiContext, context, realContext);
                wrapper.setWhiteboardTCCL("whiteboard".equalsIgnoreCase(this.configuration.server().getTCCLType()));
                boolean isDefaultResourceServlet = model.isResourceServlet();
                for (String pattern : model.getUrlPatterns()) {
                    isDefaultResourceServlet &= "/".equals(pattern);
                }
                if (model.isResourceServlet()) {
                    wrapper.addInitParameter("pathInfoOnly", Boolean.toString(!isDefaultResourceServlet));
                    OsgiContextModel highestRankedModel = Utils.getHighestRankedModel((Set)this.osgiContextModels.get(contextPath));
                    wrapper.setHighestRankedContext(this.osgiServletContexts.get(highestRankedModel));
                }
                model.getRoleLinks().forEach(wrapper::addSecurityReference);
                wrapper.setRunAs(model.getRunAs());
                realContext.addChild(wrapper);
                String name = model.getName();
                for (String pattern : model.getUrlPatterns()) {
                    realContext.addServletMappingDecoded(pattern, name, false);
                }
                ErrorPageModel epm = model.getErrorPageModel();
                if (epm != null && epm.isValid() && epm.getDtoFailureCode() == -1) {
                    ErrorPage errorPage;
                    String location = epm.getLocation();
                    for (String ex : epm.getExceptionClassNames()) {
                        errorPage = new ErrorPage();
                        errorPage.setExceptionType(ex);
                        errorPage.setLocation(location);
                        realContext.addErrorPage(errorPage);
                    }
                    Iterator pattern = epm.getErrorCodes().iterator();
                    while (pattern.hasNext()) {
                        int code = (Integer)pattern.next();
                        errorPage = new ErrorPage();
                        errorPage.setErrorCode(code);
                        errorPage.setLocation(location);
                        realContext.addErrorPage(errorPage);
                    }
                    if (epm.isXx4()) {
                        for (int c = 400; c < 500; ++c) {
                            ErrorPage errorPage2 = new ErrorPage();
                            errorPage2.setErrorCode(c);
                            errorPage2.setLocation(location);
                            realContext.addErrorPage(errorPage2);
                        }
                    }
                    if (epm.isXx5()) {
                        for (int c = 500; c < 600; ++c) {
                            ErrorPage errorPage3 = new ErrorPage();
                            errorPage3.setErrorCode(c);
                            errorPage3.setLocation(location);
                            realContext.addErrorPage(errorPage3);
                        }
                    }
                }
                if (!change.isDynamic()) {
                    boolean alreadyStarted = this.ensureServletContextStarted(realContext);
                    if (alreadyStarted && model.getLoadOnStartup() != null && model.getLoadOnStartup() >= 0) {
                        try {
                            wrapper.load();
                        }
                        catch (ServletException | IllegalStateException e) {
                            LOG.warn("Exception loading {} added to already started context: {}", (Object)model, (Object)e.getMessage());
                        }
                    }
                } else if (model.isServletSecurityPresent()) {
                    ArrayList dynamicModels = new ArrayList();
                    model.getContextModels().forEach(ocm -> {
                        for (SecurityConstraintModel sc : ocm.getSecurityConfiguration().getSecurityConstraints()) {
                            if (sc.getServletModel() != model) continue;
                            dynamicModels.add(sc);
                        }
                    });
                    HashSet<String> potentiallyNewRoles = new HashSet<String>();
                    for (SecurityConstraintModel scm : dynamicModels) {
                        SecurityConstraint constraint = new SecurityConstraint();
                        constraint.setDisplayName(scm.getName());
                        constraint.setUserConstraint(scm.getTransportGuarantee().name());
                        constraint.setAuthConstraint(scm.isAuthRolesSet());
                        for (String role : scm.getAuthRoles()) {
                            constraint.addAuthRole(role);
                            potentiallyNewRoles.add(role);
                        }
                        for (SecurityConstraintModel.WebResourceCollection col : scm.getWebResourceCollections()) {
                            SecurityCollection wrc = new SecurityCollection();
                            wrc.setName(col.getName());
                            boolean methodSet = false;
                            for (String method : col.getMethods()) {
                                wrc.addMethod(method);
                                methodSet = true;
                            }
                            if (!methodSet) {
                                for (String method : col.getOmittedMethods()) {
                                    wrc.addOmittedMethod(method);
                                }
                            }
                            for (String pattern : col.getPatterns()) {
                                wrc.addPattern(pattern);
                            }
                            constraint.addCollection(wrc);
                        }
                        realContext.addConstraint(constraint);
                    }
                    HashSet<String> currentRoles = new HashSet<String>(Arrays.asList(realContext.findSecurityRoles()));
                    for (String role : potentiallyNewRoles) {
                        if (currentRoles.contains(role)) continue;
                        realContext.addSecurityRole(role);
                    }
                }
            });
            return;
        }
        if (change.getKind() == OpCode.DISABLE || change.getKind() == OpCode.DELETE) {
            for (Map.Entry entry : change.getServletModels().entrySet()) {
                ServletModel model = (ServletModel)entry.getKey();
                if (!((Boolean)entry.getValue()).booleanValue()) continue;
                model.getContextModels().forEach(osgiContextModel -> {
                    String contextPath = osgiContextModel.getContextPath();
                    if (!done.add(contextPath)) {
                        return;
                    }
                    if (this.pendingTransaction(contextPath)) {
                        LOG.debug("Delaying removal of servlet {}", (Object)model);
                        this.delayedRemovals.get(contextPath).add((ElementModel<?, ?>)model);
                        return;
                    }
                    this.removeServletModel(contextPath, model);
                });
            }
        }
    }

    private void removeServletModel(String contextPath, ServletModel model) {
        ErrorPageModel epm;
        LOG.info("Removing servlet {} from context {}", (Object)model, (Object)contextPath);
        Context realContext = this.contextHandlers.get(contextPath);
        Container child = realContext.findChild(model.getName());
        if (child != null) {
            for (String pattern : model.getUrlPatterns()) {
                realContext.removeServletMapping(pattern);
            }
            realContext.removeChild(child);
        }
        if ((epm = model.getErrorPageModel()) != null) {
            for (ErrorPage ep : realContext.findErrorPages()) {
                if (ep.getExceptionType() != null && epm.getExceptionClassNames().contains(ep.getExceptionType())) {
                    realContext.removeErrorPage(ep);
                }
                if (ep.getErrorCode() <= 0 || !epm.getErrorCodes().contains(ep.getErrorCode()) && (!epm.isXx4() || ep.getErrorCode() < 400 || ep.getErrorCode() >= 500) && (!epm.isXx5() || ep.getErrorCode() < 500 || ep.getErrorCode() >= 600)) continue;
                realContext.removeErrorPage(ep);
            }
        }
    }

    public void visitFilterModelChange(FilterModelChange change) {
        FilterModel model = change.getFilterModel();
        HashSet<String> done = new HashSet<String>();
        if (change.getKind() == OpCode.ADD && model.isDynamic()) {
            for (OsgiContextModel ocm : change.getContextModels()) {
                String contextPath = ocm.getContextPath();
                if (!done.add(contextPath)) continue;
                LOG.info("Adding dynamic filter {} to context {}", (Object)model, (Object)contextPath);
                OsgiContextModel highestRankedModel = null;
                for (OsgiContextModel cm : model.getContextModels()) {
                    if (!cm.getContextPath().equals(contextPath)) continue;
                    highestRankedModel = cm;
                    break;
                }
                if (highestRankedModel == null) {
                    highestRankedModel = ocm;
                }
                PaxWebStandardContext context = this.contextHandlers.get(contextPath);
                OsgiServletContext osgiContext = this.osgiServletContexts.get(highestRankedModel);
                PaxWebFilterDef filterDef = new PaxWebFilterDef(model, false, osgiContext);
                filterDef.setWhiteboardTCCL("whiteboard".equalsIgnoreCase(this.configuration.server().getTCCLType()));
                context.addFilterDef(filterDef);
                this.configureFilterMappings(model, context);
            }
        }
    }

    public void visitFilterStateChange(FilterStateChange change) {
        if (change.isDynamic()) {
            return;
        }
        Map contextFilters = change.getContextFilters();
        for (Map.Entry entry : contextFilters.entrySet()) {
            String contextPath = (String)entry.getKey();
            Map filtersMap = (Map)entry.getValue();
            TreeSet filters = new TreeSet(filtersMap.keySet());
            LOG.info("Changing filter configuration for context {}", (Object)contextPath);
            OsgiContextModel defaultHighestRankedModel = this.osgiContextModels.containsKey(contextPath) ? this.osgiContextModels.get(contextPath).iterator().next() : null;
            PaxWebStandardContext context = this.contextHandlers.get(contextPath);
            if (context == null) continue;
            this.ensureServletContextStarted(context);
            FilterDef[] filterDefs = context.findFilterDefs();
            FilterMap[] filterMaps = context.findFilterMaps();
            context.filterStop();
            for (FilterDef filterDef : filterDefs) {
                if (filterDef instanceof PaxWebFilterDef && (((PaxWebFilterDef)filterDef).isInitial() || ((PaxWebFilterDef)filterDef).getFilterModel() != null && ((PaxWebFilterDef)filterDef).getFilterModel().isDynamic())) continue;
                context.removeFilterDef(filterDef);
            }
            for (FilterDef filterDef : filterMaps) {
                if (filterDef instanceof PaxWebFilterMap && (((PaxWebFilterMap)filterDef).isInitial() || ((PaxWebFilterMap)filterDef).getFilterModel() != null && ((PaxWebFilterMap)filterDef).getFilterModel().isDynamic())) continue;
                context.removeFilterMap((FilterMap)filterDef);
            }
            context.getPreprocessors().clear();
            Iterator iterator = filters.iterator();
            while (iterator.hasNext()) {
                FilterModel model = (FilterModel)iterator.next();
                if (!model.isPreprocessor()) continue;
                context.getPreprocessors().add(new PreprocessorFilterConfig(model, this.osgiServletContexts.get(defaultHighestRankedModel)));
                iterator.remove();
            }
            TreeMap<Integer, Object[]> webOrderMapping = new TreeMap<Integer, Object[]>();
            for (FilterModel model : filters) {
                List list = filtersMap.get(model) != null ? (List)filtersMap.get(model) : model.getContextModels();
                OsgiServletContext osgiContext = this.getHighestRankedContext(contextPath, model, list);
                PaxWebFilterDef filterDef = new PaxWebFilterDef(model, false, osgiContext);
                filterDef.setWhiteboardTCCL("whiteboard".equalsIgnoreCase(this.configuration.server().getTCCLType()));
                context.addFilterDef(filterDef);
                if (!change.useWebOrder()) {
                    this.configureFilterMappings(model, context);
                    continue;
                }
                for (FilterModel.Mapping map : model.getMappingsPerDispatcherTypes()) {
                    webOrderMapping.put(map.getOrder(), new Object[]{model, map});
                }
            }
            if (change.useWebOrder()) {
                webOrderMapping.values().forEach(pair -> {
                    FilterModel model = (FilterModel)pair[0];
                    FilterModel.Mapping map = (FilterModel.Mapping)pair[1];
                    context.addFilterMap(new PaxWebFilterMap(model, map));
                });
            }
            if (!context.isStarted() || this.pendingTransaction(contextPath)) continue;
            context.filterStart();
        }
    }

    public void visitEventListenerModelChange(EventListenerModelChange change) {
        HashSet done = new HashSet();
        if (change.getKind() == OpCode.ADD) {
            EventListenerModel eventListenerModel = change.getEventListenerModel();
            List contextModels = change.getContextModels();
            ArrayList contextsToRestart = new ArrayList();
            contextModels.forEach(context -> {
                String contextPath = context.getContextPath();
                if (!done.add(contextPath)) {
                    return;
                }
                PaxWebStandardContext standardContext = this.contextHandlers.get(contextPath);
                EventListener eventListener = eventListenerModel.resolveEventListener();
                if (eventListener instanceof ServletContextAttributeListener) {
                    OsgiServletContext c = this.osgiServletContexts.get(context);
                    c.addServletContextAttributeListener((ServletContextAttributeListener)eventListener);
                }
                if (eventListener instanceof HttpSessionAttributeListener) {
                    this.sessionListenerModels.add(eventListenerModel);
                }
                boolean stopped = false;
                if (standardContext.isStarted() && standardContext.getState() != LifecycleState.STARTING_PREP && (ServletContextListener.class.isAssignableFrom(eventListener.getClass()) || HttpSessionListener.class.isAssignableFrom(eventListener.getClass()))) {
                    LOG.info("Stopping Tomcat context \"{}\" before registering a ServletContextListener", (Object)contextPath);
                    try {
                        standardContext.stop();
                        stopped = true;
                    }
                    catch (Exception e) {
                        LOG.warn("Problem stopping {}: {}", (Object)standardContext, (Object)e.getMessage());
                    }
                }
                if (eventListener instanceof HttpSessionListener || eventListener instanceof ServletContextListener) {
                    if (eventListener instanceof ServletContextListener) {
                        eventListener = OsgiScopedListener.proxyListener((OsgiServletContext)standardContext.getDefaultServletContext(), standardContext::getOsgiServletContext, (EventListener)eventListener, (EventListenerModel)eventListenerModel);
                    }
                    standardContext.addApplicationLifecycleListener(eventListenerModel, eventListener);
                } else {
                    standardContext.addApplicationEventListener(eventListenerModel, eventListener);
                }
                if (stopped || !this.deferredConfiguration) {
                    if (stopped) {
                        LOG.info("Scheduling start of the {} context after listener registration for already started context", (Object)contextPath);
                    } else {
                        LOG.info("Scheduling start of the {} context after listener registration for immediately started context", (Object)contextPath);
                    }
                    contextsToRestart.add(contextPath);
                }
            });
            if (!contextsToRestart.isEmpty()) {
                ContextStartChange action = new ContextStartChange(OpCode.MODIFY, contextsToRestart.toArray(new String[0]));
                action.setAsync(change.getEventListenerModel().isAsynchronusRegistration());
                change.registerBatchCompletedAction((Change)action);
            }
        }
        if (change.getKind() == OpCode.DELETE) {
            List eventListenerModels = change.getEventListenerModels();
            for (EventListenerModel eventListenerModel : eventListenerModels) {
                List contextModels = eventListenerModel.getContextModels();
                contextModels.forEach(context -> {
                    OsgiServletContext c;
                    String contextPath = context.getContextPath();
                    if (!done.add(contextPath)) {
                        return;
                    }
                    PaxWebStandardContext standardContext = this.contextHandlers.get(contextPath);
                    EventListener eventListener = eventListenerModel.resolveEventListener();
                    if (eventListener instanceof ServletContextAttributeListener && (c = this.osgiServletContexts.get(context)) != null) {
                        c.removeServletContextAttributeListener((ServletContextAttributeListener)eventListener);
                    }
                    if (eventListener instanceof HttpSessionAttributeListener) {
                        this.sessionListenerModels.remove(eventListenerModel);
                    }
                    if (this.pendingTransaction(contextPath)) {
                        LOG.debug("Delaying removal of event listener {}", (Object)eventListenerModel);
                        this.delayedRemovals.get(contextPath).add((ElementModel<?, ?>)eventListenerModel);
                        return;
                    }
                    this.removeEventListenerModel(standardContext, eventListenerModel, eventListener);
                    if (eventListener instanceof ServletContextListener) {
                        try {
                            ((ServletContextListener)eventListener).contextDestroyed(new ServletContextEvent(standardContext.getServletContext()));
                        }
                        catch (Exception e) {
                            LOG.warn("Exception calling contextDestroyed on removed ServletContextListener: {}", (Object)e.getMessage(), (Object)e);
                        }
                    }
                });
            }
        }
    }

    private void removeEventListenerModel(PaxWebStandardContext standardContext, EventListenerModel eventListenerModel, EventListener eventListener) {
        if (standardContext != null) {
            InvocationHandler ih;
            Object l;
            Object[] evListeners = standardContext.getApplicationEventListeners();
            Object[] lcListeners = standardContext.getApplicationLifecycleListeners();
            ArrayList<Object> newEvListeners = new ArrayList<Object>();
            ArrayList<Object> newLcListeners = new ArrayList<Object>();
            for (Object el : evListeners) {
                l = el;
                if (l instanceof OsgiScopedListener) {
                    l = ((OsgiScopedListener)l).getDelegate();
                } else if (Proxy.isProxyClass(l.getClass()) && (ih = Proxy.getInvocationHandler(l)) instanceof OsgiScopedListener.Handler) {
                    l = ((OsgiScopedListener.Handler)ih).getDelegate();
                }
                if (l == eventListener) continue;
                newEvListeners.add(l);
            }
            for (Object el : lcListeners) {
                l = el;
                if (l instanceof OsgiScopedListener) {
                    l = ((OsgiScopedListener)l).getDelegate();
                } else if (Proxy.isProxyClass(l.getClass()) && (ih = Proxy.getInvocationHandler(l)) instanceof OsgiScopedListener.Handler) {
                    l = ((OsgiScopedListener.Handler)ih).getDelegate();
                }
                if (l == eventListener) continue;
                newLcListeners.add(l);
            }
            if (eventListener != null) {
                standardContext.removeListener(eventListenerModel, eventListener);
            }
            standardContext.setApplicationEventListeners(newEvListeners.toArray(new Object[0]));
            standardContext.setApplicationLifecycleListeners(newLcListeners.toArray(new Object[0]));
        }
        eventListenerModel.releaseEventListener();
    }

    public void visitWelcomeFileModelChange(WelcomeFileModelChange change) {
        WelcomeFileModel model = change.getWelcomeFileModel();
        OpCode op = change.getKind();
        if (op == OpCode.ADD || op == OpCode.DELETE) {
            List contextModels = op == OpCode.ADD ? change.getContextModels() : model.getContextModels();
            contextModels.forEach(context -> {
                LinkedHashSet<String> currentWelcomeFiles;
                OsgiServletContext osgiServletContext = this.osgiServletContexts.get(context);
                PaxWebStandardContext realContext = this.contextHandlers.get(context.getContextPath());
                if (osgiServletContext == null || realContext == null) {
                    return;
                }
                LinkedHashSet<String> linkedHashSet = currentWelcomeFiles = osgiServletContext.getWelcomeFiles() == null ? new LinkedHashSet<String>() : new LinkedHashSet<String>(Arrays.asList(osgiServletContext.getWelcomeFiles()));
                if (op == OpCode.ADD) {
                    currentWelcomeFiles.addAll(Arrays.asList(model.getWelcomeFiles()));
                } else if (model.getWelcomeFiles().length == 0) {
                    currentWelcomeFiles.clear();
                } else {
                    for (String s : model.getWelcomeFiles()) {
                        currentWelcomeFiles.remove(s);
                    }
                }
                String[] newWelcomeFiles = currentWelcomeFiles.toArray(new String[0]);
                osgiServletContext.setWelcomeFiles(newWelcomeFiles);
                osgiServletContext.setWelcomeFilesRedirect(model.isRedirect());
                LOG.info("Reconfiguration of welcome files for all resource servlets in context \"{}\"", context);
                for (Container child : realContext.findChildren()) {
                    ServletModel servletModel;
                    if (!(child instanceof PaxWebStandardWrapper) || (servletModel = ((PaxWebStandardWrapper)child).getServletModel()) == null || !servletModel.isResourceServlet() || context != ((PaxWebStandardWrapper)child).getOsgiContextModel()) continue;
                    Servlet servlet = ((PaxWebStandardWrapper)child).getServlet();
                    if (servlet instanceof TomcatResourceServlet) {
                        ((TomcatResourceServlet)servlet).setWelcomeFiles(newWelcomeFiles);
                        ((TomcatResourceServlet)servlet).setWelcomeFilesRedirect(model.isRedirect());
                        continue;
                    }
                    if (!(servlet instanceof OsgiInitializedServlet)) continue;
                    ((TomcatResourceServlet)((OsgiInitializedServlet)servlet).getDelegate()).setWelcomeFiles(newWelcomeFiles);
                    ((TomcatResourceServlet)((OsgiInitializedServlet)servlet).getDelegate()).setWelcomeFilesRedirect(model.isRedirect());
                }
            });
        }
    }

    public void visitErrorPageModelChange(ErrorPageModelChange change) {
    }

    public void visitErrorPageStateChange(ErrorPageStateChange change) {
        Map contextErrorPages = change.getContextErrorPages();
        for (Map.Entry entry : contextErrorPages.entrySet()) {
            String contextPath = (String)entry.getKey();
            TreeMap errorPageModelsMap = (TreeMap)entry.getValue();
            Set errorPageModels = errorPageModelsMap.keySet();
            LOG.info("Changing error page configuration for context {}", (Object)contextPath);
            PaxWebStandardContext context = this.contextHandlers.get(contextPath);
            if (context == null) {
                return;
            }
            for (ErrorPage ep : context.findErrorPages()) {
                context.removeErrorPage(ep);
            }
            for (ErrorPageModel model : errorPageModels) {
                ErrorPage errorPage;
                String location = model.getLocation();
                for (String ex : model.getExceptionClassNames()) {
                    errorPage = new ErrorPage();
                    errorPage.setExceptionType(ex);
                    errorPage.setLocation(location);
                    context.addErrorPage(errorPage);
                }
                Iterator ep = model.getErrorCodes().iterator();
                while (ep.hasNext()) {
                    int code = (Integer)ep.next();
                    errorPage = new ErrorPage();
                    errorPage.setErrorCode(code);
                    errorPage.setLocation(location);
                    context.addErrorPage(errorPage);
                }
                if (model.isXx4()) {
                    for (int c = 400; c < 500; ++c) {
                        ErrorPage errorPage2 = new ErrorPage();
                        errorPage2.setErrorCode(c);
                        errorPage2.setLocation(location);
                        context.addErrorPage(errorPage2);
                    }
                }
                if (!model.isXx5()) continue;
                for (int c = 500; c < 600; ++c) {
                    ErrorPage errorPage3 = new ErrorPage();
                    errorPage3.setErrorCode(c);
                    errorPage3.setLocation(location);
                    context.addErrorPage(errorPage3);
                }
            }
        }
    }

    public void visitContainerInitializerModelChange(ContainerInitializerModelChange change) {
        if (change.getKind() == OpCode.ADD) {
            ContainerInitializerModel model = change.getContainerInitializerModel();
            if (!model.isForAnyRuntime() && !model.isForTomcat()) {
                return;
            }
            List contextModels = change.getContextModels();
            contextModels.forEach(context -> {
                String path = context.getContextPath();
                PaxWebStandardContext ctx = this.contextHandlers.get(context.getContextPath());
                if (ctx != null && ctx.isStarted()) {
                    LOG.info("Stopping Tomcat context \"{}\" before registering a ServletContextInitializer", (Object)path);
                    try {
                        ctx.stop();
                    }
                    catch (Exception e) {
                        LOG.warn("Error stopping Tomcat context \"{}\": {}", new Object[]{path, e.getMessage(), e});
                    }
                }
                DynamicRegistrations registrations = this.dynamicRegistrations.get(path);
                OsgiDynamicServletContext dynamicContext = new OsgiDynamicServletContext(this.osgiServletContexts.get(context), registrations);
                SCIWrapper wrapper = new SCIWrapper(dynamicContext, model);
                this.initializers.get(path).add(wrapper);
            });
        }
        if (change.getKind() == OpCode.DELETE) {
            List models = change.getContainerInitializerModels();
            for (ContainerInitializerModel model : models) {
                if (!model.isForAnyRuntime() && !model.isForTomcat()) continue;
                List contextModels = model.getContextModels();
                contextModels.forEach(context -> {
                    String path = context.getContextPath();
                    TreeSet<SCIWrapper> wrappers = this.initializers.get(path);
                    if (wrappers != null) {
                        wrappers.removeIf(w -> w.getModel() == model);
                    }
                });
            }
        }
    }

    public void visitWebSocketModelChange(WebSocketModelChange change) {
        if (change.getKind() == OpCode.ADD && !change.isDisabled() || change.getKind() == OpCode.ENABLE) {
            WebSocketModel model = change.getWebSocketModel();
            HashSet done = new HashSet();
            change.getContextModels().forEach(osgiContextModel -> {
                String contextPath = osgiContextModel.getContextPath();
                if (!done.add(contextPath)) {
                    return;
                }
                LOG.info("Adding web socket {} to {}", (Object)model, (Object)contextPath);
                this.ensureServletContextStarted(this.contextHandlers.get(contextPath));
            });
            return;
        }
        if (change.getKind() == OpCode.DISABLE || change.getKind() == OpCode.DELETE) {
            for (Map.Entry entry : change.getWebSocketModels().entrySet()) {
                WebSocketModel model = (WebSocketModel)entry.getKey();
                if (!((Boolean)entry.getValue()).booleanValue()) continue;
                HashSet done = new HashSet();
                model.getContextModels().forEach(osgiContextModel -> {
                    String contextPath = osgiContextModel.getContextPath();
                    if (!done.add(contextPath)) {
                        return;
                    }
                    LOG.info("Removing web socket {} from context {}", (Object)model, (Object)contextPath);
                    this.ensureServletContextStarted(this.contextHandlers.get(contextPath));
                });
            }
        }
    }

    public void visitClearDynamicRegistrationsChange(ClearDynamicRegistrationsChange change) {
        HashSet done = new HashSet();
        change.getContextModels().forEach(context -> {
            String contextPath = context.getContextPath();
            if (!done.add(contextPath)) {
                return;
            }
            this.clearDynamicRegistrations(contextPath, (OsgiContextModel)context);
        });
    }

    private void clearDynamicRegistrations(String contextPath, OsgiContextModel context) {
        PaxWebStandardContext ctx = this.contextHandlers.get(contextPath);
        if (ctx == null) {
            return;
        }
        if (ctx.isStarted()) {
            LOG.info("Stopping Tomcat context \"{}\"", (Object)contextPath);
            try {
                ctx.stop();
            }
            catch (Exception e) {
                LOG.warn("Error stopping Tomcat context \"{}\": {}", new Object[]{contextPath, e.getMessage(), e});
            }
        }
        int[] removed = new int[]{0};
        HashMap<ServletModel, Boolean> toRemove = new HashMap<ServletModel, Boolean>();
        for (Container child : ctx.findChildren()) {
            ServletModel model2;
            if (!(child instanceof PaxWebStandardWrapper) || (model2 = ((PaxWebStandardWrapper)child).getServletModel()) == null || !model2.isDynamic()) continue;
            toRemove.put(model2, Boolean.TRUE);
            removed[0] = removed[0] + 1;
        }
        if (!toRemove.isEmpty()) {
            this.visitServletModelChange(new ServletModelChange(OpCode.DELETE, toRemove));
        }
        FilterDef[] filterDefs = ctx.findFilterDefs();
        FilterMap[] filterMaps = ctx.findFilterMaps();
        for (FilterDef filterDef : filterDefs) {
            if (filterDef instanceof PaxWebFilterDef && (((PaxWebFilterDef)filterDef).isInitial() || ((PaxWebFilterDef)filterDef).getFilterModel() != null && !((PaxWebFilterDef)filterDef).getFilterModel().isDynamic())) continue;
            ctx.removeFilterDef(filterDef);
            removed[0] = removed[0] + 1;
        }
        for (FilterDef filterDef : filterMaps) {
            if (filterDef instanceof PaxWebFilterMap && (((PaxWebFilterMap)filterDef).isInitial() || ((PaxWebFilterMap)filterDef).getFilterModel() != null && !((PaxWebFilterMap)filterDef).getFilterModel().isDynamic())) continue;
            ctx.removeFilterMap((FilterMap)filterDef);
        }
        DynamicRegistrations contextRegistrations = this.dynamicRegistrations.get(contextPath);
        if (contextRegistrations != null) {
            contextRegistrations.getDynamicListenerModels().forEach((listenerToRemove, model) -> {
                if (model.isDynamic()) {
                    OsgiServletContext c;
                    removed[0] = removed[0] + 1;
                    if (listenerToRemove instanceof ServletContextAttributeListener && (c = this.osgiServletContexts.get(context)) != null) {
                        c.removeServletContextAttributeListener((ServletContextAttributeListener)listenerToRemove);
                    }
                    Object[] elisteners = ctx.getApplicationEventListeners();
                    Object[] llisteners = ctx.getApplicationLifecycleListeners();
                    ArrayList<Object> newEListeners = new ArrayList<Object>();
                    ArrayList<Object> newLListeners = new ArrayList<Object>();
                    for (Object existing : elisteners) {
                        if (existing == listenerToRemove) continue;
                        newEListeners.add(existing);
                    }
                    for (Object existing : llisteners) {
                        if (existing == listenerToRemove) continue;
                        newLListeners.add(existing);
                    }
                    ctx.removeListener((EventListenerModel)model, listenerToRemove);
                    ctx.setApplicationEventListeners(newEListeners.toArray(new Object[0]));
                    ctx.setApplicationLifecycleListeners(newLListeners.toArray(new Object[0]));
                }
            });
            contextRegistrations.getDynamicListenerModels().clear();
            contextRegistrations.getDynamicServletRegistrations().clear();
            contextRegistrations.getDynamicFilterRegistrations().clear();
            contextRegistrations.getDynamicListenerRegistrations().clear();
        }
        if (removed[0] > 0) {
            LOG.debug("Removed {} dynamically registered servlets/filters/listeners from context {}", (Object)removed[0], (Object)contextPath);
        }
    }

    public void visitContextStartChange(ContextStartChange change) {
        String[] contextPaths;
        for (String contextPath : contextPaths = change.getContextPaths()) {
            PaxWebStandardContext standardContext = this.contextHandlers.get(contextPath);
            if (standardContext != null) {
                this.ensureServletContextStarted(standardContext);
                continue;
            }
            LOG.debug("Not starting unknown context {}.", (Object)contextPath);
        }
    }

    public void visitContextStopChange(ContextStopChange change) {
        String contextPath = change.getContextPath();
        PaxWebStandardContext standardContext = this.contextHandlers.get(contextPath);
        if (standardContext != null && standardContext.isStarted()) {
            LOG.info("Stopping Tomcat context \"{}\"", (Object)contextPath);
            try {
                standardContext.stop();
            }
            catch (Exception e) {
                LOG.warn("Error stopping Tomcat context \"{}\": {}", new Object[]{contextPath, e.getMessage(), e});
            }
        }
    }

    public void visitContextParamsChange(ContextParamsChange change) {
        if (change.getKind() == OpCode.ADD) {
            LOG.info("Adding init parameters to {}: {}", (Object)change.getOsgiContextModel(), (Object)change.getParams());
            change.getOsgiContextModel().getContextParams().putAll(change.getParams());
        } else {
            LOG.info("Removing init parameters from {}: {}", (Object)change.getOsgiContextModel(), (Object)change.getParams());
            change.getParams().keySet().forEach(param -> change.getOsgiContextModel().getContextParams().remove(param));
        }
    }

    public void visitSecurityConfigChange(SecurityConfigChange change) {
        LoginConfigModel loginConfigModel = change.getLoginConfigModel();
        List securityRoles = change.getSecurityRoles();
        List securityConstraints = change.getSecurityConstraints();
        OsgiContextModel ocm = change.getOsgiContextModel();
        if (change.getKind() == OpCode.ADD) {
            LOG.info("Adding security configuration to {}", (Object)ocm);
            if (loginConfigModel != null) {
                ocm.getSecurityConfiguration().setLoginConfig(loginConfigModel);
            }
            ocm.getSecurityConfiguration().getSecurityRoles().addAll(securityRoles);
            ocm.getSecurityConfiguration().getSecurityConstraints().addAll(securityConstraints);
            this.contextSecurityConstraints.computeIfAbsent(ocm.getContextPath(), c -> new TreeMap()).put(ocm, ocm.getSecurityConfiguration());
        } else {
            LOG.info("Removing security configuration from {}", (Object)ocm);
            if (!ocm.hasDirectHttpContextInstance() || loginConfigModel != null) {
                ocm.getSecurityConfiguration().setLoginConfig(null);
            }
            if (ocm.hasDirectHttpContextInstance() && loginConfigModel == null) {
                ocm.getSecurityConfiguration().getSecurityRoles().clear();
                ocm.getSecurityConfiguration().getSecurityConstraints().clear();
            } else {
                securityRoles.forEach(ocm.getSecurityConfiguration().getSecurityRoles()::remove);
                securityConstraints.forEach(sc -> ocm.getSecurityConfiguration().getSecurityConstraints().removeIf(scm -> scm.getName().equals(sc.getName())));
                TreeMap<OsgiContextModel, SecurityConfigurationModel> constraints = this.contextSecurityConstraints.get(ocm.getContextPath());
                constraints.remove(ocm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureServletContextStarted(PaxWebStandardContext context) {
        String contextPath;
        String string = contextPath = context == null || context.getPath().equals("") ? "/" : context.getPath();
        if (context == null || context.isStarted() || context.getState() == LifecycleState.DESTROYED || this.pendingTransaction(contextPath)) {
            return context != null && context.isStarted();
        }
        try {
            OsgiContextModel highestRanked = context.getDefaultOsgiContextModel();
            OsgiServletContext highestRankedContext = context.getDefaultServletContext();
            highestRankedContext.allowServletContextListeners();
            LOG.info("Starting Tomcat context \"{}\" with default Osgi Context {}", (Object)context, (Object)highestRanked);
            WebappLoader tomcatLoader = new WebappLoader();
            ParallelWebappClassLoader loaderInstance = new ParallelWebappClassLoader(highestRankedContext.getClassLoader());
            loaderInstance.setClearReferencesRmiTargets(false);
            loaderInstance.setClearReferencesThreadLocals(false);
            tomcatLoader.setLoaderInstance(loaderInstance);
            context.setParentClassLoader(highestRankedContext.getClassLoader());
            context.setLoader(tomcatLoader);
            File workDir = (File)highestRankedContext.getAttribute("jakarta.servlet.context.tempdir");
            if (workDir == null) {
                workDir = this.configuration.server().getTemporaryDirectory();
            }
            context.setWorkDir(workDir.getAbsolutePath());
            for (String p : context.findParameters()) {
                context.removeParameter(p);
            }
            this.osgiContextModels.get(contextPath).forEach(ocm -> ocm.getContextParams().forEach((k, v) -> {
                if (context.findParameter((String)k) == null) {
                    context.addParameter((String)k, (String)v);
                }
            }));
            context.setOsgiServletContext(null);
            ServletContext realContext = context.getServletContext();
            highestRankedContext.clearAttributesFromPreviousCycle();
            this.clearDynamicRegistrations(contextPath, highestRanked);
            DynamicRegistrations registrations = this.dynamicRegistrations.get(contextPath);
            OsgiDynamicServletContext dynamicContext = new OsgiDynamicServletContext(highestRankedContext, registrations);
            context.setOsgiServletContext((ServletContext)dynamicContext);
            TreeSet<SCIWrapper> initializers = new TreeSet<SCIWrapper>((SortedSet)this.initializers.get(contextPath));
            initializers.add((SCIWrapper)new RegisteringContainerInitializer(highestRankedContext, registrations));
            context.setServletContainerInitializers(initializers);
            for (LifecycleListener listener : context.findLifecycleListeners()) {
                if (!(listener instanceof OsgiContextConfiguration)) continue;
                context.removeLifecycleListener(listener);
                Valve authenticationValve = ((OsgiContextConfiguration)listener).getAuthenticationValve();
                if (authenticationValve == null) continue;
                context.getPipeline().removeValve(authenticationValve);
            }
            context.addLifecycleListener(this.configurationListeners.get(highestRanked));
            this.osgiServletContexts.forEach((ocm, osc) -> {
                if (ocm.getContextPath().equals(contextPath)) {
                    osc.setContainerServletContext(realContext);
                }
            });
            for (Container child : context.findChildren()) {
                ServletModel servletModel;
                if (!(child instanceof PaxWebStandardWrapper) || (servletModel = ((PaxWebStandardWrapper)child).getServletModel()) == null || !servletModel.isResourceServlet()) continue;
                ((PaxWebStandardWrapper)child).setHighestRankedContext(highestRankedContext);
            }
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(highestRankedContext.getClassLoader());
                context.start();
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
            dynamicContext.rememberAttributesFromSCIs();
            context.setOsgiServletContext((ServletContext)highestRankedContext);
            highestRankedContext.register();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private boolean pendingTransaction(String contextPath) {
        return this.transactions.contains(contextPath);
    }

    private OsgiServletContext getHighestRankedContext(String contextPath, FilterModel model, List<OsgiContextModel> contextModels) {
        OsgiContextModel highestRankedModel = null;
        if (contextModels == null) {
            contextModels = model.getContextModels();
        }
        for (OsgiContextModel ocm : contextModels) {
            if (!ocm.getContextPath().equals(contextPath)) continue;
            highestRankedModel = ocm;
            break;
        }
        if (highestRankedModel == null) {
            LOG.warn("(dev) Can't find proper OsgiContextModel for the filter. Falling back to highest ranked OsgiContextModel for given ServletContextModel");
            highestRankedModel = this.osgiContextModels.get(contextPath).iterator().next();
        }
        return this.osgiServletContexts.get(highestRankedModel);
    }

    private void configureFilterMappings(FilterModel model, PaxWebStandardContext context) {
        if (model.getDynamicServletNames().size() > 0 || model.getDynamicUrlPatterns().size() > 0) {
            model.getDynamicServletNames().forEach(dm -> {
                if (!dm.isAfter()) {
                    context.addFilterMapBefore(new PaxWebFilterMap(model, (FilterModel.DynamicMapping)dm));
                }
            });
            model.getDynamicUrlPatterns().forEach(dm -> {
                if (!dm.isAfter()) {
                    context.addFilterMapBefore(new PaxWebFilterMap(model, (FilterModel.DynamicMapping)dm));
                }
            });
            model.getDynamicServletNames().forEach(dm -> {
                if (dm.isAfter()) {
                    context.addFilterMap(new PaxWebFilterMap(model, (FilterModel.DynamicMapping)dm));
                }
            });
            model.getDynamicUrlPatterns().forEach(dm -> {
                if (dm.isAfter()) {
                    context.addFilterMap(new PaxWebFilterMap(model, (FilterModel.DynamicMapping)dm));
                }
            });
        } else {
            for (FilterModel.Mapping map : model.getMappingsPerDispatcherTypes()) {
                context.addFilterMap(new PaxWebFilterMap(model, map));
            }
        }
    }
}

