/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal;

import jakarta.servlet.Servlet;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.ops4j.pax.web.service.spi.ServerController;
import org.ops4j.pax.web.service.spi.ServerState;
import org.ops4j.pax.web.service.spi.config.Configuration;
import org.ops4j.pax.web.service.spi.model.events.ServerEvent;
import org.ops4j.pax.web.service.spi.model.events.ServerListener;
import org.ops4j.pax.web.service.spi.task.Batch;
import org.ops4j.pax.web.service.spi.task.BatchVisitor;
import org.ops4j.pax.web.service.tomcat.internal.TomcatFactory;
import org.ops4j.pax.web.service.tomcat.internal.TomcatServerWrapper;
import org.ops4j.pax.web.service.tomcat.internal.web.TomcatResourceServlet;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TomcatServerController
implements ServerController {
    private static final Logger LOG = LoggerFactory.getLogger(TomcatServerController.class);
    private final Bundle paxWebTomcatBundle;
    private final ClassLoader classLoader;
    private final Configuration configuration;
    private ServerState state;
    private final Set<ServerListener> listeners;
    private final TomcatFactory tomcatFactory;
    private TomcatServerWrapper tomcatServerWrapper;

    TomcatServerController(Bundle paxWebTomcatBundle, ClassLoader classLoader, TomcatFactory tomcatFactory, Configuration configuration) {
        this.paxWebTomcatBundle = paxWebTomcatBundle;
        this.classLoader = classLoader;
        this.tomcatFactory = tomcatFactory;
        this.configuration = configuration;
        this.state = ServerState.UNCONFIGURED;
        this.listeners = Collections.synchronizedSet(new LinkedHashSet());
    }

    public ServerState getState() {
        return this.state;
    }

    public void configure() throws Exception {
        LOG.info("Configuring {}", (Object)this);
        if (this.state != ServerState.UNCONFIGURED) {
            throw new IllegalStateException("Can't configure Tomcat server controller in state " + String.valueOf(this.state));
        }
        this.tomcatServerWrapper = new TomcatServerWrapper(this.configuration, this.tomcatFactory, this.paxWebTomcatBundle, this.classLoader);
        this.tomcatServerWrapper.configure();
        this.state = ServerState.STOPPED;
        this.notifyListeners(new ServerEvent(ServerEvent.State.CONFIGURED, this.tomcatServerWrapper.getAddresses(false)));
    }

    public void start() throws Exception {
        LOG.info("Starting {}", (Object)this);
        if (this.state != ServerState.STOPPED) {
            throw new IllegalStateException("Can't start Tomcat server controller in state " + String.valueOf(this.state));
        }
        this.tomcatServerWrapper.start();
        this.state = ServerState.STARTED;
        this.notifyListeners(new ServerEvent(ServerEvent.State.STARTED, this.tomcatServerWrapper.getAddresses(true)));
    }

    public void stop() throws Exception {
        LOG.info("Stopping {}", (Object)this);
        if (this.state != ServerState.STARTED) {
            throw new IllegalStateException("Can't stop Tomcat server controller in state " + String.valueOf(this.state));
        }
        this.tomcatServerWrapper.stop();
        this.state = ServerState.STOPPED;
        this.notifyListeners(new ServerEvent(ServerEvent.State.STOPPED, null));
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void addListener(ServerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("ServerListener is null");
        }
        if (this.state == ServerState.STOPPED) {
            listener.stateChanged(new ServerEvent(ServerEvent.State.CONFIGURED, this.tomcatServerWrapper.getAddresses(false)));
        } else if (this.state == ServerState.STARTED) {
            listener.stateChanged(new ServerEvent(ServerEvent.State.STARTED, this.tomcatServerWrapper.getAddresses(true)));
        }
        this.listeners.add(listener);
    }

    public void removeListener(ServerListener listener) {
        this.listeners.remove(listener);
    }

    void notifyListeners(ServerEvent event) {
        for (ServerListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servlet createResourceServlet(URL urlBase, String base) {
        File baseDirectory;
        try {
            baseDirectory = urlBase == null ? null : new File(urlBase.toURI());
        }
        catch (URISyntaxException notPossbleButStill) {
            throw new IllegalArgumentException(notPossbleButStill.getMessage(), notPossbleButStill);
        }
        String chroot = baseDirectory == null ? base : null;
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(TomcatServerWrapper.class.getClassLoader());
            TomcatResourceServlet tomcatResourceServlet = new TomcatResourceServlet(baseDirectory, chroot, this.configuration.resources());
            return tomcatResourceServlet;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    public void sendBatch(Batch batch) {
        LOG.info("Receiving {}", (Object)batch);
        if (this.state == ServerState.UNCONFIGURED) {
            throw new IllegalStateException("Can't process batch in Tomcat server controller in state " + String.valueOf(this.state));
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            batch.accept((BatchVisitor)this.tomcatServerWrapper);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    public String toString() {
        return "TomcatServerController{configuration=" + this.configuration.id() + ",state=" + String.valueOf(this.state) + "}";
    }
}

