/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSessionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.connector.Request;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.valves.ValveBase;
import org.apache.tomcat.util.descriptor.web.ErrorPage;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.elements.ErrorPageModel;
import org.ops4j.pax.web.service.spi.model.elements.EventListenerKey;
import org.ops4j.pax.web.service.spi.model.elements.EventListenerModel;
import org.ops4j.pax.web.service.spi.model.elements.FilterModel;
import org.ops4j.pax.web.service.spi.model.elements.ServletModel;
import org.ops4j.pax.web.service.spi.servlet.Default404Servlet;
import org.ops4j.pax.web.service.spi.servlet.OsgiFilterChain;
import org.ops4j.pax.web.service.spi.servlet.OsgiScopedServletContext;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContext;
import org.ops4j.pax.web.service.spi.servlet.OsgiSessionAttributeListener;
import org.ops4j.pax.web.service.spi.servlet.PreprocessorFilterConfig;
import org.ops4j.pax.web.service.spi.servlet.SCIWrapper;
import org.ops4j.pax.web.service.tomcat.internal.PaxWebFilterDef;
import org.ops4j.pax.web.service.tomcat.internal.PaxWebFilterMap;
import org.ops4j.pax.web.service.tomcat.internal.PaxWebStandardContextValve;
import org.ops4j.pax.web.service.tomcat.internal.PaxWebStandardWrapper;
import org.osgi.service.servlet.whiteboard.Preprocessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaxWebStandardContext
extends StandardContext {
    public static final Logger LOG = LoggerFactory.getLogger(PaxWebStandardContext.class);
    public static final String PAXWEB_STANDARD_CONTEXT = ".paxweb.standard.context";
    public static final String PAXWEB_STANDARD_WRAPPER = ".paxweb.standard.wrapper";
    public static final String PAXWEB_TOMCAT_REQUEST = ".paxweb.tomcat.request";
    private OsgiServletContext defaultServletContext;
    private OsgiContextModel defaultOsgiContextModel;
    private WebContainerContext defaultWebContainerContext;
    private String osgiInitFilterName;
    private ServletContext osgiServletContext;
    private final List<PreprocessorFilterConfig> preprocessors = new LinkedList<PreprocessorFilterConfig>();
    private final Collection<SCIWrapper> servletContainerInitializers = new LinkedList<SCIWrapper>();
    private final Map<EventListenerKey, Object> rankedListeners = new TreeMap<EventListenerKey, Object>();
    private final List<Object> orderedListeners = new ArrayList<Object>();
    private final OsgiSessionAttributeListener osgiSessionsBridge;
    private String[] virtualHosts;
    private boolean[] virtualHostWildcards;
    private String[] connectorNames;
    private boolean whiteboardTCCL;

    public PaxWebStandardContext(Default404Servlet defaultServlet, OsgiSessionAttributeListener osgiSessionsBridge) {
        this.getPipeline().addValve(new PaxWebStandardContextValve((ValveBase)this.getPipeline().getBasic(), defaultServlet));
        this.osgiSessionsBridge = osgiSessionsBridge;
        this.setClearReferencesRmiTargets(false);
        this.setClearReferencesThreadLocals(false);
    }

    public void createInitialOsgiFilter() {
        Filter osgiInitFilter = (request, response, chain) -> {
            PaxWebStandardContext delegate = this;
            PaxWebStandardWrapper wrapper = (PaxWebStandardWrapper)request.getAttribute(PAXWEB_STANDARD_WRAPPER);
            request.removeAttribute(PAXWEB_STANDARD_WRAPPER);
            Request tomcatRequest = (Request)request.getAttribute(PAXWEB_TOMCAT_REQUEST);
            request.removeAttribute(PAXWEB_TOMCAT_REQUEST);
            if (wrapper == null) {
                Container[] children;
                for (Container c : children = this.findChildren()) {
                    if (!(c instanceof PaxWebStandardWrapper) || !(request instanceof HttpServletRequest) || c.getName() == null || !c.getName().equals(((HttpServletRequest)request).getHttpServletMapping().getServletName())) continue;
                    wrapper = (PaxWebStandardWrapper)c;
                }
            }
            Consumer<HttpServletRequest> authListener = req -> {
                Object user = req.getAttribute("org.osgi.service.http.authentication.remote.user");
                Object authType = req.getAttribute("org.osgi.service.http.authentication.type");
                if (user != null || authType != null) {
                    String authMethod;
                    String userName = user != null ? user.toString() : null;
                    String string = authMethod = authType != null ? authType.toString() : null;
                    if (tomcatRequest.getPrincipal() == null) {
                        tomcatRequest.setUserPrincipal(new GenericPrincipal(userName, Collections.emptyList(), null));
                    }
                }
            };
            List<Preprocessor> preprocessorInstances = this.preprocessors.stream().map(PreprocessorFilterConfig::getInstance).toList();
            OsgiFilterChain osgiChain = wrapper != null && !wrapper.is404() ? new OsgiFilterChain(new ArrayList<Preprocessor>(preprocessorInstances), wrapper.getServletContext(), wrapper.getWebContainerContext(), null, this.osgiSessionsBridge, authListener) : new OsgiFilterChain(new ArrayList<Preprocessor>(preprocessorInstances), (ServletContext)delegate.getDefaultServletContext(), delegate.getDefaultWebContainerContext(), null, this.osgiSessionsBridge, authListener);
            osgiChain.setChain(chain);
            osgiChain.doFilter(request, response);
        };
        FilterModel filterModel = new FilterModel("__osgi@" + System.identityHashCode(osgiInitFilter), new String[]{"*"}, null, null, osgiInitFilter, null, Boolean.valueOf(true));
        ((FilterModel.Mapping)filterModel.getMappingsPerDispatcherTypes().get(0)).setDispatcherTypes(new DispatcherType[]{DispatcherType.ERROR, DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST, DispatcherType.ASYNC});
        PaxWebFilterDef osgiInitFilterDef = new PaxWebFilterDef(filterModel, true, null);
        osgiInitFilterDef.setWhiteboardTCCL(this.whiteboardTCCL);
        PaxWebFilterMap osgiInitFilterMap = new PaxWebFilterMap(filterModel, true);
        this.addFilterDef(osgiInitFilterDef);
        this.addFilterMapBefore(osgiInitFilterMap);
    }

    public void setDefaultServletContext(OsgiServletContext defaultServletContext) {
        this.defaultServletContext = defaultServletContext;
    }

    public void setOsgiServletContext(ServletContext osgiServletContext) {
        this.osgiServletContext = osgiServletContext;
    }

    public ServletContext getOsgiServletContext() {
        return this.osgiServletContext;
    }

    @Override
    public void addServletContainerInitializer(ServletContainerInitializer sci, Set<Class<?>> classes) {
    }

    public void setServletContainerInitializers(Collection<SCIWrapper> wrappers) {
        this.servletContainerInitializers.clear();
        this.servletContainerInitializers.addAll(wrappers);
    }

    @Override
    public ServletContext getServletContext() {
        ServletContext superContext = super.getServletContext();
        if (this.osgiServletContext != null) {
            return this.osgiServletContext;
        }
        return superContext;
    }

    @Override
    public boolean filterStart() {
        for (PreprocessorFilterConfig fc : this.preprocessors) {
            try {
                fc.getInstance().init((FilterConfig)fc);
            }
            catch (ServletException e) {
                LOG.warn("Problem during preprocessor initialization: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return super.filterStart();
    }

    @Override
    public boolean filterStop() {
        boolean result = super.filterStop();
        for (PreprocessorFilterConfig fc : this.preprocessors) {
            fc.destroy();
        }
        return result;
    }

    public boolean isStarted() {
        return this.getState() == LifecycleState.STARTED || this.getState() == LifecycleState.STARTING || this.getState() == LifecycleState.STARTING_PREP || this.getState() == LifecycleState.INITIALIZING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean listenerStart() {
        boolean ok = true;
        for (SCIWrapper wrapper : this.servletContainerInitializers) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getParentClassLoader());
                wrapper.onStartup();
            }
            catch (ServletException e) {
                LOG.error(sm.getString("standardContext.sciFail"), (Throwable)e);
                ok = false;
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
        if (ok) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getParentClassLoader());
                super.setApplicationLifecycleListeners(new Object[0]);
                boolean bl = super.listenerStart();
                return bl;
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
        return false;
    }

    @Override
    public ClassLoader bind(boolean usePrivilegedAction, ClassLoader originalClassLoader) {
        return originalClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        Container[] children = this.findChildren();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.osgiServletContext.getClassLoader());
            super.stopInternal();
            for (Container child : children) {
                ErrorPage errorPage;
                if (!(child instanceof PaxWebStandardWrapper)) continue;
                PaxWebStandardWrapper pwsw = (PaxWebStandardWrapper)child;
                ServletModel model = pwsw.getServletModel();
                OsgiScopedServletContext osgiServletContext = (OsgiScopedServletContext)pwsw.getServletContext();
                PaxWebStandardWrapper wrapper = new PaxWebStandardWrapper(model, pwsw.getOsgiContextModel(), osgiServletContext.getOsgiContext(), this);
                wrapper.setWhiteboardTCCL(this.whiteboardTCCL);
                boolean isDefaultResourceServlet = model.isResourceServlet();
                for (String pattern : model.getUrlPatterns()) {
                    isDefaultResourceServlet &= "/".equals(pattern);
                }
                if (model.isResourceServlet()) {
                    wrapper.addInitParameter("pathInfoOnly", Boolean.toString(!isDefaultResourceServlet));
                }
                this.addChild(wrapper);
                String name = model.getName();
                for (String pattern : model.getUrlPatterns()) {
                    this.removeServletMapping(pattern);
                    this.addServletMappingDecoded(pattern, name, false);
                }
                ErrorPageModel epm = model.getErrorPageModel();
                if (epm == null || !epm.isValid()) continue;
                String location = epm.getLocation();
                for (String ex : epm.getExceptionClassNames()) {
                    errorPage = new ErrorPage();
                    errorPage.setExceptionType(ex);
                    errorPage.setLocation(location);
                    this.addErrorPage(errorPage);
                }
                Iterator pattern = epm.getErrorCodes().iterator();
                while (pattern.hasNext()) {
                    int code = (Integer)pattern.next();
                    errorPage = new ErrorPage();
                    errorPage.setErrorCode(code);
                    errorPage.setLocation(location);
                    this.addErrorPage(errorPage);
                }
                if (epm.isXx4()) {
                    for (int c = 400; c < 500; ++c) {
                        ErrorPage errorPage2 = new ErrorPage();
                        errorPage2.setErrorCode(c);
                        errorPage2.setLocation(location);
                        this.addErrorPage(errorPage2);
                    }
                }
                if (!epm.isXx5()) continue;
                for (int c = 500; c < 600; ++c) {
                    ErrorPage errorPage3 = new ErrorPage();
                    errorPage3.setErrorCode(c);
                    errorPage3.setLocation(location);
                    this.addErrorPage(errorPage3);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        this.setOsgiServletContext(null);
        this.rankedListeners.entrySet().removeIf(e -> ((EventListenerKey)e.getKey()).getRanklessPosition() >= 0);
        this.orderedListeners.clear();
    }

    @Override
    public void addApplicationEventListener(Object listener) {
        this.addApplicationEventListener(null, listener);
    }

    public void addApplicationEventListener(EventListenerModel model, Object listener) {
        if (model == null || model.isDynamic()) {
            this.orderedListeners.add(listener);
        } else {
            this.rankedListeners.put(EventListenerKey.ofModel((EventListenerModel)model), listener);
        }
        if (!ServletContextListener.class.isAssignableFrom(listener.getClass()) && this.isStarted()) {
            super.addApplicationEventListener(listener);
        }
    }

    @Override
    public void addApplicationLifecycleListener(Object listener) {
        this.addApplicationLifecycleListener(null, listener);
    }

    public void addApplicationLifecycleListener(EventListenerModel model, Object listener) {
        this.addApplicationEventListener(model, listener);
    }

    public void removeListener(EventListenerModel model, Object listener) {
        if (model == null || model.isDynamic()) {
            this.orderedListeners.remove(listener);
        } else {
            this.rankedListeners.remove(EventListenerKey.ofModel((EventListenerModel)model));
        }
    }

    @Override
    public void setApplicationLifecycleListeners(Object[] listeners) {
        if (this.getState() == LifecycleState.STOPPING) {
            super.setApplicationLifecycleListeners(listeners);
            return;
        }
        for (int pos = 0; pos < this.orderedListeners.size(); ++pos) {
            Object el = this.orderedListeners.get(pos);
            this.rankedListeners.put(EventListenerKey.ofPosition((int)pos), el);
        }
        ArrayList<Object> lifecycleListeners = new ArrayList<Object>();
        ArrayList<Object> eventListeners = new ArrayList<Object>();
        for (Object listener : this.rankedListeners.values()) {
            if (listener instanceof ServletContextListener || listener instanceof HttpSessionListener) {
                lifecycleListeners.add(listener);
            }
            eventListeners.add(listener);
        }
        super.setApplicationLifecycleListeners(lifecycleListeners.toArray());
        super.setApplicationEventListeners(eventListeners.toArray());
    }

    public void setDefaultOsgiContextModel(OsgiContextModel defaultOsgiContextModel, WebContainerContext resolvedWebContainerContext) {
        this.defaultOsgiContextModel = defaultOsgiContextModel;
        this.defaultWebContainerContext = resolvedWebContainerContext;
    }

    public OsgiServletContext getDefaultServletContext() {
        return this.defaultServletContext;
    }

    public OsgiContextModel getDefaultOsgiContextModel() {
        return this.defaultOsgiContextModel;
    }

    public WebContainerContext getDefaultWebContainerContext() {
        return this.defaultWebContainerContext;
    }

    public List<PreprocessorFilterConfig> getPreprocessors() {
        return this.preprocessors;
    }

    public void setVirtualHosts(String[] virtualHosts) {
        int size;
        int n = size = virtualHosts == null ? 0 : virtualHosts.length;
        if (size == 0) {
            this.virtualHosts = null;
            this.virtualHostWildcards = null;
            this.connectorNames = null;
        } else {
            this.virtualHosts = new String[size];
            this.virtualHostWildcards = new boolean[size];
            this.connectorNames = new String[size];
            for (int i = 0; i < size; ++i) {
                String host;
                this.virtualHosts[i] = null;
                this.virtualHostWildcards[i] = false;
                this.connectorNames[i] = null;
                String vh = virtualHosts[i];
                if (vh == null || "".equals(vh.trim())) continue;
                if (vh.startsWith("@")) {
                    this.connectorNames[i] = vh.substring(1);
                    continue;
                }
                String connector = null;
                int atpos = vh.indexOf("@");
                if (atpos >= 0) {
                    host = vh.substring(0, atpos).trim();
                    connector = vh.substring(atpos + 1).trim();
                } else {
                    host = vh.trim();
                }
                if (connector != null && !"".equals(connector)) {
                    this.connectorNames[i] = connector;
                }
                if ("".equals(host)) continue;
                this.virtualHosts[i] = host;
                if (!host.startsWith("*.")) continue;
                this.virtualHostWildcards[i] = true;
                this.virtualHosts[i] = host.substring(1);
            }
        }
    }

    public boolean matches(String vhost, String connectorName) {
        if (this.virtualHosts == null || this.virtualHosts.length == 0) {
            return true;
        }
        for (int i = 0; i < this.virtualHosts.length; ++i) {
            int index;
            String vh = this.virtualHosts[i];
            String connector = this.connectorNames[i];
            if (connector != null) {
                if (!connector.equalsIgnoreCase(connectorName)) continue;
                if (vh == null) {
                    return true;
                }
            }
            if (vh == null || !(this.virtualHostWildcards[i] ? (index = vhost.indexOf(".")) >= 0 && vhost.substring(index).equalsIgnoreCase(vh) : vhost.equalsIgnoreCase(vh))) continue;
            return true;
        }
        return false;
    }

    public void setWhiteboardTCCL(boolean whiteboardTCCL) {
        this.whiteboardTCCL = whiteboardTCCL;
    }
}

