/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal;

import jakarta.servlet.SessionCookieConfig;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import org.apache.catalina.Authenticator;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.BasicAuthenticator;
import org.apache.catalina.authenticator.DigestAuthenticator;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.authenticator.NonLoginAuthenticator;
import org.apache.catalina.authenticator.SSLAuthenticator;
import org.apache.catalina.authenticator.SpnegoAuthenticator;
import org.apache.tomcat.util.descriptor.web.LoginConfig;
import org.apache.tomcat.util.descriptor.web.SecurityCollection;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.apache.tomcat.util.digester.Digester;
import org.ops4j.pax.web.service.AuthenticatorService;
import org.ops4j.pax.web.service.spi.config.Configuration;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.elements.LoginConfigModel;
import org.ops4j.pax.web.service.spi.model.elements.SecurityConfigurationModel;
import org.ops4j.pax.web.service.spi.model.elements.SecurityConstraintModel;
import org.ops4j.pax.web.service.spi.model.elements.SessionConfigurationModel;
import org.ops4j.pax.web.service.tomcat.internal.PaxWebStandardContext;
import org.ops4j.pax.web.service.tomcat.internal.TomcatFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class OsgiContextConfiguration
implements LifecycleListener {
    public static final Logger LOG = LoggerFactory.getLogger(OsgiContextConfiguration.class);
    private final OsgiContextModel osgiContextModel;
    private final TomcatFactory tomcatFactory;
    private Valve authenticationValve;
    private final Configuration configuration;
    private final Map<String, TreeMap<OsgiContextModel, SecurityConfigurationModel>> contextSecurityConstraints;

    public OsgiContextConfiguration(OsgiContextModel osgiContextModel, Configuration configuration, TomcatFactory tomcatFactory, Map<String, TreeMap<OsgiContextModel, SecurityConfigurationModel>> contextSecurityConstraints) {
        this.osgiContextModel = osgiContextModel;
        this.tomcatFactory = tomcatFactory;
        this.configuration = configuration;
        this.contextSecurityConstraints = contextSecurityConstraints;
    }

    public Valve getAuthenticationValve() {
        return this.authenticationValve;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getType().equals("configure_start")) {
            LoginConfig lc;
            ArrayList<String> connectors;
            Map<OsgiContextModel, SecurityConfigurationModel> allSecConfigs = (Map<OsgiContextModel, SecurityConfigurationModel>)this.contextSecurityConstraints.get(this.osgiContextModel.getContextPath());
            SecurityConfigurationModel securityConfig = null;
            if (allSecConfigs != null && allSecConfigs.size() > 0) {
                securityConfig = (SecurityConfigurationModel)allSecConfigs.values().iterator().next();
            }
            if (securityConfig == null) {
                securityConfig = this.osgiContextModel.getSecurityConfiguration();
                allSecConfigs = Collections.singletonMap(this.osgiContextModel, securityConfig);
            }
            LoginConfigModel loginConfig = securityConfig != null ? securityConfig.getLoginConfig() : null;
            PaxWebStandardContext context = (PaxWebStandardContext)event.getSource();
            SessionConfigurationModel sc = this.osgiContextModel.getSessionConfiguration();
            if (sc != null) {
                SessionCookieConfig scc;
                if (sc.getSessionTimeout() != null) {
                    context.setSessionTimeout(sc.getSessionTimeout());
                }
                if ((scc = sc.getSessionCookieConfig()) == null) {
                    scc = this.configuration.session().getDefaultSessionCookieConfig();
                }
                SessionCookieConfig config = context.getServletContext().getSessionCookieConfig();
                if (scc != null && config != null) {
                    if (scc.getName() != null) {
                        context.setSessionCookieName(scc.getName());
                        config.setName(scc.getName());
                    }
                    if (scc.getDomain() != null) {
                        context.setSessionCookieDomain(scc.getDomain());
                        config.setDomain(scc.getDomain());
                    }
                    if (scc.getPath() != null) {
                        context.setSessionCookiePath(scc.getPath());
                        config.setPath(scc.getPath());
                    }
                    context.setUseHttpOnly(scc.isHttpOnly());
                    config.setHttpOnly(scc.isHttpOnly());
                    config.setSecure(scc.isSecure());
                    config.setMaxAge(scc.getMaxAge());
                    config.setComment(scc.getComment());
                    if (sc.getTrackingModes().size() > 0) {
                        context.getServletContext().setSessionTrackingModes(sc.getTrackingModes());
                    }
                }
            }
            ArrayList<Object> allVirtualHosts = new ArrayList<Object>();
            ArrayList<String> vhosts = new ArrayList<String>(this.osgiContextModel.getVirtualHosts());
            if (vhosts.isEmpty()) {
                vhosts.addAll(Arrays.asList(this.configuration.server().getVirtualHosts()));
            }
            if ((connectors = new ArrayList<String>(this.osgiContextModel.getConnectors())).isEmpty()) {
                connectors.addAll(Arrays.asList(this.configuration.server().getConnectors()));
            }
            for (String vhost : vhosts) {
                if (vhost == null || "".equals(vhost.trim())) continue;
                if (vhost.startsWith("@")) {
                    allVirtualHosts.add(vhost);
                    continue;
                }
                allVirtualHosts.add(vhost);
            }
            for (String c : connectors) {
                if (c == null || "".equals(c.trim())) continue;
                if (c.startsWith("@")) {
                    allVirtualHosts.add(c);
                    continue;
                }
                allVirtualHosts.add("@" + c);
            }
            context.setVirtualHosts(allVirtualHosts.toArray(new String[0]));
            Valve[] valves = context.getPipeline().getValves();
            ArrayList<Valve> valvesToRemove = new ArrayList<Valve>(valves.length);
            for (Valve v2 : valves) {
                String pkg;
                if (v2 == null || (pkg = v2.getClass().getPackage().getName()).startsWith("org.apache.tomcat") || pkg.startsWith("org.apache.catalina") || pkg.startsWith("org.ops4j.pax.web")) continue;
                valvesToRemove.add(v2);
            }
            valvesToRemove.forEach(v -> context.getPipeline().removeValve((Valve)v));
            ContainerListener[] listeners = context.findContainerListeners();
            ArrayList<ContainerListener> listenersToRemove = new ArrayList<ContainerListener>(listeners.length);
            for (ContainerListener cl : listeners) {
                String pkg;
                if (cl == null || (pkg = cl.getClass().getPackage().getName()).startsWith("org.apache.tomcat") || pkg.startsWith("org.apache.catalina") || pkg.startsWith("org.ops4j.pax.web")) continue;
                listenersToRemove.add(cl);
            }
            listenersToRemove.forEach(context::removeContainerListener);
            LifecycleListener[] llisteners = context.findLifecycleListeners();
            ArrayList<LifecycleListener> llistenersToRemove = new ArrayList<LifecycleListener>(listeners.length);
            for (LifecycleListener lifecycleListener : llisteners) {
                String pkg;
                if (lifecycleListener == null || (pkg = lifecycleListener.getClass().getPackage().getName()).startsWith("org.apache.tomcat") || pkg.startsWith("org.apache.catalina") || pkg.startsWith("org.ops4j.pax.web")) continue;
                llistenersToRemove.add(lifecycleListener);
            }
            llistenersToRemove.forEach(context::removeLifecycleListener);
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader((ClassLoader)this.osgiContextModel.getClassLoader());
            try {
                String path;
                ArrayList<URL> contextConfigs = new ArrayList<URL>();
                if (this.configuration.server().getContextConfigurationFile() != null) {
                    LOG.info("Found global Tomcat context configuration file: {}", (Object)this.configuration.server().getContextConfigurationFile());
                    contextConfigs.add(this.configuration.server().getContextConfigurationFile().toURI().toURL());
                }
                for (URL uRL : this.osgiContextModel.getServerSpecificDescriptors()) {
                    path = uRL.getPath();
                    if (!path.endsWith("/META-INF/context.xml")) continue;
                    contextConfigs.add(uRL);
                }
                for (URL uRL : contextConfigs) {
                    path = uRL.getPath();
                    LOG.info("Processing context specific {} for {}", (Object)uRL, (Object)this.osgiContextModel.getContextPath());
                    Digester digester = this.tomcatFactory.createContextDigester();
                    if (this.osgiContextModel.getClassLoader() != null) {
                        digester.setClassLoader((ClassLoader)this.osgiContextModel.getClassLoader());
                    } else {
                        digester.setClassLoader(tccl);
                    }
                    digester.push((Object)context.getParent());
                    digester.push((Object)context);
                    try {
                        InputStream inputStream = uRL.openStream();
                        try {
                            digester.parse(inputStream);
                        }
                        finally {
                            if (inputStream == null) continue;
                            inputStream.close();
                        }
                    }
                    catch (IOException | SAXException exception) {
                        LOG.warn("Problem parsing {}: {}", new Object[]{uRL, exception.getMessage(), exception});
                    }
                }
            }
            catch (MalformedURLException e) {
                LOG.warn("Can't process context configuration file: {}", (Object)e.getMessage(), (Object)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
            boolean noAuth = false;
            if (loginConfig == null) {
                this.authenticationValve = null;
                lc = new LoginConfig("NONE", null, null, null);
                noAuth = true;
            } else {
                lc = new LoginConfig(loginConfig.getAuthMethod(), loginConfig.getRealmName(), loginConfig.getFormLoginPage(), loginConfig.getFormErrorPage());
                this.authenticationValve = (Valve)((Object)context.getAuthenticator());
                if (this.authenticationValve == null) {
                    void var19_44;
                    Object var19_36 = null;
                    switch (loginConfig.getAuthMethod().toUpperCase()) {
                        case "BASIC": {
                            BasicAuthenticator basicAuthenticator = new BasicAuthenticator();
                            if (lc.getRealmName() != null) break;
                            lc.setRealmName("default");
                            break;
                        }
                        case "DIGEST": {
                            DigestAuthenticator digestAuthenticator = new DigestAuthenticator();
                            digestAuthenticator.setNonceValidity(this.configuration.security().getDigestAuthMaxNonceAge());
                            DigestAuthenticator digestAuthenticator2 = digestAuthenticator;
                            if (lc.getRealmName() != null) break;
                            lc.setRealmName("default");
                            break;
                        }
                        case "CLIENT-CERT": 
                        case "CLIENT_CERT": {
                            SSLAuthenticator sSLAuthenticator = new SSLAuthenticator();
                            break;
                        }
                        case "FORM": {
                            FormAuthenticator formAuthenticator = new FormAuthenticator();
                            break;
                        }
                        case "SPNEGO": {
                            SpnegoAuthenticator spnegoAuthenticator = new SpnegoAuthenticator();
                            break;
                        }
                        case "NONE": {
                            NonLoginAuthenticator nonLoginAuthenticator = new NonLoginAuthenticator();
                            break;
                        }
                        default: {
                            Authenticator customAuthenticator = this.getAuthenticator(loginConfig.getAuthMethod().toUpperCase());
                            if (customAuthenticator == null) {
                                LOG.warn("Can't find Tomcat Authenticator for auth method {}", (Object)loginConfig.getAuthMethod().toUpperCase());
                                break;
                            }
                            LOG.debug("Setting custom Tomcat authenticator {}", (Object)customAuthenticator);
                            Authenticator authenticator = customAuthenticator;
                        }
                    }
                    this.authenticationValve = (Valve)var19_44;
                    if (this.authenticationValve != null) {
                        context.getPipeline().addValve(this.authenticationValve);
                    }
                }
            }
            if (this.authenticationValve == null) {
                noAuth = true;
            }
            context.setLoginConfig(lc);
            for (SecurityConstraint securityConstraint : context.findConstraints()) {
                context.removeConstraint(securityConstraint);
            }
            for (String string : context.findSecurityRoles()) {
                context.removeSecurityRole(string);
            }
            if (!noAuth) {
                ArrayList arrayList = new ArrayList();
                LinkedHashSet allRoles = new LinkedHashSet();
                allSecConfigs.values().forEach(sec -> {
                    allConstraints.addAll(sec.getSecurityConstraints());
                    allRoles.addAll(sec.getSecurityRoles());
                });
                boolean allAuthenticatedUsersIsAppRole = allRoles.contains("**");
                for (SecurityConstraintModel scm : arrayList) {
                    SecurityConstraint constraint = new SecurityConstraint();
                    constraint.setDisplayName(scm.getName());
                    constraint.setUserConstraint(scm.getTransportGuarantee().name());
                    constraint.setAuthConstraint(scm.isAuthRolesSet());
                    for (String role : scm.getAuthRoles()) {
                        constraint.addAuthRole(role);
                    }
                    for (SecurityConstraintModel.WebResourceCollection col : scm.getWebResourceCollections()) {
                        SecurityCollection wrc = new SecurityCollection();
                        wrc.setName(col.getName());
                        boolean methodSet = false;
                        for (String method : col.getMethods()) {
                            wrc.addMethod(method);
                            methodSet = true;
                        }
                        if (!methodSet) {
                            for (String method : col.getOmittedMethods()) {
                                wrc.addOmittedMethod(method);
                            }
                        }
                        for (String pattern : col.getPatterns()) {
                            wrc.addPattern(pattern);
                        }
                        constraint.addCollection(wrc);
                    }
                    if (allAuthenticatedUsersIsAppRole) {
                        constraint.treatAllAuthenticatedUsersAsApplicationRole();
                    }
                    context.addConstraint(constraint);
                }
                for (String role : allRoles) {
                    context.addSecurityRole(role);
                }
            }
            context.setConfigured(true);
        }
    }

    private Authenticator getAuthenticator(String method) {
        ServiceLoader<AuthenticatorService> sl = ServiceLoader.load(AuthenticatorService.class, this.getClass().getClassLoader());
        for (AuthenticatorService svc : sl) {
            try {
                Valve auth = (Valve)svc.getAuthenticatorService(method, Valve.class);
                if (auth == null || !Authenticator.class.isAssignableFrom(auth.getClass())) continue;
                return (Authenticator)((Object)auth);
            }
            catch (Throwable t) {
                LOG.debug("Unable to load AuthenticatorService for: " + method, t);
            }
        }
        return null;
    }
}

