/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ErrorReportValve;
import org.apache.coyote.ActionCode;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.json.JSONFilter;
import org.apache.tomcat.util.res.StringManager;

public class JsonErrorReportValve
extends ErrorReportValve {
    @Override
    protected void report(Request request, Response response, Throwable throwable) {
        String description;
        int statusCode = response.getStatus();
        if (statusCode < 400 || response.getContentWritten() > 0L || !response.setErrorReported()) {
            return;
        }
        AtomicBoolean result = new AtomicBoolean(false);
        response.getCoyoteResponse().action(ActionCode.IS_IO_ALLOWED, result);
        if (!result.get()) {
            return;
        }
        StringManager smClient = StringManager.getManager((String)"org.apache.catalina.valves", request.getLocales());
        response.setLocale(smClient.getLocale());
        String type = throwable != null ? smClient.getString("errorReportValve.exceptionReport") : smClient.getString("errorReportValve.statusReport");
        String message = response.getMessage();
        if (message == null && throwable != null) {
            message = throwable.getMessage();
        }
        if (message == null) {
            message = "";
        }
        if ((description = smClient.getString("http." + statusCode + ".desc")) == null) {
            if (message.isEmpty()) {
                return;
            }
            description = smClient.getString("errorReportValve.noDescription");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{\n  \"type\": \"").append(JSONFilter.escape((String)type)).append("\",\n");
        sb.append("  \"status\": ").append(statusCode).append(",\n");
        sb.append("  \"message\": \"").append(JSONFilter.escape((String)message)).append("\",\n");
        sb.append("  \"description\": \"").append(JSONFilter.escape((String)description));
        if (throwable != null) {
            sb.append("\",\n");
            sb.append("  \"throwable\": [");
            boolean first = true;
            do {
                int i;
                if (!first) {
                    sb.append(',');
                } else {
                    first = false;
                }
                sb.append('\"').append(JSONFilter.escape((String)throwable.toString())).append('\"');
                StackTraceElement[] elements = throwable.getStackTrace();
                int pos = elements.length;
                for (i = elements.length - 1; i >= 0; --i) {
                    if (!elements[i].getClassName().startsWith("org.apache.catalina.core.ApplicationFilterChain") || !elements[i].getMethodName().equals("doFilter")) continue;
                    pos = i;
                    break;
                }
                for (i = 0; i < pos; ++i) {
                    if (elements[i].getClassName().startsWith("org.apache.catalina.core.")) continue;
                    sb.append(',').append('\"').append(' ').append(JSONFilter.escape((String)elements[i].toString())).append('\"');
                }
            } while ((throwable = throwable.getCause()) != null);
            sb.append("]\n}");
        } else {
            sb.append("\"\n}");
        }
        try {
            block18: {
                try {
                    response.setContentType("application/json");
                    response.setCharacterEncoding("utf-8");
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable((Throwable)t);
                    if (!this.container.getLogger().isDebugEnabled()) break block18;
                    this.container.getLogger().debug((Object)sm.getString("errorReportValve.contentTypeFail"), t);
                }
            }
            PrintWriter writer = response.getReporter();
            if (writer != null) {
                ((Writer)writer).write(sb.toString());
                response.finishResponse();
            }
        }
        catch (IOException | IllegalStateException exception) {
            // empty catch block
        }
    }
}

