/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.Adapter;
import org.apache.coyote.http11.AbstractHttp11JsseProtocol;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.Nio2Channel;
import org.apache.tomcat.util.net.Nio2Endpoint;
import org.apache.tomcat.util.threads.TaskQueue;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;
import org.ops4j.pax.web.service.tomcat.internal.PaxWebCoyoteAdapter;
import org.ops4j.pax.web.service.tomcat.internal.PaxWebTaskThreadFactory;

public class PaxWebHttp11Nio2Protocol
extends AbstractHttp11JsseProtocol<Nio2Channel> {
    private static final Log LOG = LogFactory.getLog(PaxWebHttp11Nio2Protocol.class);
    private String name;
    private Connector connector;

    public PaxWebHttp11Nio2Protocol() {
        super(new Nio2Endpoint(){

            @Override
            public void createExecutor() {
                TaskQueue taskqueue = new TaskQueue();
                PaxWebTaskThreadFactory tf = new PaxWebTaskThreadFactory(this.getName() + "-exec-", this.getDaemon(), this.getThreadPriority());
                ThreadPoolExecutor executor = new ThreadPoolExecutor(this.getMinSpareThreads(), this.getMaxThreads(), 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)taskqueue, tf);
                this.setExecutor(executor);
                this.internalExecutor = true;
                taskqueue.setParent(executor);
            }
        });
    }

    @Override
    protected Log getLog() {
        return LOG;
    }

    @Override
    protected String getNamePrefix() {
        if (this.isSSLEnabled()) {
            return "https-" + this.getSslImplementationShortName() + "-nio2";
        }
        return "http-nio2";
    }

    public String getPaxWebConnectorName() {
        return this.name;
    }

    public void setPaxWebConnectorName(String name) {
        this.name = name;
    }

    @Override
    public void setAdapter(Adapter adapter) {
        super.setAdapter(new PaxWebCoyoteAdapter(this.connector));
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }
}

